<?php
// Include initialization file
require_once '../init.php';

// Check if user is logged in and has admin role
if (!isLoggedIn() || !isAdmin()) {
    setFlashMessage('Anda tidak memiliki izin untuk mengakses halaman ini.', 'danger');
    redirect('../index.php');
}

// Get statistics for dashboard
$totalUsers = $db->getOne("SELECT COUNT(*) FROM users");
$totalPatients = $db->getOne("SELECT COUNT(*) FROM patients");
$totalRecords = $db->getOne("SELECT COUNT(*) FROM medical_records");
$totalDoctors = $db->getOne("SELECT COUNT(*) FROM users WHERE role = 'doctor'");

// Get recent activities
$recentActivities = $db->getAll("
    SELECT al.*, u.name, u.role 
    FROM activity_logs al
    LEFT JOIN users u ON al.user_id = u.id
    ORDER BY al.created_at DESC
    LIMIT 10
");

// Recent users
$recentUsers = $db->getAll("
    SELECT * FROM users
    ORDER BY created_at DESC
    LIMIT 5
");
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title>Admin Dashboard &mdash; Sistem Rekam Medis Ortodontik</title>

    <!-- General CSS Files -->
    <link rel="stylesheet" href="../assets/modules/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/modules/fontawesome/css/all.min.css">

    <!-- CSS Libraries -->
    <link rel="stylesheet" href="../assets/modules/jqvmap/dist/jqvmap.min.css">
    <link rel="stylesheet" href="../assets/modules/summernote/summernote-bs4.css">
    <link rel="stylesheet" href="../assets/modules/owlcarousel2/dist/assets/owl.carousel.min.css">
    <link rel="stylesheet" href="../assets/modules/owlcarousel2/dist/assets/owl.theme.default.min.css">

    <!-- Template CSS -->
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/components.css">
</head>

<body>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <!-- Header -->
            <?php include '../layouts/header.php'; ?>

            <!-- Sidebar -->
            <?php include '../layouts/sidebar.php'; ?>

            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="section-header">
                        <h1>Admin Dashboard</h1>
                    </div>

                    <div class="row">
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-primary">
                                    <i class="fas fa-users"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4>Total Pengguna</h4>
                                    </div>
                                    <div class="card-body">
                                        <?php echo $totalUsers; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-danger">
                                    <i class="fas fa-user-md"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4>Total Dokter</h4>
                                    </div>
                                    <div class="card-body">
                                        <?php echo $totalDoctors; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-warning">
                                    <i class="fas fa-hospital-user"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4>Total Pasien</h4>
                                    </div>
                                    <div class="card-body">
                                        <?php echo $totalPatients; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-success">
                                    <i class="fas fa-file-medical"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4>Total Rekam Medis</h4>
                                    </div>
                                    <div class="card-body">
                                        <?php echo $totalRecords; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-8 col-md-12 col-12 col-sm-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4>Pengguna Terbaru</h4>
                                    <div class="card-header-action">
                                        <a href="users/index.php" class="btn btn-primary">Lihat Semua</a>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-striped mb-0">
                                            <thead>
                                                <tr>
                                                    <th>Nama</th>
                                                    <th>Username</th>
                                                    <th>Email</th>
                                                    <th>Role</th>
                                                    <th>Tanggal Dibuat</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($recentUsers as $user): ?>
                                                <tr>
                                                    <td><?php echo $user['name']; ?></td>
                                                    <td><?php echo $user['username']; ?></td>
                                                    <td><?php echo $user['email']; ?></td>
                                                    <td>
                                                        <div
                                                            class="badge badge-<?php echo $user['role'] === 'admin' ? 'danger' : ($user['role'] === 'doctor' ? 'warning' : 'info'); ?>">
                                                            <?php echo ucfirst($user['role']); ?>
                                                        </div>
                                                    </td>
                                                    <td><?php echo date('d-m-Y H:i', strtotime($user['created_at'])); ?>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                                <?php if (count($recentUsers) == 0): ?>
                                                <tr>
                                                    <td colspan="5" class="text-center">Tidak ada data pengguna.</td>
                                                </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-12 col-12 col-sm-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4>Aktivitas Terbaru</h4>
                                    <div class="card-header-action">
                                        <a href="../activities.php" class="btn btn-primary">Lihat Semua</a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled list-unstyled-border">
                                        <?php 
                                        if (count($recentActivities) > 0):
                                            foreach ($recentActivities as $activity):
                                                $activityTime = strtotime($activity['created_at']);
                                                $timeAgo = human_time_diff($activityTime, time());
                                        ?>
                                        <li class="media">
                                            <div
                                                class="media-icon-circle bg-<?php echo $activity['role'] === 'admin' ? 'danger' : ($activity['role'] === 'doctor' ? 'warning' : 'info'); ?> mr-3">
                                                <i
                                                    class="fas fa-<?php echo $activity['role'] === 'admin' ? 'user-shield' : ($activity['role'] === 'doctor' ? 'user-md' : 'user'); ?>"></i>
                                            </div>
                                            <div class="media-body">
                                                <div class="float-right text-primary"><?php echo $timeAgo; ?></div>
                                                <div class="media-title"><?php echo $activity['name'] ?: 'Sistem'; ?>
                                                </div>
                                                <span class="text-small text-muted">
                                                    <?php echo $activity['activity']; ?>
                                                </span>
                                            </div>
                                        </li>
                                        <?php 
                                            endforeach; 
                                        else:
                                        ?>
                                        <li class="media">
                                            <div class="media-body">
                                                <span class="text-small text-muted">Tidak ada aktivitas terbaru.</span>
                                            </div>
                                        </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>

                </section>
            </div>

            <!-- Footer -->
            <?php include '../layouts/footer.php'; ?>
        </div>
    </div>

    <!-- General JS Scripts -->
    <script src="../assets/modules/jquery.min.js"></script>
    <script src="../assets/modules/popper.js"></script>
    <script src="../assets/modules/tooltip.js"></script>
    <script src="../assets/modules/bootstrap/js/bootstrap.min.js"></script>
    <script src="../assets/modules/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="../assets/modules/moment.min.js"></script>
    <script src="../assets/js/stisla.js"></script>

    <!-- JS Libraies -->
    <script src="../assets/modules/jquery.sparkline.min.js"></script>
    <script src="../assets/modules/chart.min.js"></script>
    <script src="../assets/modules/owlcarousel2/dist/owl.carousel.min.js"></script>
    <script src="../assets/modules/summernote/summernote-bs4.js"></script>
    <script src="../assets/modules/chocolat/dist/js/jquery.chocolat.min.js"></script>

    <!-- Page Specific JS File -->
    <script src="../assets/js/page/index.js"></script>

    <!-- Template JS File -->
    <script src="../assets/js/scripts.js"></script>
    <script src="../assets/js/custom.js"></script>
</body>

</html> 