<?php
// Include initialization file
require_once '../../init.php';

// Check if user is logged in and has admin role
if (!isLoggedIn() || !isAdmin()) {
    setFlashMessage('Anda tidak memiliki izin untuk mengakses halaman ini.', 'danger');
    redirect('../../index.php');
}

// Initialize variables
$searchQuery = isset($_GET['search']) ? trim($_GET['search']) : '';
$roleFilter = isset($_GET['role']) ? $_GET['role'] : '';
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$limit = 10;
$offset = ($page - 1) * $limit;

// Build base query
$baseQuery = "FROM users";
$countQuery = "SELECT COUNT(*) $baseQuery";
$dataQuery = "SELECT * $baseQuery";

// Add filters
$whereConditions = [];
$params = [];

if (!empty($searchQuery)) {
    $whereConditions[] = "(name LIKE ?s OR username LIKE ?s OR email LIKE ?s)";
    $params[] = "%$searchQuery%";
    $params[] = "%$searchQuery%";
    $params[] = "%$searchQuery%";
}

if (!empty($roleFilter)) {
    $whereConditions[] = "role = ?s";
    $params[] = $roleFilter;
}

// Combine WHERE conditions
if (!empty($whereConditions)) {
    $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    $countQuery .= $whereClause;
    $dataQuery .= $whereClause;
}

// Add order and limit
$dataQuery .= " ORDER BY created_at DESC LIMIT ?i, ?i";
$dataParams = $params;
$dataParams[] = $offset;
$dataParams[] = $limit;

// Get total count and data
$totalUsers = $db->getOne($countQuery, ...$params);
$users = $db->getAll($dataQuery, ...$dataParams);

// Calculate total pages
$totalPages = ceil($totalUsers / $limit);

// Delete user if requested
if (isset($_GET['delete']) && !empty($_GET['delete'])) {
    $userId = intval($_GET['delete']);
    
    // Prevent deleting your own account
    if ($userId === intval($_SESSION['user_id'])) {
        setFlashMessage('Anda tidak dapat menghapus akun Anda sendiri.', 'danger');
        redirect('index.php');
    }
    
    // Check if user exists
    $user = $db->getRow("SELECT * FROM users WHERE id = ?i", $userId);
    if (!$user) {
        setFlashMessage('Pengguna tidak ditemukan.', 'danger');
        redirect('index.php');
    }
    
    // Check if user is last admin
    $isLastAdmin = false;
    if ($user['role'] === 'admin') {
        $adminCount = $db->getOne("SELECT COUNT(*) FROM users WHERE role = 'admin'");
        if ($adminCount <= 1) {
            $isLastAdmin = true;
        }
    }
    
    if ($isLastAdmin) {
        setFlashMessage('Tidak dapat menghapus admin terakhir.', 'danger');
        redirect('index.php');
    }
    
    // Delete user
    $result = $db->query("DELETE FROM users WHERE id = ?i", $userId);
    if ($result) {
        // Log activity
        logActivity('Menghapus pengguna: ' . $user['name'] . ' (' . $user['username'] . ')');
        setFlashMessage('Pengguna berhasil dihapus.', 'success');
    } else {
        setFlashMessage('Gagal menghapus pengguna.', 'danger');
    }
    redirect('index.php');
}
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title>Manajemen Pengguna &mdash; Sistem Rekam Medis Ortodontik</title>

    <!-- General CSS Files -->
    <link rel="stylesheet" href="../../assets/modules/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="../../assets/modules/fontawesome/css/all.min.css">

    <!-- CSS Libraries -->
    <link rel="stylesheet" href="../../assets/modules/datatables/datatables.min.css">
    <link rel="stylesheet" href="../../assets/modules/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="../../assets/modules/select2/dist/css/select2.min.css">
    <link rel="stylesheet" href="../../assets/modules/izitoast/css/iziToast.min.css">

    <!-- Template CSS -->
    <link rel="stylesheet" href="../../assets/css/style.css">
    <link rel="stylesheet" href="../../assets/css/components.css">
</head>

<body>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <!-- Header -->
            <?php include '../../layouts/header.php'; ?>

            <!-- Sidebar -->
            <?php include '../../layouts/sidebar.php'; ?>

            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="section-header">
                        <h1>Manajemen Pengguna</h1>
                        <div class="section-header-breadcrumb">
                            <div class="breadcrumb-item active"><a href="../../index.php">Dashboard</a></div>
                            <div class="breadcrumb-item">Manajemen Pengguna</div>
                        </div>
                    </div>

                    <div class="section-body">
                        <?php if (isset($_SESSION['flash_message'])): ?>
                        <div class="alert alert-<?php echo $_SESSION['flash_type']; ?> alert-dismissible show fade">
                            <div class="alert-body">
                                <button class="close" data-dismiss="alert">
                                    <span>&times;</span>
                                </button>
                                <?php echo $_SESSION['flash_message']; ?>
                            </div>
                        </div>
                        <?php 
                            unset($_SESSION['flash_message']); 
                            unset($_SESSION['flash_type']); 
                        endif; 
                        ?>

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>Daftar Pengguna</h4>
                                        <div class="card-header-action">
                                            <a href="create.php" class="btn btn-primary">
                                                <i class="fas fa-plus"></i> Tambah Pengguna
                                            </a>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <form action="" method="GET" class="mb-4">
                                            <div class="row">
                                                <div class="form-group col-md-6">
                                                    <input type="text" name="search" class="form-control" placeholder="Cari berdasarkan nama, username, atau email"
                                                        value="<?php echo htmlspecialchars($searchQuery); ?>">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <select name="role" class="form-control select2">
                                                        <option value="">Semua Peran</option>
                                                        <option value="admin" <?php echo $roleFilter === 'admin' ? 'selected' : ''; ?>>Admin</option>
                                                        <option value="doctor" <?php echo $roleFilter === 'doctor' ? 'selected' : ''; ?>>Dokter</option>
                                                        <option value="staff" <?php echo $roleFilter === 'staff' ? 'selected' : ''; ?>>Staff</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <button type="submit" class="btn btn-primary btn-block">Filter</button>
                                                </div>
                                            </div>
                                        </form>

                                        <div class="table-responsive">
                                            <table class="table table-striped" id="users-table">
                                                <thead>
                                                    <tr>
                                                        <th>Nama</th>
                                                        <th>Username</th>
                                                        <th>Email</th>
                                                        <th>Peran</th>
                                                        <th>Tanggal Dibuat</th>
                                                        <th>Aksi</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach ($users as $user): ?>
                                                    <tr>
                                                        <td><?php echo $user['name']; ?></td>
                                                        <td><?php echo $user['username']; ?></td>
                                                        <td><?php echo $user['email']; ?></td>
                                                        <td>
                                                            <div class="badge badge-<?php echo $user['role'] === 'admin' ? 'danger' : ($user['role'] === 'doctor' ? 'warning' : 'info'); ?>">
                                                                <?php echo ucfirst($user['role']); ?>
                                                            </div>
                                                        </td>
                                                        <td><?php echo date('d-m-Y H:i', strtotime($user['created_at'])); ?></td>
                                                        <td>
                                                            <a href="edit.php?id=<?php echo $user['id']; ?>" class="btn btn-sm btn-primary">
                                                                <i class="fas fa-edit"></i>
                                                            </a>
                                                            <?php if ($user['id'] != $_SESSION['user_id']): ?>
                                                            <a href="#" class="btn btn-sm btn-danger"
                                                                data-confirm="Hapus Pengguna|Apakah anda yakin ingin menghapus pengguna <?php echo $user['name']; ?>?"
                                                                data-confirm-yes="window.location.href='index.php?delete=<?php echo $user['id']; ?>'">
                                                                <i class="fas fa-trash"></i>
                                                            </a>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>

                                        <!-- Pagination -->
                                        <div class="d-flex justify-content-center mt-4">
                                            <nav aria-label="Page navigation">
                                                <ul class="pagination">
                                                    <?php if ($page > 1): ?>
                                                    <li class="page-item">
                                                        <a class="page-link" href="?page=<?php echo $page - 1; ?><?php echo !empty($searchQuery) ? '&search=' . urlencode($searchQuery) : ''; ?><?php echo !empty($roleFilter) ? '&role=' . urlencode($roleFilter) : ''; ?>">
                                                            <i class="fas fa-chevron-left"></i>
                                                        </a>
                                                    </li>
                                                    <?php endif; ?>

                                                    <?php
                                                    $startPage = max(1, $page - 2);
                                                    $endPage = min($totalPages, $page + 2);

                                                    if ($startPage > 1) {
                                                        echo '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
                                                    }

                                                    for ($i = $startPage; $i <= $endPage; $i++):
                                                    ?>
                                                    <li class="page-item <?php echo $i == $page ? 'active' : ''; ?>">
                                                        <a class="page-link" href="?page=<?php echo $i; ?><?php echo !empty($searchQuery) ? '&search=' . urlencode($searchQuery) : ''; ?><?php echo !empty($roleFilter) ? '&role=' . urlencode($roleFilter) : ''; ?>">
                                                            <?php echo $i; ?>
                                                        </a>
                                                    </li>
                                                    <?php endfor; ?>

                                                    <?php if ($endPage < $totalPages): ?>
                                                    <li class="page-item disabled"><a class="page-link" href="#">...</a></li>
                                                    <?php endif; ?>

                                                    <?php if ($page < $totalPages): ?>
                                                    <li class="page-item">
                                                        <a class="page-link" href="?page=<?php echo $page + 1; ?><?php echo !empty($searchQuery) ? '&search=' . urlencode($searchQuery) : ''; ?><?php echo !empty($roleFilter) ? '&role=' . urlencode($roleFilter) : ''; ?>">
                                                            <i class="fas fa-chevron-right"></i>
                                                        </a>
                                                    </li>
                                                    <?php endif; ?>
                                                </ul>
                                            </nav>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>

            <!-- Footer -->
            <?php include '../../layouts/footer.php'; ?>
        </div>
    </div>

    <!-- General JS Scripts -->
    <script src="../../assets/modules/jquery.min.js"></script>
    <script src="../../assets/modules/popper.js"></script>
    <script src="../../assets/modules/tooltip.js"></script>
    <script src="../../assets/modules/bootstrap/js/bootstrap.min.js"></script>
    <script src="../../assets/modules/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="../../assets/modules/moment.min.js"></script>
    <script src="../../assets/js/stisla.js"></script>

    <!-- JS Libraries -->
    <script src="../../assets/modules/datatables/datatables.min.js"></script>
    <script src="../../assets/modules/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js"></script>
    <script src="../../assets/modules/select2/dist/js/select2.full.min.js"></script>
    <script src="../../assets/modules/sweetalert/sweetalert.min.js"></script>

    <!-- Template JS File -->
    <script src="../../assets/js/scripts.js"></script>
    <script src="../../assets/js/custom.js"></script>

    <script>
    $(document).ready(function() {
        $('.select2').select2();
    });
    </script>
</body>

</html> 