<?php
// Include initialization file
require_once 'init.php';

// Check if user is logged in
if (!isLoggedIn()) {
    redirect('auth/login.php');
}

// Get stats for dashboard
$totalPatients = $db->getOne("SELECT COUNT(*) FROM patients");
$totalRecords = $db->getOne("SELECT COUNT(*) FROM medical_records");
$recentPatients = $db->getAll("
    SELECT p.*, mr.examination_date 
    FROM patients p 
    LEFT JOIN medical_records mr ON p.id = mr.patient_id
    ORDER BY mr.created_at DESC 
    LIMIT 5
");
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title>Dashboard &mdash; Sistem Rekam Medis Ortodontik</title>

    <!-- General CSS Files -->
    <link rel="stylesheet" href="assets/modules/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/modules/fontawesome/css/all.min.css">

    <!-- CSS Libraries -->
    <link rel="stylesheet" href="assets/modules/jqvmap/dist/jqvmap.min.css">
    <link rel="stylesheet" href="assets/modules/summernote/summernote-bs4.css">
    <link rel="stylesheet" href="assets/modules/owlcarousel2/dist/assets/owl.carousel.min.css">
    <link rel="stylesheet" href="assets/modules/owlcarousel2/dist/assets/owl.theme.default.min.css">

    <!-- Template CSS -->
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/components.css">
</head>

<body>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <!-- Header -->
            <?php include 'layouts/header.php'; ?>

            <!-- Sidebar -->
            <?php include 'layouts/sidebar.php'; ?>

            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="section-header">
                        <h1>Dashboard</h1>
                    </div>

                    <div class="row">
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-primary">
                                    <i class="fas fa-users"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4>Total Pasien</h4>
                                    </div>
                                    <div class="card-body">
                                        <?php echo $totalPatients; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-danger">
                                    <i class="fas fa-file-medical"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4>Total Rekam Medis</h4>
                                    </div>
                                    <div class="card-body">
                                        <?php echo $totalRecords; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-warning">
                                    <i class="fas fa-calendar-check"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4>Pasien Bulan Ini</h4>
                                    </div>
                                    <div class="card-body">
                                        <?php 
                    $currentMonth = date('m');
                    $currentYear = date('Y');
                    $patientsThisMonth = $db->getOne("
                        SELECT COUNT(*) 
                        FROM medical_records 
                        WHERE MONTH(examination_date) = ?s 
                        AND YEAR(examination_date) = ?s", 
                        $currentMonth, $currentYear
                    );
                    echo $patientsThisMonth; 
                    ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-success">
                                    <i class="fas fa-user-md"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4>Total Dokter</h4>
                                    </div>
                                    <div class="card-body">
                                        <?php 
                    $totalDoctors = $db->getOne("SELECT COUNT(*) FROM users WHERE role = 'doctor'");
                    echo $totalDoctors; 
                    ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-12 col-sm-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4>Pasien Terbaru</h4>
                                    <div class="card-header-action">
                                        <a href="patients/index.php" class="btn btn-primary">Lihat Semua</a>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-striped mb-0">
                                            <thead>
                                                <tr>
                                                    <th>No. RM</th>
                                                    <th>Nama</th>
                                                    <th>Tanggal Pemeriksaan</th>
                                                    <th>Jenis Kelamin</th>
                                                    <th>Aksi</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($recentPatients as $patient): ?>
                                                <tr>
                                                    <td><?php echo $patient['medical_record_number']; ?></td>
                                                    <td><?php echo $patient['name']; ?></td>
                                                    <td><?php echo formatDate($patient['examination_date']); ?></td>
                                                    <td><?php echo $patient['gender']; ?></td>
                                                    <td>
                                                        <a href="medical_records/view.php?id=<?php echo $patient['id']; ?>"
                                                            class="btn btn-primary btn-sm">
                                                            <i class="fas fa-eye"></i> Lihat
                                                        </a>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                                <?php if (count($recentPatients) == 0): ?>
                                                <tr>
                                                    <td colspan="5" class="text-center">Tidak ada data pasien.</td>
                                                </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>

            <!-- Footer -->
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <!-- General JS Scripts -->
    <script src="assets/modules/jquery.min.js"></script>
    <script src="assets/modules/popper.js"></script>
    <script src="assets/modules/tooltip.js"></script>
    <script src="assets/modules/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/modules/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="assets/modules/moment.min.js"></script>
    <script src="assets/js/stisla.js"></script>

    <!-- JS Libraies -->
    <script src="assets/modules/jquery.sparkline.min.js"></script>
    <script src="assets/modules/chart.min.js"></script>
    <script src="assets/modules/owlcarousel2/dist/owl.carousel.min.js"></script>
    <script src="assets/modules/summernote/summernote-bs4.js"></script>
    <script src="assets/modules/chocolat/dist/js/jquery.chocolat.min.js"></script>

    <!-- Page Specific JS File -->
    <script src="assets/js/page/index.js"></script>

    <!-- Template JS File -->
    <script src="assets/js/scripts.js"></script>
    <script src="assets/js/custom.js"></script>

    <?php 
  /**
   * Human-readable time difference
   * @param int $from Unix timestamp from which the difference begins
   * @param int $to Unix timestamp to end the time difference
   * @return string Human-readable time difference
   */
  function human_time_diff($from, $to = '') {
      if (empty($to)) {
          $to = time();
      }
      
      $diff = (int) abs($to - $from);
      
      if ($diff < 60) {
          $since = sprintf("%d detik yang lalu", $diff);
      } else if ($diff < 60 * 60) {
          $mins = round($diff / 60);
          $since = sprintf("%d menit yang lalu", $mins);
      } else if ($diff < 60 * 60 * 24) {
          $hours = round($diff / (60 * 60));
          $since = sprintf("%d jam yang lalu", $hours);
      } else if ($diff < 60 * 60 * 24 * 30) {
          $days = round($diff / (60 * 60 * 24));
          $since = sprintf("%d hari yang lalu", $days);
      } else if ($diff < 60 * 60 * 24 * 30 * 12) {
          $months = round($diff / (60 * 60 * 24 * 30));
          $since = sprintf("%d bulan yang lalu", $months);
      } else {
          $years = round($diff / (60 * 60 * 24 * 30 * 12));
          $since = sprintf("%d tahun yang lalu", $years);
      }
      
      return $since;
  }
  ?>
</body>

</html>