<?php
/**
 * Initialization file
 * Includes all required files and sets up database connection
 */

// Start session
session_start();

// Require configuration files
require_once __DIR__ . '/config/database.php';

// Require libraries
require_once __DIR__ . './safemysql.php';

// Require helper functions
require_once __DIR__ . '/helpers/functions.php';

// Initialize database connection
$db = new SafeMySQL([
    'host'     => $dbHost,
    'user'     => $dbUser,
    'pass'     => $dbPass,
    'db'       => $dbName,
    'port'     => $dbPort,
    'charset'  => $dbCharset,
    'errmode'  => $debugMode ? 'exception' : 'error'
]);

// Set global error handling
if ($debugMode) {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    error_reporting(0);
} 