<?php
// Include initialization file if not already included
if (!defined('DB_INCLUDED')) {
    require_once __DIR__ . '/../init.php';
}

// Determine base URL based on current directory depth
function getBasePath() {
    // Get current script path
    $currentPath = $_SERVER['SCRIPT_NAME'];
    $pathParts = explode('/', trim($currentPath, '/'));
    
    // Root directory of the project is 'orthobaru'
    $rootIndex = array_search('orthobaru', $pathParts);
    if ($rootIndex === false) return '/';
    
    // Count directories after the root
    $depth = count($pathParts) - $rootIndex - 1;
    
    // Generate base path
    return str_repeat('../', max(0, $depth - 1));
}

$basePath = getBasePath();

// Get current page to highlight active menu
$currentPage = basename($_SERVER['PHP_SELF']);
$currentDir = basename(dirname($_SERVER['PHP_SELF']));
?>
<div class="main-sidebar sidebar-style-2">
    <aside id="sidebar-wrapper">
        <div class="sidebar-brand">
            <a href="<?php echo $basePath . (isAdmin() ? 'index.php' : 'index.php'); ?>">ORTHO MED</a>
        </div>
        <div class="sidebar-brand sidebar-brand-sm">
            <a href="<?php echo $basePath . (isAdmin() ? 'index.php' : 'index.php'); ?>">OM</a>
        </div>
        <ul class="sidebar-menu">
            <li class="menu-header">Dashboard</li>
            <li class="<?php echo isMenuActive($currentPage, 'index'); ?>">
                <a class="nav-link" href="<?php echo $basePath . (isAdmin() ? 'index.php' : 'index.php'); ?>">
                    <i class="fas fa-fire"></i> <span>Dashboard</span>
                </a>
            </li>

            <li class="menu-header">Manajemen Pasien</li>
            <li class="<?php echo isMenuActive($currentDir, 'patients'); ?>">
                <a class="nav-link"
                    href="<?php echo $basePath . (isAdmin() ? 'patients/index.php' : 'patients/index.php'); ?>">
                    <i class="fas fa-users"></i> <span>Data Pasien</span>
                </a>
            </li>

            <li class="<?php echo isMenuActive($currentDir, 'medical_records'); ?>">
                <a class="nav-link"
                    href="<?php echo $basePath . (isAdmin() ? 'medical_records/index.php' : 'medical_records/index.php'); ?>">
                    <i class="fas fa-file-medical"></i> <span>Rekam Medis</span>
                </a>
            </li>

            <?php if (isAdmin()): ?>
            <li class="menu-header">Administrasi</li>
            <li class="<?php echo isMenuActive($currentDir, 'users'); ?>">
                <a class="nav-link" href="<?php echo $basePath; ?>admin/users/index.php">
                    <i class="fas fa-user-md"></i> <span>Manajemen Pengguna</span>
                </a>
            </li>
            <!-- <li class="<?php echo isMenuActive($currentPage, 'settings'); ?>">
                <a class="nav-link" href="<?php echo $basePath; ?>settings.php">
                    <i class="fas fa-cog"></i> <span>Pengaturan Sistem</span>
                </a>
            </li> -->
            <?php endif; ?>

            <?php if (isDoctor()): ?>
            <!-- <li class="menu-header">Rekam Medis Ortodontik</li>
            <li class="<?php echo isMenuActive($currentPage, 'create'); ?>">
                <a class="nav-link" href="<?php echo $basePath; ?>medical_records/create.php">
                    <i class="fas fa-plus-circle"></i> <span>Tambah Rekam Medis Baru</span>
                </a>
            </li>
            <li class="<?php echo isMenuActive($currentDir, 'cephalometric'); ?>">
                <a class="nav-link" href="<?php echo $basePath; ?>cephalometric/index.php">
                    <i class="fas fa-x-ray"></i> <span>Analisis Sefalometri</span>
                </a>
            </li>
            <li class="<?php echo isMenuActive($currentDir, 'space_analysis'); ?>">
                <a class="nav-link" href="<?php echo $basePath; ?>space_analysis/index.php">
                    <i class="fas fa-calculator"></i> <span>Analisis Kebutuhan Ruang</span>
                </a>
            </li>
            <li class="<?php echo isMenuActive($currentDir, 'tools'); ?>">
                <a class="nav-link" href="<?php echo $basePath; ?>tools/index.php">
                    <i class="fas fa-tools"></i> <span>Gambar Alat</span>
                </a>
            </li> -->
            <?php endif; ?>

        </ul>


    </aside>
</div>