<?php
// Include initialization file
require_once '../init.php';

// Check if user is logged in
if (!isLoggedIn()) {
    redirect('../auth/login.php');
}

// Check if user is admin (only admins can delete medical records)
if (!isAdmin()) {
    setFlashMessage('Anda tidak memiliki izin untuk menghapus rekam medis.', 'danger');
    redirect('index.php');
}

// Check if ID is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    setFlashMessage('ID rekam medis tidak valid.', 'danger');
    redirect('index.php');
}

$recordId = intval($_GET['id']);

// Get medical record data
$record = $db->getRow("
    SELECT 
        mr.*,
        p.name AS patient_name
    FROM 
        medical_records mr
    JOIN 
        patients p ON mr.patient_id = p.id
    WHERE 
        mr.id = ?i
", $recordId);

if (!$record) {
    setFlashMessage('Rekam medis tidak ditemukan.', 'danger');
    redirect('index.php');
}

// Check if deletion is confirmed
if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes') {
    // Begin transaction
    $db->query("START TRANSACTION");
    
    // Delete from all related tables
    $result1 = $db->query("DELETE FROM extra_oral_examinations WHERE medical_record_id = ?i", $recordId);
    $result2 = $db->query("DELETE FROM intra_oral_examinations WHERE medical_record_id = ?i", $recordId);
    $result3 = $db->query("DELETE FROM tooth_relation_examinations WHERE medical_record_id = ?i", $recordId);
    $result4 = $db->query("DELETE FROM functional_examinations WHERE medical_record_id = ?i", $recordId);
    $result5 = $db->query("DELETE FROM radiological_examinations WHERE medical_record_id = ?i", $recordId);
    $result6 = $db->query("DELETE FROM cephalometric_analyses WHERE medical_record_id = ?i", $recordId);
    $result7 = $db->query("DELETE FROM panoramic_analyses WHERE medical_record_id = ?i", $recordId);
    $result8 = $db->query("DELETE FROM other_radiographs WHERE medical_record_id = ?i", $recordId);
    $result9 = $db->query("DELETE FROM model_analyses WHERE medical_record_id = ?i", $recordId);
    $result10 = $db->query("DELETE FROM space_analyses WHERE medical_record_id = ?i", $recordId);
    $result11 = $db->query("DELETE FROM diagnoses WHERE medical_record_id = ?i", $recordId);
    $result12 = $db->query("DELETE FROM treatment_plans WHERE medical_record_id = ?i", $recordId);
    $result13 = $db->query("DELETE FROM appliance_images WHERE medical_record_id = ?i", $recordId);
    $result14 = $db->query("DELETE FROM patient_photos WHERE medical_record_id = ?i", $recordId);
    
    // Finally delete the main record
    $result15 = $db->query("DELETE FROM medical_records WHERE id = ?i", $recordId);
    
    if ($result1 && $result2 && $result3 && $result4 && $result5 && $result6 && $result7 && 
        $result8 && $result9 && $result10 && $result11 && $result12 && $result13 && $result14 && $result15) {
        // Commit transaction
        $db->query("COMMIT");
        
        // Log the deletion
        logActivity('Menghapus rekam medis pasien: ' . $record['patient_name'] . ' (ID: ' . $recordId . ')');
        
        setFlashMessage('Rekam medis berhasil dihapus.', 'success');
        redirect('index.php');
    } else {
        // Rollback on failure
        $db->query("ROLLBACK");
        
        setFlashMessage('Terjadi kesalahan saat menghapus rekam medis.', 'danger');
        redirect('index.php');
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
  <title>Hapus Rekam Medis &mdash; Sistem Rekam Medis Ortodontik</title>

  <!-- General CSS Files -->
  <link rel="stylesheet" href="../assets/modules/bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/modules/fontawesome/css/all.min.css">

  <!-- Template CSS -->
  <link rel="stylesheet" href="../assets/css/style.css">
  <link rel="stylesheet" href="../assets/css/components.css">
</head>

<body>
  <div id="app">
    <div class="main-wrapper main-wrapper-1">
      <!-- Header -->
      <?php include '../layouts/header.php'; ?>

      <!-- Sidebar -->
      <?php include '../layouts/sidebar.php'; ?>

      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1>Hapus Rekam Medis</h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="../index.php">Dashboard</a></div>
              <div class="breadcrumb-item"><a href="index.php">Rekam Medis</a></div>
              <div class="breadcrumb-item">Hapus Rekam Medis</div>
            </div>
          </div>

          <div class="section-body">
            <h2 class="section-title">Konfirmasi Penghapusan</h2>
            <p class="section-lead">
              Anda akan menghapus data rekam medis. Tindakan ini tidak dapat dibatalkan.
            </p>

            <div class="row">
              <div class="col-12">
                <div class="card">
                  <div class="card-header">
                    <h4>Informasi Rekam Medis yang Akan Dihapus</h4>
                  </div>
                  <div class="card-body">
                    <div class="alert alert-danger">
                      <p>Anda akan menghapus rekam medis dengan data berikut:</p>
                      <ul>
                        <li><strong>Nama Pasien:</strong> <?php echo $record['patient_name']; ?></li>
                        <li><strong>Nomor Rekam Medis:</strong> <?php echo $record['medical_record_number']; ?></li>
                        <li><strong>Tanggal Pemeriksaan:</strong> <?php echo formatDate($record['examination_date']); ?></li>
                      </ul>
                      <p><strong>PERINGATAN:</strong> Tindakan ini akan menghapus semua data rekam medis termasuk data pemeriksaan, foto, dan analisis. Tindakan ini tidak dapat dibatalkan.</p>
                      <p>Apakah Anda yakin ingin melanjutkan?</p>
                    </div>
                    
                    <div class="text-right">
                      <a href="index.php" class="btn btn-secondary mr-2">Batal</a>
                      <a href="delete.php?id=<?php echo $recordId; ?>&confirm=yes" class="btn btn-danger">Hapus Rekam Medis</a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
      </div>
      
      <!-- Footer -->
      <?php include '../layouts/footer.php'; ?>
    </div>
  </div>

  <!-- General JS Scripts -->
  <script src="../assets/modules/jquery.min.js"></script>
  <script src="../assets/modules/popper.js"></script>
  <script src="../assets/modules/tooltip.js"></script>
  <script src="../assets/modules/bootstrap/js/bootstrap.min.js"></script>
  <script src="../assets/modules/nicescroll/jquery.nicescroll.min.js"></script>
  <script src="../assets/modules/moment.min.js"></script>
  <script src="../assets/js/stisla.js"></script>
  
  <!-- Template JS File -->
  <script src="../assets/js/scripts.js"></script>
  <script src="../assets/js/custom.js"></script>
</body>
</html> 