<?php
// Include initialization file
require_once '../init.php';

// Authentication and authorization checks
if (!isLoggedIn()) {
    redirect('../auth/login.php');
}

// Validate record ID
if (!isset($_GET['id']) || empty($_GET['id'])) {
    setFlashMessage('ID rekam medis tidak valid.', 'danger');
    redirect('index.php');
}
$recordId = intval($_GET['id']);

// Get medical record and patient data (common data needed by all sections)
$record = $db->getRow("SELECT mr.*, p.name as patient_name, p.birth_date, p.gender, p.medical_record_number as patient_mrn,
                      u.name as doctor_name 
                      FROM medical_records mr 
                      JOIN patients p ON mr.patient_id = p.id
                      JOIN users u ON mr.doctor_id = u.id
                      WHERE mr.id = ?i", $recordId);
if (!$record) {
    setFlashMessage('Rekam medis tidak ditemukan.', 'danger');
    redirect('index.php');
}

// Calculate patient's age
$birthDate = new DateTime($record['birth_date']);
$today = new DateTime();
$age = $birthDate->diff($today)->y;

// Check view mode
$isViewMode = isset($_GET['mode']) && $_GET['mode'] === 'view';

// Check if record is complete - only redirect if trying to edit a complete record
if ($record['is_complete'] == 1 && !$isViewMode) {
    setFlashMessage('Rekam medis sudah selesai dan tidak dapat diedit.', 'info');
    redirect('edit.php?id=' . $recordId . '&mode=view');
}

// Check permission - only doctors can edit
if (!$isViewMode && !isDoctor()) {
    setFlashMessage('Anda tidak memiliki izin untuk mengedit rekam medis.', 'danger');
    redirect('edit.php?id=' . $recordId . '&mode=view');
}

// Initialize common variables
$errorMessage = '';
$successMessage = '';

// Check for flash messages
if (isset($_SESSION['flash_message'])) {
    $successMessage = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
    unset($_SESSION['flash_type']);
}

$currentSection = isset($_GET['section']) ? intval($_GET['section']) : 1;
$totalSections = 13;

// Load common data needed by all sections
require_once 'includes/data_loader.php';

// Process form submission - each section has its own handler
if (isPostRequest() && !$isViewMode) {
    $sectionHandlerFile = "includes/section_handlers/section{$currentSection}_handler.php";
    if (file_exists($sectionHandlerFile)) {
        require_once $sectionHandlerFile;
    }
    
    // Handle "Save and Complete" action (common to all sections)
    if (isset($_POST['save_and_complete'])) {
        $result = $db->query("UPDATE medical_records SET is_complete = 1, updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
            $_SESSION['user_id'], $recordId);
        
        if ($result) {
            setFlashMessage('Rekam medis berhasil diselesaikan.', 'success');
            redirect('edit.php?id=' . $recordId . '&mode=view');
        } else {
            $errorMessage = 'Terjadi kesalahan saat menyelesaikan rekam medis.';
        }
    }
}

// Set page title based on mode
$pageTitle = $isViewMode ? "Lihat Rekam Medis" : "Edit Rekam Medis";

// Include header based on view mode
include_once $isViewMode ? 'includes/view_header.php' : 'includes/header.php';

if ($isViewMode) {
    // View mode header
    ?>
<div class="section-header">
    <h1>Lihat Rekam Medis</h1>
    <div class="section-header-breadcrumb">
        <div class="breadcrumb-item"><a href="../index.php">Dashboard</a></div>
        <div class="breadcrumb-item"><a href="index.php">Rekam Medis</a></div>
        <div class="breadcrumb-item active">Lihat Rekam Medis</div>
    </div>
</div>

<div class="section-body">
    <?php if(isset($_SESSION['flash_message']) && isset($_SESSION['flash_type'])): ?>
    <div class="alert alert-<?php echo $_SESSION['flash_type']; ?> alert-dismissible show fade">
        <div class="alert-body">
            <button class="close" data-dismiss="alert">
                <span>&times;</span>
            </button>
            <?php echo $_SESSION['flash_message']; ?>
        </div>
    </div>
    <?php 
        unset($_SESSION['flash_message']);
        unset($_SESSION['flash_type']);
        endif; ?>

    <!-- Actions row - Export, Print, Edit buttons -->
    <div class="card-header-action mb-3 text-right">
        <div class="btn-group">
            <div class="dropdown d-inline">
                <button class="btn btn-primary dropdown-toggle" type="button" id="exportDropdown" data-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-download"></i> Export
                </button>
                <div class="dropdown-menu" aria-labelledby="exportDropdown">
                    <a class="dropdown-item" href="export/to_pdf.php?id=<?= $recordId ?>" target="_blank">
                        <i class="far fa-file-pdf text-danger"></i> Export PDF
                    </a>
                    <a class="dropdown-item" href="export/to_excel.php?id=<?= $recordId ?>">
                        <i class="far fa-file-excel text-success"></i> Export Excel
                    </a>
                    <a class="dropdown-item" href="export/to_word.php?id=<?= $recordId ?>">
                        <i class="far fa-file-word text-primary"></i> Export Word
                    </a>
                </div>
            </div>
            <button class="btn btn-info ml-2" id="printButton">
                <i class="fas fa-print"></i> Print
            </button>
            <?php if (isDoctor() && $record['is_complete'] == 0): ?>
            <a href="edit.php?id=<?= $recordId ?>" class="btn btn-warning ml-2">
                <i class="fas fa-edit"></i> Edit
            </a>
            <?php endif; ?>
        </div>
    </div>

    <!-- Section navigation tabs -->
    <div class="card mb-3">
        <div class="card-body p-0">
            <div class="nav nav-pills nav-fill flex-column flex-sm-row" id="section-tabs" role="tablist">
                <?php for ($i = 1; $i <= $totalSections; $i++): ?>
                <a class="nav-item nav-link <?= ($i == $currentSection) ? 'active' : '' ?>"
                    href="edit.php?id=<?= $recordId ?>&mode=view&section=<?= $i ?>">
                    <?= getSectionTitle($i) ?>
                </a>
                <?php endfor; ?>
            </div>
        </div>
    </div>
    <?php
}

// Load the current section's form
$sectionFile = "sections/section{$currentSection}.php";
if (file_exists($sectionFile)) {
    include_once $sectionFile;
} else {
    echo '<div class="alert alert-warning">Section file not found: ' . $sectionFile . '</div>';
}

// HTML Footer
include_once $isViewMode ? 'includes/view_footer.php' : 'includes/footer.php';
?>