<?php
// Include initialization file
require_once '../../init.php';

// Check authentication
if (!isLoggedIn()) {
    redirect('../../auth/login.php');
}

// Validate record ID
if (!isset($_GET['id']) || empty($_GET['id'])) {
    die('ID rekam medis tidak valid.');
}
$recordId = intval($_GET['id']);

// Get medical record data
$record = $db->getRow("SELECT mr.*, p.name as patient_name, p.birth_date, p.gender, p.medical_record_number as patient_mrn,
                      u.name as doctor_name 
                      FROM medical_records mr 
                      JOIN patients p ON mr.patient_id = p.id
                      JOIN users u ON mr.doctor_id = u.id
                      WHERE mr.id = ?i", $recordId);

if (!$record) {
    die('Rekam medis tidak ditemukan.');
}

// Calculate patient's age
$birthDate = new DateTime($record['birth_date']);
$today = new DateTime();
$age = $birthDate->diff($today)->y;

// Load all data for each section
require_once '../includes/data_loader.php';

// Check if PHPSpreadsheet is available (via Composer)
if (!file_exists('../../vendor/autoload.php')) {
    die('PHPSpreadsheet library tidak ditemukan. Silakan install melalui Composer.');
}

require_once '../../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;

// Create a new Spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sheet->setTitle('Rekam Medis');

// Set Document Properties
$spreadsheet->getProperties()
    ->setCreator('Sistem Rekam Medis Ortodontik')
    ->setLastModifiedBy('Sistem Rekam Medis Ortodontik')
    ->setTitle('Rekam Medis - ' . $record['medical_record_number'])
    ->setSubject('Rekam Medis Ortodontik')
    ->setDescription('Rekam Medis untuk pasien ' . $record['patient_name']);

// Set column widths
$sheet->getColumnDimension('A')->setWidth(30);
$sheet->getColumnDimension('B')->setWidth(50);

// Header style
$headerStyle = [
    'font' => [
        'bold' => true,
        'color' => ['rgb' => 'FFFFFF'],
    ],
    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => ['rgb' => '0066CC'],
    ],
    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER,
    ],
    'borders' => [
        'allBorders' => [
            'borderStyle' => Border::BORDER_THIN,
        ],
    ],
];

// Section header style
$sectionHeaderStyle = [
    'font' => [
        'bold' => true,
        'size' => 14,
    ],
    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => ['rgb' => 'E0E0E0'],
    ],
    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_LEFT,
        'vertical' => Alignment::VERTICAL_CENTER,
    ],
];

// Subsection header style
$subsectionHeaderStyle = [
    'font' => [
        'bold' => true,
        'size' => 12,
    ],
    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => ['rgb' => 'F2F2F2'],
    ],
    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_LEFT,
        'vertical' => Alignment::VERTICAL_CENTER,
    ],
];

// Label style
$labelStyle = [
    'font' => [
        'bold' => true,
    ],
    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => ['rgb' => 'F8F8F8'],
    ],
    'borders' => [
        'allBorders' => [
            'borderStyle' => Border::BORDER_THIN,
        ],
    ],
    'alignment' => [
        'vertical' => Alignment::VERTICAL_CENTER,
    ],
];

// Value style
$valueStyle = [
    'borders' => [
        'allBorders' => [
            'borderStyle' => Border::BORDER_THIN,
        ],
    ],
    'alignment' => [
        'vertical' => Alignment::VERTICAL_CENTER,
        'wrapText' => true,
    ],
];

// Current row counter
$row = 1;

// Title
$sheet->setCellValue('A' . $row, 'REKAM MEDIS ORTODONTIK');
$sheet->mergeCells('A' . $row . ':B' . $row);
$sheet->getStyle('A' . $row)->getFont()->setBold(true)->setSize(16);
$sheet->getStyle('A' . $row)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
$row++;

// Medical Record Information
$row++;
$sheet->setCellValue('A' . $row, 'INFORMASI REKAM MEDIS');
$sheet->mergeCells('A' . $row . ':B' . $row);
$sheet->getStyle('A' . $row . ':B' . $row)->applyFromArray($headerStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Nomor Rekam Medis');
$sheet->setCellValue('B' . $row, $record['medical_record_number']);
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Pasien');
$sheet->setCellValue('B' . $row, $record['patient_name']);
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Tanggal Lahir / Usia');
$sheet->setCellValue('B' . $row, date('d/m/Y', strtotime($record['birth_date'])) . ' (' . $age . ' tahun)');
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Jenis Kelamin');
$sheet->setCellValue('B' . $row, $record['gender']);
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Dokter');
$sheet->setCellValue('B' . $row, $record['doctor_name']);
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Tanggal Pemeriksaan');
$sheet->setCellValue('B' . $row, date('d/m/Y', strtotime($record['examination_date'])));
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Status');
$sheet->setCellValue('B' . $row, $record['is_complete'] == 1 ? 'Selesai' : 'Belum Selesai');
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Terakhir Diperbarui');
$sheet->setCellValue('B' . $row, date('d/m/Y H:i', strtotime($record['updated_at'])));
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

// Section 1: Data Diri Pasien
$row++;
$sheet->setCellValue('A' . $row, '1. DATA DIRI PASIEN');
$sheet->mergeCells('A' . $row . ':B' . $row);
$sheet->getStyle('A' . $row . ':B' . $row)->applyFromArray($sectionHeaderStyle);
$sheet->getRowDimension($row)->setRowHeight(25);
$row++;

$sheet->setCellValue('A' . $row, 'Tanggal Pemeriksaan');
$sheet->setCellValue('B' . $row, date('d/m/Y', strtotime($record['examination_date'])));
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Nomor Rekam Medis');
$sheet->setCellValue('B' . $row, $record['medical_record_number']);
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Tanggal Lahir');
$sheet->setCellValue('B' . $row, date('d/m/Y', strtotime($record['birth_date'])));
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Usia');
$sheet->setCellValue('B' . $row, $age . ' tahun');
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Jenis Kelamin');
$sheet->setCellValue('B' . $row, $record['gender']);
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

// Section 2: Anamnesis
$row++;
$sheet->setCellValue('A' . $row, '2. ANAMNESIS');
$sheet->mergeCells('A' . $row . ':B' . $row);
$sheet->getStyle('A' . $row . ':B' . $row)->applyFromArray($sectionHeaderStyle);
$sheet->getRowDimension($row)->setRowHeight(25);
$row++;

$sheet->setCellValue('A' . $row, 'Keluhan Utama Kasus Ortodontik');
$sheet->setCellValue('B' . $row, $record['chief_complaint']);
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$sheet->getRowDimension($row)->setRowHeight(50); // Make this row taller for text
$row++;

$sheet->setCellValue('A' . $row, 'Riwayat Kesehatan Umum');
$sheet->setCellValue('B' . $row, $record['medical_history']);
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$sheet->getRowDimension($row)->setRowHeight(50); // Make this row taller for text
$row++;

$sheet->setCellValue('A' . $row, 'Kebiasaan Buruk');
$badHabitsText = '';
if (!empty($record['bad_habits'])) {
    $badHabits = json_decode($record['bad_habits'], true);
    if (is_array($badHabits)) {
        $badHabitsText = implode(', ', $badHabits);
    } else {
        $badHabitsText = $record['bad_habits'];
    }
} else {
    $badHabitsText = '-';
}
$sheet->setCellValue('B' . $row, $badHabitsText);
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

// Section 3: Pemeriksaan Ekstra Oral
$row++;
$sheet->setCellValue('A' . $row, '3. PEMERIKSAAN EKSTRA ORAL');
$sheet->mergeCells('A' . $row . ':B' . $row);
$sheet->getStyle('A' . $row . ':B' . $row)->applyFromArray($sectionHeaderStyle);
$sheet->getRowDimension($row)->setRowHeight(25);
$row++;

// Subsection: Vertikal
$sheet->setCellValue('A' . $row, 'Vertikal');
$sheet->mergeCells('A' . $row . ':B' . $row);
$sheet->getStyle('A' . $row . ':B' . $row)->applyFromArray($subsectionHeaderStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Bentuk Wajah');
$sheet->setCellValue('B' . $row, !empty($extraOralExam['face_shape']) ? $extraOralExam['face_shape'] : '-');
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Keseimbangan Wajah');
$faceBalanceText = !empty($extraOralExam['vertical_face_balance']) ? $extraOralExam['vertical_face_balance'] : '-';
if (!empty($extraOralExam['vertical_face_balance_value']) && $extraOralExam['vertical_face_balance'] == 'Tidak Seimbang') {
    $faceBalanceText .= ' (' . $extraOralExam['vertical_face_balance_value'] . ' mm)';
}
$sheet->setCellValue('B' . $row, $faceBalanceText);
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

// Subsection: Transversal
$sheet->setCellValue('A' . $row, 'Transversal');
$sheet->mergeCells('A' . $row . ':B' . $row);
$sheet->getStyle('A' . $row . ':B' . $row)->applyFromArray($subsectionHeaderStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Keseimbangan Wajah');
$transversalBalanceText = !empty($extraOralExam['transversal_face_balance']) ? $extraOralExam['transversal_face_balance'] : '-';
if (!empty($extraOralExam['transversal_face_balance_value']) && $extraOralExam['transversal_face_balance'] == 'Tidak Seimbang') {
    $transversalBalanceText .= ' (' . $extraOralExam['transversal_face_balance_value'] . ' mm)';
}
$sheet->setCellValue('B' . $row, $transversalBalanceText);
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Dagu');
$sheet->setCellValue('B' . $row, !empty($extraOralExam['chin']) ? $extraOralExam['chin'] : '-');
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Garis Tengah Geligi Atas');
$upperDentalText = !empty($extraOralExam['upper_dental_midline']) ? $extraOralExam['upper_dental_midline'] : '-';
if (in_array($extraOralExam['upper_dental_midline'] ?? '', ['Ke Kanan', 'Ke Kiri']) && !empty($extraOralExam['upper_dental_midline_value'])) {
    $upperDentalText .= ' (' . $extraOralExam['upper_dental_midline_value'] . ' mm)';
}
$sheet->setCellValue('B' . $row, $upperDentalText);
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Garis Tengah Geligi Bawah');
$lowerDentalText = !empty($extraOralExam['lower_dental_midline']) ? $extraOralExam['lower_dental_midline'] : '-';
if (in_array($extraOralExam['lower_dental_midline'] ?? '', ['Ke Kanan', 'Ke Kiri']) && !empty($extraOralExam['lower_dental_midline_value'])) {
    $lowerDentalText .= ' (' . $extraOralExam['lower_dental_midline_value'] . ' mm)';
}
$sheet->setCellValue('B' . $row, $lowerDentalText);
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

// Subsection: Bibir
$sheet->setCellValue('A' . $row, 'Bibir');
$sheet->mergeCells('A' . $row . ':B' . $row);
$sheet->getStyle('A' . $row . ':B' . $row)->applyFromArray($subsectionHeaderStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Tonus Bibir Atas');
$sheet->setCellValue('B' . $row, !empty($extraOralExam['upper_lip_tonus']) ? $extraOralExam['upper_lip_tonus'] : '-');
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Tonus Bibir Bawah');
$sheet->setCellValue('B' . $row, !empty($extraOralExam['lower_lip_tonus']) ? $extraOralExam['lower_lip_tonus'] : '-');
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Kompetensi Bibir');
$sheet->setCellValue('B' . $row, !empty($extraOralExam['lip_competence']) ? $extraOralExam['lip_competence'] : '-');
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Profil E-Line');
$sheet->setCellValue('B' . $row, !empty($extraOralExam['eline_profile']) ? $extraOralExam['eline_profile'] : '-');
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Bibir Atas terhadap E-Line');
$sheet->setCellValue('B' . $row, !empty($extraOralExam['upper_lip_to_eline']) ? $extraOralExam['upper_lip_to_eline'] . ' mm' : '-');
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

$sheet->setCellValue('A' . $row, 'Bibir Bawah terhadap E-Line');
$sheet->setCellValue('B' . $row, !empty($extraOralExam['lower_lip_to_eline']) ? $extraOralExam['lower_lip_to_eline'] . ' mm' : '-');
$sheet->getStyle('A' . $row)->applyFromArray($labelStyle);
$sheet->getStyle('B' . $row)->applyFromArray($valueStyle);
$row++;

// Continue with other sections in similar pattern...

// Section 4: Pemeriksaan Intra Oral
$row++;
$sheet->setCellValue('A' . $row, '4. PEMERIKSAAN INTRA ORAL');
$sheet->mergeCells('A' . $row . ':B' . $row);
$sheet->getStyle('A' . $row . ':B' . $row)->applyFromArray($sectionHeaderStyle);
$sheet->getRowDimension($row)->setRowHeight(25);
$row++;

// Add remaining sections here...

// Write the Excel file
$writer = new Xlsx($spreadsheet);
$filename = 'Rekam_Medis_' . $record['medical_record_number'] . '.xlsx';

// Set headers for download
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="' . $filename . '"');
header('Cache-Control: max-age=0');

$writer->save('php://output');
exit; 