<?php
// Include initialization file
require_once '../../init.php';
// Don't require autoload.php here since it's included later in the file

// Suppress deprecated notices and strict errors
error_reporting(E_ALL & ~E_DEPRECATED & ~E_STRICT);

// Check authentication
if (!isLoggedIn()) {
    redirect('../../auth/login.php');
}

// Validate record ID
if (!isset($_GET['id']) || empty($_GET['id'])) {
    die('ID rekam medis tidak valid.');
}
$recordId = intval($_GET['id']);

// Get medical record data
$record = $db->getRow("SELECT mr.*, p.name as patient_name, p.birth_date, p.gender, p.medical_record_number as patient_mrn,
                      u.name as doctor_name 
                      FROM medical_records mr 
                      JOIN patients p ON mr.patient_id = p.id
                      JOIN users u ON mr.doctor_id = u.id
                      WHERE mr.id = ?i", $recordId);

if (!$record) {
    die('Rekam medis tidak ditemukan.');
}

// Calculate patient's age
$birthDate = new DateTime($record['birth_date']);
$today = new DateTime();
$age = $birthDate->diff($today)->y;

// Set view mode for data_loader.php
$isViewMode = true;

// Load all data for each section
require_once '../includes/data_loader.php';

// Check if mPDF is available (via Composer)
if (!file_exists('../../vendor/autoload.php')) {
    die('mPDF library tidak ditemukan. Silakan install melalui Composer.');
}

require_once '../../vendor/autoload.php';

// Create an mPDF instance (works with mPDF 8.0+)
$mpdf = new \Mpdf\Mpdf([
    'mode' => 'utf-8',
    'format' => 'A4',
    'margin_left' => 15,
    'margin_right' => 15,
    'margin_top' => 16,
    'margin_bottom' => 16,
    'margin_header' => 9,
    'margin_footer' => 9,
    'tempDir' => sys_get_temp_dir(), // Specify a valid temporary directory
]);

// Set document information
$mpdf->SetTitle('Rekam Medis - ' . $record['medical_record_number']);
$mpdf->SetAuthor('Sistem Rekam Medis Ortodontik');
$mpdf->SetCreator('Sistem Rekam Medis Ortodontik');

// Set header
$mpdf->SetHTMLHeader('
<div style="text-align: center; font-weight: bold; font-size: 16pt;">REKAM MEDIS ORTODONTIK</div>
<div style="text-align: center; font-size: 11pt; margin-bottom: 10pt;">Dental Clinic</div>
<hr style="border-top: 2px solid #000000; margin: 0;">
');

// Set footer
$mpdf->SetHTMLFooter('
<table width="100%" style="font-size: 9pt;">
    <tr>
        <td width="33%" style="text-align: left;">Generated: {DATE j-m-Y}</td>
        <td width="33%" style="text-align: center;">Sistem Rekam Medis Ortodontik</td>
        <td width="33%" style="text-align: right;">Halaman {PAGENO} dari {nb}</td>
    </tr>
</table>
');

// Start Building HTML Content
$html = '
<style>
    body {
        font-family: arial, sans-serif;
        font-size: 10pt;
    }
    table {
        border-collapse: collapse;
        width: 100%;
        margin-bottom: 10pt;
    }
    th, td {
        border: 1px solid #dddddd;
        text-align: left;
        padding: 6pt;
    }
    th {
        background-color: #f2f2f2;
    }
    h1 {
        font-size: 14pt;
        color: #333333;
        margin: 12pt 0 6pt 0;
    }
    h2 {
        font-size: 12pt;
        color: #0066cc;
        margin: 10pt 0 6pt 0;
    }
    h3 {
        font-size: 11pt;
        margin: 8pt 0 4pt 0;
    }
    .section {
        margin-bottom: 15pt;
        page-break-inside: avoid;
    }
    .badge {
        padding: 2pt 5pt;
        border-radius: 3pt;
        font-size: 8pt;
        font-weight: bold;
    }
    .badge-success {
        background-color: #28a745;
        color: white;
    }
    .badge-warning {
        background-color: #ffc107;
        color: #212529;
    }
</style>

<div class="section">
    <table>
        <tr>
            <th colspan="4" style="text-align: center; background-color: #0066cc; color: white;">INFORMASI REKAM MEDIS</th>
        </tr>
        <tr>
            <th width="25%">Nomor Rekam Medis</th>
            <td width="25%">' . $record['medical_record_number'] . '</td>
            <th width="25%">Dokter</th>
            <td width="25%">' . $record['doctor_name'] . '</td>
        </tr>
        <tr>
            <th>Pasien</th>
            <td>' . $record['patient_name'] . '</td>
            <th>Tanggal Pemeriksaan</th>
            <td>' . date('d/m/Y', strtotime($record['examination_date'])) . '</td>
        </tr>
        <tr>
            <th>Tanggal Lahir / Usia</th>
            <td>' . date('d/m/Y', strtotime($record['birth_date'])) . ' (' . $age . ' tahun)</td>
            <th>Status</th>
            <td>' . ($record['is_complete'] == 1 ? '<span class="badge badge-success">Selesai</span>' : '<span class="badge badge-warning">Belum Selesai</span>') . '</td>
        </tr>
        <tr>
            <th>Jenis Kelamin</th>
            <td>' . $record['gender'] . '</td>
            <th>Terakhir Diperbarui</th>
            <td>' . date('d/m/Y H:i', strtotime($record['updated_at'])) . '</td>
        </tr>
    </table>
</div>
';

// Section 1: Data Diri Pasien
$html .= '
<div class="section">
    <h1>1. Data Diri Pasien</h1>
    <table>
        <tr>
            <th width="30%">Tanggal Pemeriksaan</th>
            <td>' . date('d/m/Y', strtotime($record['examination_date'])) . '</td>
        </tr>
        <tr>
            <th>Nomor Rekam Medis</th>
            <td>' . $record['medical_record_number'] . '</td>
        </tr>
        <tr>
            <th>Tanggal Lahir</th>
            <td>' . date('d/m/Y', strtotime($record['birth_date'])) . '</td>
        </tr>
        <tr>
            <th>Usia</th>
            <td>' . $age . ' tahun</td>
        </tr>
        <tr>
            <th>Jenis Kelamin</th>
            <td>' . $record['gender'] . '</td>
        </tr>
    </table>
</div>
';

// Section 2: Anamnesis
$html .= '
<div class="section">
    <h1>2. Anamnesis</h1>
    <table>
        <tr>
            <th width="30%">Keluhan Utama Kasus Ortodontik</th>
            <td>' . nl2br(htmlspecialchars($record['chief_complaint'])) . '</td>
        </tr>
        <tr>
            <th>Riwayat Kesehatan Umum</th>
            <td>' . nl2br(htmlspecialchars($record['medical_history'])) . '</td>
        </tr>
        <tr>
            <th>Kebiasaan Buruk</th>
            <td>';

if (!empty($record['bad_habits'])) {
    $badHabits = json_decode($record['bad_habits'], true);
    if (is_array($badHabits)) {
        $html .= implode('<br>', array_map('htmlspecialchars', $badHabits));
    } else {
        $html .= htmlspecialchars($record['bad_habits']);
    }
} else {
    $html .= "-";
}

$html .= '
            </td>
        </tr>
    </table>
</div>
';

// Section 3: Pemeriksaan Ekstra Oral
$html .= '
<div class="section">
    <h1>3. Pemeriksaan Ekstra Oral</h1>
    
    <h2>Vertikal</h2>
    <table>
        <tr>
            <th width="30%">Bentuk Wajah</th>
            <td>' . (!empty($extraOralExam['face_shape']) ? $extraOralExam['face_shape'] : '-') . '</td>
        </tr>
        <tr>
            <th>Keseimbangan Wajah</th>
            <td>';

if (!empty($extraOralExam['vertical_face_balance'])) {
    $html .= $extraOralExam['vertical_face_balance'];
    if (!empty($extraOralExam['vertical_face_balance_value']) && $extraOralExam['vertical_face_balance'] == 'Tidak Seimbang') {
        $html .= ' (' . $extraOralExam['vertical_face_balance_value'] . ' mm)';
    }
} else {
    $html .= '-';
}

$html .= '
            </td>
        </tr>
    </table>
    
    <h2>Transversal</h2>
    <table>
        <tr>
            <th width="30%">Keseimbangan Wajah</th>
            <td>';

if (!empty($extraOralExam['transversal_face_balance'])) {
    $html .= $extraOralExam['transversal_face_balance'];
    if (!empty($extraOralExam['transversal_face_balance_value']) && $extraOralExam['transversal_face_balance'] == 'Tidak Seimbang') {
        $html .= ' (' . $extraOralExam['transversal_face_balance_value'] . ' mm)';
    }
} else {
    $html .= '-';
}

$html .= '
            </td>
        </tr>
        <tr>
            <th>Dagu</th>
            <td>' . (!empty($extraOralExam['chin']) ? $extraOralExam['chin'] : '-') . '</td>
        </tr>
        <tr>
            <th>Garis Tengah Geligi Atas</th>
            <td>';

if (!empty($extraOralExam['upper_dental_midline'])) {
    $html .= $extraOralExam['upper_dental_midline'];
    if (in_array($extraOralExam['upper_dental_midline'], ['Ke Kanan', 'Ke Kiri']) && !empty($extraOralExam['upper_dental_midline_value'])) {
        $html .= ' (' . $extraOralExam['upper_dental_midline_value'] . ' mm)';
    }
} else {
    $html .= '-';
}

$html .= '
            </td>
        </tr>
        <tr>
            <th>Garis Tengah Geligi Bawah</th>
            <td>';

if (!empty($extraOralExam['lower_dental_midline'])) {
    $html .= $extraOralExam['lower_dental_midline'];
    if (in_array($extraOralExam['lower_dental_midline'], ['Ke Kanan', 'Ke Kiri']) && !empty($extraOralExam['lower_dental_midline_value'])) {
        $html .= ' (' . $extraOralExam['lower_dental_midline_value'] . ' mm)';
    }
} else {
    $html .= '-';
}

$html .= '
            </td>
        </tr>
    </table>
    
    <h2>Bibir</h2>
    <table>
        <tr>
            <th width="30%">Tonus Bibir Atas</th>
            <td>' . (!empty($extraOralExam['upper_lip_tonus']) ? $extraOralExam['upper_lip_tonus'] : '-') . '</td>
        </tr>
        <tr>
            <th>Tonus Bibir Bawah</th>
            <td>' . (!empty($extraOralExam['lower_lip_tonus']) ? $extraOralExam['lower_lip_tonus'] : '-') . '</td>
        </tr>
        <tr>
            <th>Kompetensi Bibir</th>
            <td>' . (!empty($extraOralExam['lip_competence']) ? $extraOralExam['lip_competence'] : '-') . '</td>
        </tr>
        <tr>
            <th>Profil E-Line</th>
            <td>' . (!empty($extraOralExam['eline_profile']) ? $extraOralExam['eline_profile'] : '-') . '</td>
        </tr>
        <tr>
            <th>Bibir Atas terhadap E-Line</th>
            <td>' . (!empty($extraOralExam['upper_lip_to_eline']) ? $extraOralExam['upper_lip_to_eline'] . ' mm' : '-') . '</td>
        </tr>
        <tr>
            <th>Bibir Bawah terhadap E-Line</th>
            <td>' . (!empty($extraOralExam['lower_lip_to_eline']) ? $extraOralExam['lower_lip_to_eline'] . ' mm' : '-') . '</td>
        </tr>
    </table>
</div>
';

// Continue building HTML for sections 4-13 in the same pattern...

// Section 4: Pemeriksaan Intra Oral
$html .= '
<div class="section">
    <h1>4. Pemeriksaan Intra Oral</h1>
    <table>
        <tr>
            <th width="30%">Kebersihan Mulut</th>
            <td>' . (!empty($intraOralExam['oral_hygiene']) ? $intraOralExam['oral_hygiene'] : '-') . '</td>
        </tr>
        <tr>
            <th>Frenulum Labii Superior</th>
            <td>' . (!empty($intraOralExam['frenulum_labii_superior']) ? $intraOralExam['frenulum_labii_superior'] : '-') . '</td>
        </tr>
        <tr>
            <th>Frenulum Labii Inferior</th>
            <td>' . (!empty($intraOralExam['frenulum_labii_inferior']) ? $intraOralExam['frenulum_labii_inferior'] : '-') . '</td>
        </tr>
        <tr>
            <th>Lidah</th>
            <td>' . (!empty($intraOralExam['tongue']) ? $intraOralExam['tongue'] : '-') . '</td>
        </tr>
        <tr>
            <th>Palatum</th>
            <td>' . (!empty($intraOralExam['palatum']) ? $intraOralExam['palatum'] : '-') . '</td>
        </tr>
        <tr>
            <th>Adenoid</th>
            <td>' . (!empty($intraOralExam['adenoid']) ? $intraOralExam['adenoid'] : '-') . '</td>
        </tr>
        <tr>
            <th>Crowding</th>
            <td>' . (!empty($intraOralExam['crowding']) ? $intraOralExam['crowding'] : '-') . '</td>
        </tr>
        <tr>
            <th>Hubungan Rahang</th>
            <td>' . (!empty($intraOralExam['jaw_relation']) ? $intraOralExam['jaw_relation'] : '-') . '</td>
        </tr>
        <tr>
            <th>Diastema</th>
            <td>' . (!empty($intraOralExam['diastema']) ? $intraOralExam['diastema'] : '-') . '</td>
        </tr>
        <tr>
            <th>Crossbite</th>
            <td>' . (!empty($intraOralExam['crossbite']) ? $intraOralExam['crossbite'] : '-') . '</td>
        </tr>
        <tr>
            <th>Kelainan Bentuk Gigi</th>
            <td>';

if (!empty($intraOralExam['tooth_shape_abnormality']) && $intraOralExam['tooth_shape_abnormality'] == 'Ada') {
    $html .= 'Ada (Regio: ' . $intraOralExam['tooth_shape_abnormality_region'] . ')';
} else {
    $html .= !empty($intraOralExam['tooth_shape_abnormality']) ? $intraOralExam['tooth_shape_abnormality'] : '-';
}

$html .= '
            </td>
        </tr>
        <tr>
            <th>Kelainan Jumlah Gigi</th>
            <td>';

if (!empty($intraOralExam['tooth_number_abnormality']) && $intraOralExam['tooth_number_abnormality'] == 'Ada') {
    $html .= 'Ada (Regio: ' . $intraOralExam['tooth_number_abnormality_region'] . ')';
} else {
    $html .= !empty($intraOralExam['tooth_number_abnormality']) ? $intraOralExam['tooth_number_abnormality'] : '-';
}

$html .= '
            </td>
        </tr>
    </table>
</div>
';

// Add more sections here...

// Output the PDF
$mpdf->WriteHTML($html);
$filename = 'Rekam_Medis_' . $record['medical_record_number'] . '.pdf';
$mpdf->Output($filename, 'I'); // 'I' means send the file inline to the browser
exit; 