<?php
// Include initialization file
require_once '../../init.php';

// Check authentication
if (!isLoggedIn()) {
    redirect('../../auth/login.php');
}

// Validate record ID
if (!isset($_GET['id']) || empty($_GET['id'])) {
    die('ID rekam medis tidak valid.');
}
$recordId = intval($_GET['id']);

// Get medical record data
$record = $db->getRow("SELECT mr.*, p.name as patient_name, p.birth_date, p.gender, p.medical_record_number as patient_mrn,
                      u.name as doctor_name 
                      FROM medical_records mr 
                      JOIN patients p ON mr.patient_id = p.id
                      JOIN users u ON mr.doctor_id = u.id
                      WHERE mr.id = ?i", $recordId);

if (!$record) {
    die('Rekam medis tidak ditemukan.');
}

// Calculate patient's age
$birthDate = new DateTime($record['birth_date']);
$today = new DateTime();
$age = $birthDate->diff($today)->y;

// Set view mode for data_loader.php
$isViewMode = true;

// Load all data for each section
require_once '../includes/data_loader.php';

// Output HTML directly instead of converting to PDF
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Rekam Medis - <?php echo $record['medical_record_number']; ?></title>
    <style>
    body {
        font-family: arial, sans-serif;
        font-size: 10pt;
        margin: 20px;
    }

    table {
        border-collapse: collapse;
        width: 100%;
        margin-bottom: 10pt;
    }

    th,
    td {
        border: 1px solid #dddddd;
        text-align: left;
        padding: 6pt;
    }

    th {
        background-color: #f2f2f2;
    }

    h1 {
        font-size: 14pt;
        color: #333333;
        margin: 12pt 0 6pt 0;
    }

    h2 {
        font-size: 12pt;
        color: #0066cc;
        margin: 10pt 0 6pt 0;
    }

    h3 {
        font-size: 11pt;
        margin: 8pt 0 4pt 0;
    }

    .section {
        margin-bottom: 15pt;
    }

    .badge {
        padding: 2pt 5pt;
        border-radius: 3pt;
        font-size: 8pt;
        font-weight: bold;
    }

    .badge-success {
        background-color: #28a745;
        color: white;
    }

    .badge-warning {
        background-color: #ffc107;
        color: #212529;
    }

    .header {
        text-align: center;
        margin-bottom: 20px;
    }

    .header h1 {
        font-weight: bold;
        font-size: 16pt;
        margin: 0;
    }

    .header p {
        font-size: 11pt;
        margin: 5px 0;
    }

    hr {
        border-top: 2px solid #000000;
        margin: 10px 0;
    }

    @media print {
        body {
            margin: 0;
            padding: 20px;
        }

        button.print-button {
            display: none;
        }
    }
    </style>
</head>

<body>
    <button class="print-button" onclick="window.print()">Cetak PDF</button>

    <div class="header">
        <h1>REKAM MEDIS ORTODONTIK</h1>
        <p>Dental Clinic</p>
        <hr>
    </div>

    <div class="section">
        <table>
            <tr>
                <th colspan="4" style="text-align: center; background-color: #0066cc; color: white;">INFORMASI REKAM
                    MEDIS</th>
            </tr>
            <tr>
                <th width="25%">Nomor Rekam Medis</th>
                <td width="25%"><?php echo $record['medical_record_number']; ?></td>
                <th width="25%">Dokter</th>
                <td width="25%"><?php echo $record['doctor_name']; ?></td>
            </tr>
            <tr>
                <th>Pasien</th>
                <td><?php echo $record['patient_name']; ?></td>
                <th>Tanggal Pemeriksaan</th>
                <td><?php echo date('d/m/Y', strtotime($record['examination_date'])); ?></td>
            </tr>
            <tr>
                <th>Tanggal Lahir / Usia</th>
                <td><?php echo date('d/m/Y', strtotime($record['birth_date'])) . ' (' . $age . ' tahun)'; ?></td>
                <th>Status</th>
                <td><?php echo ($record['is_complete'] == 1 ? '<span class="badge badge-success">Selesai</span>' : '<span class="badge badge-warning">Belum Selesai</span>'); ?>
                </td>
            </tr>
            <tr>
                <th>Jenis Kelamin</th>
                <td><?php echo $record['gender']; ?></td>
                <th>Terakhir Diperbarui</th>
                <td><?php echo date('d/m/Y H:i', strtotime($record['updated_at'])); ?></td>
            </tr>
        </table>
    </div>

    <!-- Section 1: Data Diri Pasien -->
    <div class="section">
        <h1>1. Data Diri Pasien</h1>
        <table>
            <tr>
                <th width="30%">Tanggal Pemeriksaan</th>
                <td><?php echo date('d/m/Y', strtotime($record['examination_date'])); ?></td>
            </tr>
            <tr>
                <th>Nomor Rekam Medis</th>
                <td><?php echo $record['medical_record_number']; ?></td>
            </tr>
            <tr>
                <th>Tanggal Lahir</th>
                <td><?php echo date('d/m/Y', strtotime($record['birth_date'])); ?></td>
            </tr>
            <tr>
                <th>Usia</th>
                <td><?php echo $age; ?> tahun</td>
            </tr>
            <tr>
                <th>Jenis Kelamin</th>
                <td><?php echo $record['gender']; ?></td>
            </tr>
        </table>
    </div>

    <!-- Section 2: Anamnesis -->
    <div class="section">
        <h1>2. Anamnesis</h1>
        <table>
            <tr>
                <th width="30%">Keluhan Utama Kasus Ortodontik</th>
                <td><?php echo nl2br(htmlspecialchars($record['chief_complaint'])); ?></td>
            </tr>
            <tr>
                <th>Riwayat Kesehatan Umum</th>
                <td><?php echo nl2br(htmlspecialchars($record['medical_history'])); ?></td>
            </tr>
            <tr>
                <th>Kebiasaan Buruk</th>
                <td>
                    <?php
                if (!empty($record['bad_habits'])) {
                    $badHabits = json_decode($record['bad_habits'], true);
                    if (is_array($badHabits)) {
                        echo implode('<br>', array_map('htmlspecialchars', $badHabits));
                    } else {
                        echo htmlspecialchars($record['bad_habits']);
                    }
                } else {
                    echo "-";
                }
                ?>
                </td>
            </tr>
        </table>
    </div>

    <!-- Section 3: Pemeriksaan Ekstra Oral -->
    <div class="section">
        <h1>3. Pemeriksaan Ekstra Oral</h1>

        <h2>Vertikal</h2>
        <table>
            <tr>
                <th width="30%">Bentuk Wajah</th>
                <td><?php echo !empty($extraOralExam['face_shape']) ? $extraOralExam['face_shape'] : '-'; ?></td>
            </tr>
            <tr>
                <th>Keseimbangan Wajah</th>
                <td>
                    <?php
                if (!empty($extraOralExam['vertical_face_balance'])) {
                    echo $extraOralExam['vertical_face_balance'];
                    if (!empty($extraOralExam['vertical_face_balance_value']) && $extraOralExam['vertical_face_balance'] == 'Tidak Seimbang') {
                        echo ' (' . $extraOralExam['vertical_face_balance_value'] . ' mm)';
                    }
                } else {
                    echo '-';
                }
                ?>
                </td>
            </tr>
        </table>

        <!-- Add more sections as needed -->
    </div>

    <script>
    // Auto-print when page loads
    window.onload = function() {
        // Give a small delay for the browser to properly render the page
        setTimeout(function() {
            window.print();
        }, 1000);
    };
    </script>
</body>

</html>