<?php
// Include initialization file
require_once '../../init.php';

// Check authentication
if (!isLoggedIn()) {
    redirect('../../auth/login.php');
}

// Validate record ID
if (!isset($_GET['id']) || empty($_GET['id'])) {
    die('ID rekam medis tidak valid.');
}
$recordId = intval($_GET['id']);

// Get medical record data
$record = $db->getRow("SELECT mr.*, p.name as patient_name, p.birth_date, p.gender, p.medical_record_number as patient_mrn,
                      u.name as doctor_name 
                      FROM medical_records mr 
                      JOIN patients p ON mr.patient_id = p.id
                      JOIN users u ON mr.doctor_id = u.id
                      WHERE mr.id = ?i", $recordId);

if (!$record) {
    die('Rekam medis tidak ditemukan.');
}

// Calculate patient's age
$birthDate = new DateTime($record['birth_date']);
$today = new DateTime();
$age = $birthDate->diff($today)->y;

// Load all data for each section
require_once '../includes/data_loader.php';

// Check if PHPWord is available (via Composer)
if (!file_exists('../../vendor/autoload.php')) {
    die('PHPWord library tidak ditemukan. Silakan install melalui Composer.');
}

require_once '../../vendor/autoload.php';

use PhpOffice\PhpWord\PhpWord;
use PhpOffice\PhpWord\Style\Font;
use PhpOffice\PhpWord\Style\TOC;
use PhpOffice\PhpWord\Style\Table;
use PhpOffice\PhpWord\SimpleType\TblWidth;
use PhpOffice\PhpWord\Style\Cell;
use PhpOffice\PhpWord\Style\Border;

// Create a new PHPWord document
$phpWord = new PhpWord();

// Set document properties
$phpWord->getDocInfo()
    ->setCreator('Sistem Rekam Medis Ortodontik')
    ->setCompany('Dental Clinic')
    ->setTitle('Rekam Medis - ' . $record['medical_record_number'])
    ->setDescription('Rekam Medis untuk pasien ' . $record['patient_name'])
    ->setCategory('Medical Records')
    ->setLastModifiedBy('Sistem Rekam Medis Ortodontik');

// Add styles
$phpWord->addTitleStyle(1, ['bold' => true, 'size' => 16], ['spaceBefore' => 240, 'spaceAfter' => 120]);
$phpWord->addTitleStyle(2, ['bold' => true, 'size' => 14], ['spaceBefore' => 180, 'spaceAfter' => 120]);
$phpWord->addTitleStyle(3, ['bold' => true, 'size' => 12], ['spaceBefore' => 120, 'spaceAfter' => 120]);

// Define table styles
$tableStyle = [
    'borderSize' => 6,
    'borderColor' => '999999',
    'cellMargin' => 80,
    'alignment' => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER,
    'width' => 100 * 50,
];

$firstRowStyle = [
    'bgColor' => '0066CC',
    'bold' => true,
    'textColor' => 'FFFFFF',
];

$cellRowStyle = [
    'valign' => 'center',
];

$cellColSpan = ['gridSpan' => 2, 'valign' => 'center'];

// Create the document
$section = $phpWord->addSection();

// Add title
$section->addTitle('REKAM MEDIS ORTODONTIK', 1);
$section->addTextBreak(1);

// Medical Record Information
$section->addTitle('INFORMASI REKAM MEDIS', 2);
$table = $section->addTable($tableStyle);

// Row 1 - Header
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => '0066CC']);
$cell->addText('Nomor Rekam Medis', ['bold' => true, 'color' => 'FFFFFF']);
$cell = $table->addCell(7500);
$cell->addText($record['medical_record_number']);

// Row 2
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Pasien', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText($record['patient_name']);

// Row 3
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Tanggal Lahir / Usia', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(date('d/m/Y', strtotime($record['birth_date'])) . ' (' . $age . ' tahun)');

// Row 4
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Jenis Kelamin', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText($record['gender']);

// Row 5
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Dokter', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText($record['doctor_name']);

// Row 6
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Tanggal Pemeriksaan', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(date('d/m/Y', strtotime($record['examination_date'])));

// Row 7
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Status', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText($record['is_complete'] == 1 ? 'Selesai' : 'Belum Selesai');

// Row 8
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Terakhir Diperbarui', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(date('d/m/Y H:i', strtotime($record['updated_at'])));

$section->addTextBreak(1);

// Section 1: Data Diri Pasien
$section->addTitle('1. DATA DIRI PASIEN', 2);
$table = $section->addTable($tableStyle);

// Row 1
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Tanggal Pemeriksaan', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(date('d/m/Y', strtotime($record['examination_date'])));

// Row 2
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Nomor Rekam Medis', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText($record['medical_record_number']);

// Row 3
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Tanggal Lahir', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(date('d/m/Y', strtotime($record['birth_date'])));

// Row 4
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Usia', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText($age . ' tahun');

// Row 5
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Jenis Kelamin', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText($record['gender']);

$section->addTextBreak(1);

// Section 2: Anamnesis
$section->addTitle('2. ANAMNESIS', 2);
$table = $section->addTable($tableStyle);

// Row 1
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Keluhan Utama Kasus Ortodontik', ['bold' => true]);
$cell = $table->addCell(7500);
$textLines = explode("\n", $record['chief_complaint']);
foreach ($textLines as $line) {
    $cell->addText($line);
}

// Row 2
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Riwayat Kesehatan Umum', ['bold' => true]);
$cell = $table->addCell(7500);
$textLines = explode("\n", $record['medical_history']);
foreach ($textLines as $line) {
    $cell->addText($line);
}

// Row 3
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Kebiasaan Buruk', ['bold' => true]);
$cell = $table->addCell(7500);

$badHabitsText = '';
if (!empty($record['bad_habits'])) {
    $badHabits = json_decode($record['bad_habits'], true);
    if (is_array($badHabits)) {
        foreach ($badHabits as $habit) {
            $cell->addText($habit);
        }
    } else {
        $cell->addText($record['bad_habits']);
    }
} else {
    $cell->addText('-');
}

$section->addTextBreak(1);

// Section 3: Pemeriksaan Ekstra Oral
$section->addTitle('3. PEMERIKSAAN EKSTRA ORAL', 2);

// Subsection: Vertikal
$section->addTitle('Vertikal', 3);
$table = $section->addTable($tableStyle);

// Row 1
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Bentuk Wajah', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(!empty($extraOralExam['face_shape']) ? $extraOralExam['face_shape'] : '-');

// Row 2
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Keseimbangan Wajah', ['bold' => true]);
$cell = $table->addCell(7500);

$faceBalanceText = !empty($extraOralExam['vertical_face_balance']) ? $extraOralExam['vertical_face_balance'] : '-';
if (!empty($extraOralExam['vertical_face_balance_value']) && $extraOralExam['vertical_face_balance'] == 'Tidak Seimbang') {
    $faceBalanceText .= ' (' . $extraOralExam['vertical_face_balance_value'] . ' mm)';
}
$cell->addText($faceBalanceText);

// Subsection: Transversal
$section->addTitle('Transversal', 3);
$table = $section->addTable($tableStyle);

// Row 1
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Keseimbangan Wajah', ['bold' => true]);
$cell = $table->addCell(7500);

$transversalBalanceText = !empty($extraOralExam['transversal_face_balance']) ? $extraOralExam['transversal_face_balance'] : '-';
if (!empty($extraOralExam['transversal_face_balance_value']) && $extraOralExam['transversal_face_balance'] == 'Tidak Seimbang') {
    $transversalBalanceText .= ' (' . $extraOralExam['transversal_face_balance_value'] . ' mm)';
}
$cell->addText($transversalBalanceText);

// Row 2
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Dagu', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(!empty($extraOralExam['chin']) ? $extraOralExam['chin'] : '-');

// Row 3
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Garis Tengah Geligi Atas', ['bold' => true]);
$cell = $table->addCell(7500);

$upperDentalText = !empty($extraOralExam['upper_dental_midline']) ? $extraOralExam['upper_dental_midline'] : '-';
if (in_array($extraOralExam['upper_dental_midline'] ?? '', ['Ke Kanan', 'Ke Kiri']) && !empty($extraOralExam['upper_dental_midline_value'])) {
    $upperDentalText .= ' (' . $extraOralExam['upper_dental_midline_value'] . ' mm)';
}
$cell->addText($upperDentalText);

// Row 4
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Garis Tengah Geligi Bawah', ['bold' => true]);
$cell = $table->addCell(7500);

$lowerDentalText = !empty($extraOralExam['lower_dental_midline']) ? $extraOralExam['lower_dental_midline'] : '-';
if (in_array($extraOralExam['lower_dental_midline'] ?? '', ['Ke Kanan', 'Ke Kiri']) && !empty($extraOralExam['lower_dental_midline_value'])) {
    $lowerDentalText .= ' (' . $extraOralExam['lower_dental_midline_value'] . ' mm)';
}
$cell->addText($lowerDentalText);

// Subsection: Bibir
$section->addTitle('Bibir', 3);
$table = $section->addTable($tableStyle);

// Row 1
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Tonus Bibir Atas', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(!empty($extraOralExam['upper_lip_tonus']) ? $extraOralExam['upper_lip_tonus'] : '-');

// Row 2
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Tonus Bibir Bawah', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(!empty($extraOralExam['lower_lip_tonus']) ? $extraOralExam['lower_lip_tonus'] : '-');

// Row 3
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Kompetensi Bibir', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(!empty($extraOralExam['lip_competence']) ? $extraOralExam['lip_competence'] : '-');

// Row 4
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Profil E-Line', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(!empty($extraOralExam['eline_profile']) ? $extraOralExam['eline_profile'] : '-');

// Row 5
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Bibir Atas terhadap E-Line', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(!empty($extraOralExam['upper_lip_to_eline']) ? $extraOralExam['upper_lip_to_eline'] . ' mm' : '-');

// Row 6
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Bibir Bawah terhadap E-Line', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(!empty($extraOralExam['lower_lip_to_eline']) ? $extraOralExam['lower_lip_to_eline'] . ' mm' : '-');

$section->addTextBreak(1);

// Section 4: Pemeriksaan Intra Oral
$section->addTitle('4. PEMERIKSAAN INTRA ORAL', 2);
$table = $section->addTable($tableStyle);

// Row 1
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Kebersihan Mulut', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(!empty($intraOralExam['oral_hygiene']) ? $intraOralExam['oral_hygiene'] : '-');

// Row 2
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Frenulum Labii Superior', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(!empty($intraOralExam['frenulum_labii_superior']) ? $intraOralExam['frenulum_labii_superior'] : '-');

// Row 3
$table->addRow();
$cell = $table->addCell(2500, ['bgColor' => 'F2F2F2']);
$cell->addText('Frenulum Labii Inferior', ['bold' => true]);
$cell = $table->addCell(7500);
$cell->addText(!empty($intraOralExam['frenulum_labii_inferior']) ? $intraOralExam['frenulum_labii_inferior'] : '-');

// Continue with remaining sections here...

// Save the document
$filename = 'Rekam_Medis_' . $record['medical_record_number'] . '.docx';
header('Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');
header('Content-Disposition: attachment;filename="' . $filename . '"');
header('Cache-Control: max-age=0');

$objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
$objWriter->save('php://output');
exit; 