<?php
/**
 * AJAX endpoint to get tooth data from section 8 (Model Analysis)
 */

// Include the initialization file
require_once '../../../init.php';

// Check if the user is logged in
if (!isLoggedIn()) {
    // Return error response
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => 'Unauthorized access.'
    ]);
    exit;
}

// Check if record ID is provided
if (!isset($_POST['record_id']) || empty($_POST['record_id'])) {
    // Return error response
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => 'Record ID is required.'
    ]);
    exit;
}

// Get the record ID
$recordId = intval($_POST['record_id']);

// Check if the user has access to this record (e.g., is a doctor)
if (!isDoctor()) {
    // Return error response
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => 'You do not have permission to access this record.'
    ]);
    exit;
}

// Get the tooth data from the model_analyses table
$modelAnalysis = $db->getRow("SELECT * FROM model_analyses WHERE medical_record_id = ?i", $recordId);

if (!$modelAnalysis) {
    // Return empty response if no data is found
    header('Content-Type: application/json');
    echo json_encode([
        'success' => true,
        'tooth_data' => null,
        'message' => 'No model analysis data found for this record.'
    ]);
    exit;
}

// Get the tooth data
$toothData = !empty($modelAnalysis['tooth_data']) ? json_decode($modelAnalysis['tooth_data'], true) : null;

// Return the tooth data
header('Content-Type: application/json');
echo json_encode([
    'success' => true,
    'tooth_data' => $toothData
]);
exit; 