<?php
// Load all necessary data for the sections
// This centralized approach ensures data is loaded only when needed

// Common data used by many sections
$extraOralExam = $db->getRow("SELECT * FROM extra_oral_examinations WHERE medical_record_id = ?i", $recordId);
$intraOralExam = $db->getRow("SELECT * FROM intra_oral_examinations WHERE medical_record_id = ?i", $recordId);
$toothRelationExam = $db->getRow("SELECT * FROM tooth_relation_examinations WHERE medical_record_id = ?i", $recordId);

// Check if we're in view mode or edit mode - now using the parameter instead of filename
// $isViewMode = basename($_SERVER['PHP_SELF']) === 'view.php';
// $isViewMode is now set in the parent file (edit.php)

// If in view mode, load all sections data at once
if ($isViewMode) {
    $functionalExam = $db->getRow("SELECT * FROM functional_examinations WHERE medical_record_id = ?i", $recordId);
    $radiologicalExam = $db->getRow("SELECT * FROM radiological_examinations WHERE medical_record_id = ?i", $recordId);
    $cephalometricAnalysis = $db->getRow("SELECT * FROM cephalometric_analyses WHERE medical_record_id = ?i", $recordId);
    $panoramicAnalysis = $db->getRow("SELECT * FROM panoramic_analyses WHERE medical_record_id = ?i", $recordId);
    $otherRadiographs = $db->getAll("SELECT * FROM other_radiographs WHERE medical_record_id = ?i", $recordId);
    $modelAnalysis = $db->getRow("SELECT * FROM model_analyses WHERE medical_record_id = ?i", $recordId);
    $spaceAnalysis = $db->getRow("SELECT * FROM space_analyses WHERE medical_record_id = ?i", $recordId);
    $diagnosis = $db->getRow("SELECT * FROM diagnoses WHERE medical_record_id = ?i", $recordId);
    $treatmentPlan = $db->getRow("SELECT * FROM treatment_plans WHERE medical_record_id = ?i", $recordId);
    $applianceImage = $db->getRow("SELECT * FROM appliance_images WHERE medical_record_id = ?i", $recordId);
    $patientPhotos = $db->getAll("SELECT * FROM patient_photos WHERE medical_record_id = ?i ORDER BY type, category", $recordId);
}
// Section-specific data loading (loaded conditionally based on current section)
else if (isset($currentSection)) {
    switch ($currentSection) {
        case 6:
            $functionalExam = $db->getRow("SELECT * FROM functional_examinations WHERE medical_record_id = ?i", $recordId);
            break;
        case 7:
            $radiologicalExam = $db->getRow("SELECT * FROM radiological_examinations WHERE medical_record_id = ?i", $recordId);
            $cephalometricAnalysis = $db->getRow("SELECT * FROM cephalometric_analyses WHERE medical_record_id = ?i", $recordId);
            $panoramicAnalysis = $db->getRow("SELECT * FROM panoramic_analyses WHERE medical_record_id = ?i", $recordId);
            $otherRadiographs = $db->getAll("SELECT * FROM other_radiographs WHERE medical_record_id = ?i", $recordId);
            break;
        case 8:
            $modelAnalysis = $db->getRow("SELECT * FROM model_analyses WHERE medical_record_id = ?i", $recordId);
            break;
        case 9:
            $spaceAnalysis = $db->getRow("SELECT * FROM space_analyses WHERE medical_record_id = ?i", $recordId);
            break;
        case 10:
            $diagnosis = $db->getRow("SELECT * FROM diagnoses WHERE medical_record_id = ?i", $recordId);
            break;
        case 11:
            $treatmentPlan = $db->getRow("SELECT * FROM treatment_plans WHERE medical_record_id = ?i", $recordId);
            break;
        case 12:
            $applianceImage = $db->getRow("SELECT * FROM appliance_images WHERE medical_record_id = ?i", $recordId);
            break;
        case 13:
            $patientPhotos = $db->getAll("SELECT * FROM patient_photos WHERE medical_record_id = ?i ORDER BY type, category", $recordId);
            break;
    }
}

// Parse bad habits
$badHabits = [];
$badHabitsOther = '';
if (!empty($record['bad_habits'])) {
    // Try to decode as JSON first (newer format)
    $decoded = json_decode($record['bad_habits'], true);
    if (is_array($decoded)) {
        $badHabits = $decoded;
        // Extract "Lain-lain" if present
        foreach ($badHabits as $key => $habit) {
            if (strpos($habit, 'Lain-lain: ') === 0) {
                $badHabitsOther = substr($habit, strlen('Lain-lain: '));
                $badHabits[$key] = 'Lain-lain';
                break;
            }
        }
    } else {
        // Fall back to comma-separated format (legacy)
        $badHabitsArray = explode(', ', $record['bad_habits']);
        foreach ($badHabitsArray as $habit) {
            if (strpos($habit, 'Lain-lain: ') === 0) {
                $badHabitsOther = substr($habit, strlen('Lain-lain: '));
                $badHabits[] = 'Lain-lain';
            } else {
                $badHabits[] = $habit;
            }
        }
    }
}

// Function to get section title
function getSectionTitle($section) {
    $titles = [
        1 => 'Data Diri Pasien',
        2 => 'Anamnesis',
        3 => 'Pemeriksaan Ekstra Oral',
        4 => 'Pemeriksaan Intra Oral',
        5 => 'Relasi Gigi Geligi',
        6 => 'Analisis Fungsional',
        7 => 'Analisis Radiologis',
        8 => 'Analisis Model',
        9 => 'Analisis Kebutuhan Ruang',
        10 => 'Diagnosis',
        11 => 'Rencana Terapi',
        12 => 'Gambar Alat',
        13 => 'Foto'
    ];
    
    return $titles[$section] ?? 'Bagian ' . $section;
}


// Helper function for view mode text display
function viewModeDisplay($value, $isHtml = false) {
    if (empty($value) && $value !== 0 && $value !== '0') {
        return '<span class="text-muted">-</span>';
    }
    
    return $isHtml ? $value : htmlspecialchars($value);
}

// Helper function for view mode boolean display (Yes/No in Indonesian)
function viewModeBooleanDisplay($value, $trueText = 'Ya', $falseText = 'Tidak') {
    if ($value === null) {
        return '<span class="text-muted">-</span>';
    }
    
    return $value ? $trueText : $falseText;
}

// Helper function for view mode date display
function viewModeDateDisplay($dateValue) {
    if (empty($dateValue)) {
        return '<span class="text-muted">-</span>';
    }
    
    return formatDate($dateValue);
}

?>