<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title>Edit Rekam Medis &mdash; Sistem Rekam Medis Ortodontik</title>

    <!-- General CSS Files -->
    <link rel="stylesheet" href="../assets/modules/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/modules/fontawesome/css/all.min.css">

    <!-- CSS Libraries -->
    <link rel="stylesheet" href="../assets/modules/bootstrap-daterangepicker/daterangepicker.css">
    <link rel="stylesheet" href="../assets/modules/select2/dist/css/select2.min.css">
    <link rel="stylesheet" href="../assets/modules/izitoast/css/iziToast.min.css">

    <!-- Template CSS -->
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/components.css">
    <link rel="stylesheet" href="../assets/css/custom.css">

    <!-- Custom CSS for wizard steps -->
    <style>
    .wizard-steps .wizard-step {
        flex: 1;
        text-align: center;
        padding: 10px;
        cursor: pointer;
    }

    .wizard-steps .wizard-step.active {
        font-weight: bold;
        background-color: #6777ef;
        color: white;
    }

    .wizard-steps .wizard-step.done {
        background-color: #63ed7a;
        color: white;
    }
    </style>
</head>

<body>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <!-- Header -->
            <?php include '../layouts/header.php'; ?>

            <!-- Sidebar -->
            <?php include '../layouts/sidebar.php'; ?>

            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="section-header">
                        <h1>Edit Rekam Medis</h1>
                        <div class="section-header-breadcrumb">
                            <div class="breadcrumb-item active"><a href="../index.php">Dashboard</a></div>
                            <div class="breadcrumb-item"><a href="index.php">Rekam Medis</a></div>
                            <div class="breadcrumb-item">Edit</div>
                        </div>
                    </div>

                    <?php
                    $patient = $db->getRow("SELECT * FROM patients WHERE id = ?i", $record['patient_id']);
                    $age = date_diff(date_create($patient['birth_date']), date_create('now'))->y;
                    ?>
                    <div class="section-body">
                        <h2 class="section-title">Rekam Medis: <?php echo $record['medical_record_number']; ?></h2>
                        <p class="section-lead">
                            Pasien: <?php echo $patient['name']; ?> (<?php echo $age; ?> tahun)
                            <span class="float-right">
                                <a href="view.php?id=<?php echo $recordId; ?>" class="btn btn-primary btn-sm">
                                    <i class="fas fa-eye"></i> Lihat Data Lengkap
                                </a>
                            </span>
                        </p>

                        <!-- <?php if (!empty($errorMessage)): ?>
                        <div class="alert alert-danger alert-dismissible show fade">
                            <div class="alert-body">
                                <button class="close" data-dismiss="alert">
                                    <span>&times;</span>
                                </button>
                                <?php echo $errorMessage; ?>
                            </div>
                        </div>
                        <?php endif; ?>

                        <?php if (!empty($successMessage)): ?>
                        <div class="alert alert-success alert-dismissible show fade">
                            <div class="alert-body">
                                <button class="close" data-dismiss="alert">
                                    <span>&times;</span>
                                </button>
                                <?php echo $successMessage; ?>
                            </div>
                        </div>
                        <?php endif; ?> -->

                        <!-- Navigation Steps -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <div class="wizard-steps">
                                    <?php for ($i = 1; $i <= $totalSections; $i++): ?>
                                    <div class="wizard-step <?php echo $i < $currentSection ? 'done' : ($i == $currentSection ? 'active' : ''); ?>"
                                        onclick="window.location='edit.php?id=<?php echo $recordId; ?>&section=<?php echo $i; ?>'">
                                        <div class="wizard-step-icon">
                                            <?php echo $i; ?>
                                        </div>
                                        <div class="wizard-step-label">
                                            <?php echo getSectionTitle($i); ?>
                                        </div>
                                    </div>
                                    <?php endfor; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Form Start -->
                        <form action="" method="POST" enctype="multipart/form-data">