<?php
// Include initialization file
require_once '../../../init.php';

// Set content type to JSON
header('Content-Type: application/json');

// Authentication and authorization checks
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Anda tidak login.']);
    exit;
}

if (!isDoctor()) {
    echo json_encode(['success' => false, 'message' => 'Anda tidak memiliki izin untuk menghapus foto.']);
    exit;
}

// Validate photo ID
if (!isset($_POST['photo_id']) || empty($_POST['photo_id'])) {
    echo json_encode(['success' => false, 'message' => 'ID foto tidak valid.']);
    exit;
}

$photoId = intval($_POST['photo_id']);

// Get photo information before deleting
$photo = $db->getRow("SELECT * FROM patient_photos WHERE id = ?i", $photoId);

if (!$photo) {
    echo json_encode(['success' => false, 'message' => 'Foto tidak ditemukan.']);
    exit;
}

// Check if user has permission to delete this photo (belongs to a medical record they can edit)
$recordId = $photo['medical_record_id'];
$record = $db->getRow("SELECT * FROM medical_records WHERE id = ?i", $recordId);

if (!$record) {
    echo json_encode(['success' => false, 'message' => 'Rekam medis tidak ditemukan.']);
    exit;
}

if ($record['is_complete'] == 1) {
    echo json_encode(['success' => false, 'message' => 'Rekam medis sudah selesai dan tidak dapat diedit.']);
    exit;
}

// Delete the physical file
$filePath = $_SERVER['DOCUMENT_ROOT'] . $photo['photo_path'];
if (file_exists($filePath)) {
    if (!unlink($filePath)) {
        // Log error but continue with database deletion
        error_log("Failed to delete file: $filePath");
    }
}

// Delete from database
$result = $db->query("DELETE FROM patient_photos WHERE id = ?i", $photoId);

if ($result) {
    echo json_encode(['success' => true, 'message' => 'Foto berhasil dihapus.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Gagal menghapus foto dari database.']);
} 