<?php
// Process Section 10 (Diagnosis)

// Get and sanitize form data
$skeletalMalocclusion = $_POST['skeletal_malocclusion'] ?? null;
$angleMalocclusion = $_POST['angle_malocclusion'] ?? null;
$cleftLip = $_POST['cleft_lip'] ?? null;
$cleftLipPalate = $_POST['cleft_lip_palate'] ?? null;
$cleftPalate = $_POST['cleft_palate'] ?? null;
$syndrome = $_POST['syndrome'] ?? null;
$syndromeName = $_POST['syndrome_name'] ?? null;

// Sanitize inputs
$skeletalMalocclusion = sanitize($skeletalMalocclusion);
$angleMalocclusion = sanitize($angleMalocclusion);
$cleftLip = sanitize($cleftLip);
$cleftLipPalate = sanitize($cleftLipPalate);
$cleftPalate = sanitize($cleftPalate);
$syndrome = sanitize($syndrome);
$syndromeName = sanitize($syndromeName);

// If syndrome is not "Ya", set syndrome name to null
if ($syndrome !== 'Ya') {
    $syndromeName = null;
}

// Check if a record already exists for this medical record
$existing = $db->getRow("SELECT id FROM diagnoses WHERE medical_record_id = ?i", $recordId);

if ($existing) {
    // Update existing record
    $result = $db->query(
        "UPDATE diagnoses SET 
        skeletal_malocclusion = ?s,
        angle_malocclusion = ?s,
        cleft_lip = ?s,
        cleft_lip_palate = ?s,
        cleft_palate = ?s,
        syndrome = ?s,
        syndrome_name = ?s,
        updated_by = ?i,
        updated_at = NOW()
        WHERE medical_record_id = ?i",
        $skeletalMalocclusion, $angleMalocclusion, $cleftLip, $cleftLipPalate, 
        $cleftPalate, $syndrome, $syndromeName, $_SESSION['user_id'], $recordId
    );
} else {
    // Insert new record
    $result = $db->query(
        "INSERT INTO diagnoses (
            medical_record_id, skeletal_malocclusion, angle_malocclusion, 
            cleft_lip, cleft_lip_palate, cleft_palate, syndrome, syndrome_name,
            created_by, updated_by
        ) VALUES (
            ?i, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?i, ?i
        )",
        $recordId, $skeletalMalocclusion, $angleMalocclusion, $cleftLip, 
        $cleftLipPalate, $cleftPalate, $syndrome, $syndromeName,
        $_SESSION['user_id'], $_SESSION['user_id']
    );
}

// Handle result
if ($result) {
    $successMessage = 'Data diagnosis berhasil disimpan.';
    
    // Refresh the diagnosis data
    $diagnosis = $db->getRow("SELECT * FROM diagnoses WHERE medical_record_id = ?i", $recordId);
    
    // Handle navigation
    if (isset($_POST['save_and_next'])) {
        // Set flash message before redirecting
        setFlashMessage($successMessage, 'success');
        redirect('edit.php?id=' . $recordId . '&section=' . ($currentSection + 1));
    } elseif (isset($_POST['save_and_complete'])) {
        $db->query("UPDATE medical_records SET is_complete = 1, updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
            $_SESSION['user_id'], $recordId);
        setFlashMessage('Rekam medis berhasil diselesaikan.', 'success');
        redirect('view.php?id=' . $recordId);
    }
} else {
    $errorMessage = 'Terjadi kesalahan saat menyimpan data diagnosis.';
}
?> 