<?php
// Process Section 11 (Rencana Terapi)

// Get checkbox values (set to 0 if not checked)
$orthodonticTreatment = isset($_POST['orthodontic_treatment']) ? 1 : 0;
$functionalTreatment = isset($_POST['functional_treatment']) ? 1 : 0;
$surgicalTreatment = isset($_POST['surgical_treatment']) ? 1 : 0;

// Main appliances
$conventionalFixed = isset($_POST['conventional_fixed']) ? 1 : 0;
$selfLigatingFixed = isset($_POST['self_ligating_fixed']) ? 1 : 0;
$removableAppliance = isset($_POST['removable_appliance']) ? 1 : 0;
$myofunctional = isset($_POST['myofunctional']) ? 1 : 0;
$myofunctionalType = $myofunctional ? sanitize($_POST['myofunctional_type'] ?? '') : null;
$clearAligner = isset($_POST['clear_aligner']) ? 1 : 0;

// Additional appliances
$miniscrew = isset($_POST['miniscrew']) ? 1 : 0;
$rpe = isset($_POST['rpe']) ? 1 : 0;
$tpa = isset($_POST['tpa']) ? 1 : 0;
$pendex = isset($_POST['pendex']) ? 1 : 0;
$nance = isset($_POST['nance']) ? 1 : 0;
$otherAppliance = isset($_POST['other_appliance']) ? 1 : 0;
$otherApplianceType = $otherAppliance ? sanitize($_POST['other_appliance_type'] ?? '') : null;

// Retainers
$essixRetainer = isset($_POST['essix_retainer']) ? 1 : 0;
$hawleyRetainer = isset($_POST['hawley_retainer']) ? 1 : 0;
$fixedRetainer = isset($_POST['fixed_retainer']) ? 1 : 0;
$otherRetainer = isset($_POST['other_retainer']) ? 1 : 0;
$otherRetainerType = $otherRetainer ? sanitize($_POST['other_retainer_type'] ?? '') : null;

// Check if a record already exists for this medical record
$existing = $db->getRow("SELECT id FROM treatment_plans WHERE medical_record_id = ?i", $recordId);

if ($existing) {
    // Update existing record
    $result = $db->query(
        "UPDATE treatment_plans SET 
        orthodontic_treatment = ?i,
        functional_treatment = ?i,
        surgical_treatment = ?i,
        conventional_fixed = ?i,
        self_ligating_fixed = ?i,
        removable_appliance = ?i,
        myofunctional = ?i,
        myofunctional_type = ?s,
        clear_aligner = ?i,
        miniscrew = ?i,
        rpe = ?i,
        tpa = ?i,
        pendex = ?i,
        nance = ?i,
        other_appliance = ?i,
        other_appliance_type = ?s,
        essix_retainer = ?i,
        hawley_retainer = ?i,
        fixed_retainer = ?i,
        other_retainer = ?i,
        other_retainer_type = ?s,
        updated_by = ?i,
        updated_at = NOW()
        WHERE medical_record_id = ?i",
        $orthodonticTreatment, $functionalTreatment, $surgicalTreatment,
        $conventionalFixed, $selfLigatingFixed, $removableAppliance, $myofunctional, $myofunctionalType, $clearAligner,
        $miniscrew, $rpe, $tpa, $pendex, $nance, $otherAppliance, $otherApplianceType,
        $essixRetainer, $hawleyRetainer, $fixedRetainer, $otherRetainer, $otherRetainerType,
        $_SESSION['user_id'], $recordId
    );
} else {
    // Insert new record
    $result = $db->query(
        "INSERT INTO treatment_plans (
            medical_record_id, orthodontic_treatment, functional_treatment, surgical_treatment,
            conventional_fixed, self_ligating_fixed, removable_appliance, myofunctional, myofunctional_type, clear_aligner,
            miniscrew, rpe, tpa, pendex, nance, other_appliance, other_appliance_type,
            essix_retainer, hawley_retainer, fixed_retainer, other_retainer, other_retainer_type,
            created_by, updated_by
        ) VALUES (
            ?i, ?i, ?i, ?i, ?i, ?i, ?i, ?i, ?s, ?i, ?i, ?i, ?i, ?i, ?i, ?i, ?s, ?i, ?i, ?i, ?i, ?s, ?i, ?i
        )",
        $recordId, $orthodonticTreatment, $functionalTreatment, $surgicalTreatment,
        $conventionalFixed, $selfLigatingFixed, $removableAppliance, $myofunctional, $myofunctionalType, $clearAligner,
        $miniscrew, $rpe, $tpa, $pendex, $nance, $otherAppliance, $otherApplianceType,
        $essixRetainer, $hawleyRetainer, $fixedRetainer, $otherRetainer, $otherRetainerType,
        $_SESSION['user_id'], $_SESSION['user_id']
    );
}

// Handle result
if ($result) {
    $successMessage = 'Data rencana terapi berhasil disimpan.';
    
    // Refresh the treatment plan data
    $treatmentPlan = $db->getRow("SELECT * FROM treatment_plans WHERE medical_record_id = ?i", $recordId);
    
    // Handle navigation
    if (isset($_POST['save_and_next'])) {
        // Set flash message before redirecting
        setFlashMessage($successMessage, 'success');
        redirect('edit.php?id=' . $recordId . '&section=' . ($currentSection + 1));
    } elseif (isset($_POST['save_and_complete'])) {
        $db->query("UPDATE medical_records SET is_complete = 1, updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
            $_SESSION['user_id'], $recordId);
        setFlashMessage('Rekam medis berhasil diselesaikan.', 'success');
        redirect('view.php?id=' . $recordId);
    }
} else {
    $errorMessage = 'Terjadi kesalahan saat menyimpan data rencana terapi.';
}
?> 