<?php
// Process Section 12 (Gambar Alat)

// Check if this is an AJAX request or a form submission
$isAjax = isset($_POST['action']) && $_POST['action'] === 'save_canvas';

if ($isAjax) {
    // For AJAX requests, we need to initialize the database connection and get the record ID
    require_once '../../../init.php';
    
    if (!isLoggedIn() || !isDoctor()) {
        echo json_encode(['success' => false, 'message' => 'Unauthorized']);
        exit;
    }
    
    $recordId = (int) $_POST['record_id'];
    if (!$recordId) {
        echo json_encode(['success' => false, 'message' => 'Invalid record ID']);
        exit;
    }
    
    $canvasData = $_POST['canvas_data'] ?? '';
} else {
    // Regular form submission, get canvas data from form
    $canvasData = $_POST['canvas_data'] ?? '';
}

// Sanitize the canvas data (but don't modify the JSON structure)
$canvasData = htmlspecialchars_decode($canvasData);

// Check if a record already exists for this medical record
$existing = $db->getRow("SELECT id FROM appliance_images WHERE medical_record_id = ?i", $recordId);

if ($existing) {
    // Update existing record
    $result = $db->query(
        "UPDATE appliance_images SET 
        canvas_data = ?s,
        updated_by = ?i,
        updated_at = NOW()
        WHERE medical_record_id = ?i",
        $canvasData, $_SESSION['user_id'], $recordId
    );
} else {
    // Insert new record
    $result = $db->query(
        "INSERT INTO appliance_images (
            medical_record_id, canvas_data, created_by, updated_by
        ) VALUES (
            ?i, ?s, ?i, ?i
        )",
        $recordId, $canvasData, $_SESSION['user_id'], $_SESSION['user_id']
    );
}

// Handle result for AJAX requests
if ($isAjax) {
    if ($result) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Database error']);
    }
    exit;
}

// Handle result for regular form submissions
if ($result) {
    $successMessage = 'Gambar alat berhasil disimpan.';
    
    // Refresh the appliance image data
    $applianceImage = $db->getRow("SELECT * FROM appliance_images WHERE medical_record_id = ?i", $recordId);
    
    // Handle navigation
    if (isset($_POST['save_and_next'])) {
        // Set flash message before redirecting
        setFlashMessage($successMessage, 'success');
        redirect('edit.php?id=' . $recordId . '&section=' . ($currentSection + 1));
    } elseif (isset($_POST['save_and_complete'])) {
        $db->query("UPDATE medical_records SET is_complete = 1, updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
            $_SESSION['user_id'], $recordId);
        setFlashMessage('Rekam medis berhasil diselesaikan.', 'success');
        redirect('view.php?id=' . $recordId);
    }
} else {
    $errorMessage = 'Terjadi kesalahan saat menyimpan gambar alat.';
}
?> 