<?php
// Section 13 Handler - Foto
if (!defined('BASE_PATH')) {
    define('BASE_PATH', $_SERVER['DOCUMENT_ROOT'] . '/orthobaru');
}

// Check if user is logged in and is a doctor
if (!isLoggedIn() || !isDoctor()) {
    setFlashMessage('Anda tidak memiliki izin untuk melakukan operasi ini.', 'danger');
    redirect('../index.php');
    exit;
}

// Validate record ID
if (!isset($recordId) || empty($recordId)) {
    $errorMessage = 'ID rekam medis tidak valid.';
    return;
}

// Initialize variables
$successCount = 0;
$errorCount = 0;
$uploadErrors = [];

// Define upload directory
$uploadDir = BASE_PATH . '/uploads/patient_photos/' . $recordId . '/';

// Create directory if it doesn't exist
if (!file_exists($uploadDir)) {
    if (!mkdir($uploadDir, 0755, true)) {
        $errorMessage = 'Gagal membuat direktori upload.';
        return;
    }
}

// Process uploaded photos
if (isset($_FILES['photos'])) {
    $photoTypes = ['Ekstra Oral', 'Intra Oral', 'Model'];
    $photoCategories = ['Before', 'After'];
    
    // Loop through all submitted photo types
    foreach ($photoTypes as $type) {
        foreach ($photoCategories as $category) {
            // Check if we have files for this type/category
            if (!isset($_FILES['photos']['name'][$type][$category]) || 
                !is_array($_FILES['photos']['name'][$type][$category])) {
                continue;
            }
            
            $fileCount = count($_FILES['photos']['name'][$type][$category]);
            
            for ($i = 0; $i < $fileCount; $i++) {
                // Skip if no file or error
                if ($_FILES['photos']['error'][$type][$category][$i] === UPLOAD_ERR_NO_FILE) {
                    continue;
                }
                
                // Validate upload
                if ($_FILES['photos']['error'][$type][$category][$i] !== UPLOAD_ERR_OK) {
                    $errorMessages = [
                        UPLOAD_ERR_INI_SIZE => 'Ukuran file terlalu besar (melebihi batas upload.ini).',
                        UPLOAD_ERR_FORM_SIZE => 'Ukuran file terlalu besar (melebihi batas form).',
                        UPLOAD_ERR_PARTIAL => 'File hanya terupload sebagian.',
                        UPLOAD_ERR_NO_TMP_DIR => 'Folder sementara tidak ditemukan.',
                        UPLOAD_ERR_CANT_WRITE => 'Gagal menulis file ke disk.',
                        UPLOAD_ERR_EXTENSION => 'Upload dihentikan oleh ekstensi PHP.'
                    ];
                    
                    $errorMsg = isset($errorMessages[$_FILES['photos']['error'][$type][$category][$i]]) 
                        ? $errorMessages[$_FILES['photos']['error'][$type][$category][$i]] 
                        : 'Terjadi kesalahan saat upload.';
                    
                    $uploadErrors[] = "$type ($category): $errorMsg";
                    $errorCount++;
                    continue;
                }
                
                // Validate file type
                $allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
                $fileType = $_FILES['photos']['type'][$type][$category][$i];
                
                if (!in_array($fileType, $allowedTypes)) {
                    $uploadErrors[] = "$type ($category): Tipe file tidak didukung. Hanya JPEG, PNG, GIF dan WEBP yang diperbolehkan.";
                    $errorCount++;
                    continue;
                }
                
                // Create unique filename
                $extension = pathinfo($_FILES['photos']['name'][$type][$category][$i], PATHINFO_EXTENSION);
                $filename = uniqid("{$type}_{$category}_") . '.' . $extension;
                $filePath = $uploadDir . $filename;
                
                // Move uploaded file
                if (!move_uploaded_file($_FILES['photos']['tmp_name'][$type][$category][$i], $filePath)) {
                    $uploadErrors[] = "$type ($category): Gagal memindahkan file terupload.";
                    $errorCount++;
                    continue;
                }
                
                // Save to database
                $relativePath = '/orthobaru/uploads/patient_photos/' . $recordId . '/' . $filename;
                $result = $db->query(
                    "INSERT INTO patient_photos (medical_record_id, photo_type, photo_category, photo_path, created_by) 
                     VALUES (?i, ?s, ?s, ?s, ?i)",
                    $recordId,
                    $type,
                    $category,
                    $relativePath,
                    $_SESSION['user_id']
                );
                
                if ($result) {
                    $successCount++;
                } else {
                    $uploadErrors[] = "$type ($category): Gagal menyimpan data foto ke database.";
                    $errorCount++;
                    // Delete the uploaded file since we couldn't save to DB
                    @unlink($filePath);
                }
            }
        }
    }
}

// Handle delete requests for existing photos (handled via AJAX in the interface)

// Set messages
if ($successCount > 0) {
    $successMessage = "$successCount foto berhasil diunggah.";
}

if ($errorCount > 0) {
    $errorMessage = "$errorCount foto gagal diunggah." . ($uploadErrors ? ' Detail: ' . implode(', ', $uploadErrors) : '');
}

// Handle form submission actions
if (isset($_POST['save'])) {
    // Just save and stay on this page
    setFlashMessage($successMessage, 'success');
    redirect("edit.php?id={$recordId}&section=13");
    exit;
} elseif (isset($_POST['save_and_next'])) {
    // Save and go to next section
    setFlashMessage($successMessage, 'success');
    $nextSection = 13 + 1;
    if ($nextSection > $totalSections) {
        $nextSection = $totalSections;
    }
    redirect("edit.php?id={$recordId}&section={$nextSection}");
    exit;
} elseif (isset($_POST['save_and_complete'])) {
    // Save and mark as complete
    $db->query("UPDATE medical_records SET is_complete = 1, updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
        $_SESSION['user_id'], $recordId);
    setFlashMessage("Rekam medis berhasil diselesaikan.", 'success');
    redirect("view.php?id={$recordId}");
    exit;
} 