<?php
// Process Section 1 (Data Diri Pasien)
// Only a few fields in this section as most patient data is readonly

// Get and sanitize form data
$examinationDate = $_POST['examination_date'] ?? '';
$medicalRecordNumber = $_POST['medical_record_number'] ?? '';

// Convert date format from dd-mm-yyyy to yyyy-mm-dd for database
if (!empty($examinationDate)) {
    $dateObj = DateTime::createFromFormat('d-m-Y', $examinationDate);
    if ($dateObj) {
        $examinationDate = $dateObj->format('Y-m-d');
    }
}

// Sanitize inputs
$examinationDate = sanitize($examinationDate);
$medicalRecordNumber = sanitize($medicalRecordNumber);

// Update the medical record
$result = $db->query(
    "UPDATE medical_records SET 
    examination_date = ?s,
    medical_record_number = ?s,
    updated_by = ?i,
    updated_at = NOW()
    WHERE id = ?i",
    $examinationDate, $medicalRecordNumber, $_SESSION['user_id'], $recordId
);

// Handle result
if ($result) {
    $successMessage = 'Data diri pasien berhasil disimpan.';
    
    // Refresh the record data
    $record = $db->getRow("SELECT * FROM medical_records WHERE id = ?i", $recordId);
    
    // Handle navigation
    if (isset($_POST['save_and_next'])) {
        // Set flash message before redirecting
        setFlashMessage($successMessage, 'success');
        redirect('edit.php?id=' . $recordId . '&section=' . ($currentSection + 1));
    } elseif (isset($_POST['save_and_complete'])) {
        $db->query("UPDATE medical_records SET is_complete = 1, updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
            $_SESSION['user_id'], $recordId);
        setFlashMessage('Rekam medis berhasil diselesaikan.', 'success');
        redirect('view.php?id=' . $recordId);
    }
} else {
    $errorMessage = 'Terjadi kesalahan saat menyimpan data diri pasien.';
}
?> 