<?php
// Process Section 2 (Anamnesis)

// Get and sanitize form data
$chiefComplaint = $_POST['chief_complaint'] ?? '';
$medicalHistory = $_POST['medical_history'] ?? '';
$badHabitsArray = $_POST['bad_habits'] ?? [];
$badHabitsOtherText = $_POST['bad_habits_other'] ?? '';

// Process bad habits
$formattedBadHabits = '';
if (!empty($badHabitsArray) && is_array($badHabitsArray)) {
    // Process "Lain-lain" specially
    $lainLainIndex = array_search('Lain-lain', $badHabitsArray);
    if ($lainLainIndex !== false && !empty($badHabitsOtherText)) {
        // Remove "Lain-lain" from the array and add it with details
        unset($badHabitsArray[$lainLainIndex]);
        $badHabitsArray[] = 'Lain-lain: ' . $badHabitsOtherText;
    }
    $formattedBadHabits = implode(', ', $badHabitsArray);
}

// Sanitize inputs
$chiefComplaint = sanitize($chiefComplaint);
$medicalHistory = sanitize($medicalHistory);
$formattedBadHabits = sanitize($formattedBadHabits);

// Update the medical record
$result = $db->query(
    "UPDATE medical_records SET 
    chief_complaint = ?s,
    medical_history = ?s,
    bad_habits = ?s,
    updated_by = ?i,
    updated_at = NOW()
    WHERE id = ?i",
    $chiefComplaint, $medicalHistory, $formattedBadHabits, $_SESSION['user_id'], $recordId
);

// Handle result
if ($result) {
    $successMessage = 'Anamnesis berhasil disimpan.';
    
    // Refresh the record data
    $record = $db->getRow("SELECT * FROM medical_records WHERE id = ?i", $recordId);
    
    // Refresh the bad habits data
    $badHabits = [];
    $badHabitsOther = '';
    if (!empty($record['bad_habits'])) {
        $badHabitsArray = explode(', ', $record['bad_habits']);
        foreach ($badHabitsArray as $habit) {
            if (strpos($habit, 'Lain-lain: ') === 0) {
                $badHabitsOther = substr($habit, strlen('Lain-lain: '));
                $badHabits[] = 'Lain-lain';
            } else {
                $badHabits[] = $habit;
            }
        }
    }
    
    // Handle navigation
    if (isset($_POST['save_and_next'])) {
        // Set flash message before redirecting
        setFlashMessage($successMessage, 'success');
        redirect('edit.php?id=' . $recordId . '&section=' . ($currentSection + 1));
    } elseif (isset($_POST['save_and_complete'])) {
        $db->query("UPDATE medical_records SET is_complete = 1, updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
            $_SESSION['user_id'], $recordId);
        setFlashMessage('Rekam medis berhasil diselesaikan.', 'success');
        redirect('view.php?id=' . $recordId);
    }
} else {
    $errorMessage = 'Terjadi kesalahan saat menyimpan anamnesis.';
}
?>