<?php
// Process Section 3 (Pemeriksaan Ekstra Oral)

// Get form data
// Vertikal
$faceShape = $_POST['face_shape'] ?? '';
$verticalFaceBalance = $_POST['vertical_face_balance'] ?? '';
$verticalFaceBalanceValue = $_POST['vertical_face_balance_value'] ?? '';

// Transversal
$transversalFaceBalance = $_POST['transversal_face_balance'] ?? '';
$transversalFaceBalanceValue = $_POST['transversal_face_balance_value'] ?? '';
$chin = $_POST['chin'] ?? '';
$upperDentalMidline = $_POST['upper_dental_midline'] ?? '';
$upperDentalMidlineValue = $_POST['upper_dental_midline_value'] ?? '';
$lowerDentalMidline = $_POST['lower_dental_midline'] ?? '';
$lowerDentalMidlineValue = $_POST['lower_dental_midline_value'] ?? '';

// Bibir
$upperLipTonus = $_POST['upper_lip_tonus'] ?? '';
$lowerLipTonus = $_POST['lower_lip_tonus'] ?? '';
$lipCompetence = $_POST['lip_competence'] ?? '';
$elineProfile = $_POST['eline_profile'] ?? '';
$upperLipToEline = $_POST['upper_lip_to_eline'] ?? '';
$lowerLipToEline = $_POST['lower_lip_to_eline'] ?? '';

// Sanitize inputs
$faceShape = sanitize($faceShape);
$verticalFaceBalance = sanitize($verticalFaceBalance);
$verticalFaceBalanceValue = sanitize($verticalFaceBalanceValue);
$transversalFaceBalance = sanitize($transversalFaceBalance);
$transversalFaceBalanceValue = sanitize($transversalFaceBalanceValue);
$chin = sanitize($chin);
$upperDentalMidline = sanitize($upperDentalMidline);
$upperDentalMidlineValue = sanitize($upperDentalMidlineValue);
$lowerDentalMidline = sanitize($lowerDentalMidline);
$lowerDentalMidlineValue = sanitize($lowerDentalMidlineValue);
$upperLipTonus = sanitize($upperLipTonus);
$lowerLipTonus = sanitize($lowerLipTonus);
$lipCompetence = sanitize($lipCompetence);
$elineProfile = sanitize($elineProfile);
$upperLipToEline = sanitize($upperLipToEline);
$lowerLipToEline = sanitize($lowerLipToEline);

// Clear values that shouldn't be set
if ($verticalFaceBalance != 'Tidak Seimbang') {
    $verticalFaceBalanceValue = null;
}
if ($transversalFaceBalance != 'Tidak Seimbang') {
    $transversalFaceBalanceValue = null;
}
if ($upperDentalMidline == 'Normal') {
    $upperDentalMidlineValue = null;
}
if ($lowerDentalMidline == 'Normal') {
    $lowerDentalMidlineValue = null;
}

// If extra oral examination record already exists, update it
$extraOral = $db->getRow("SELECT * FROM extra_oral_examinations WHERE medical_record_id = ?i", $recordId);

if ($extraOral) {
    $result = $db->query(
        "UPDATE extra_oral_examinations SET 
        face_shape = ?s,
        vertical_face_balance = ?s,
        vertical_face_balance_value = ?s,
        transversal_face_balance = ?s,
        transversal_face_balance_value = ?s,
        chin = ?s,
        upper_dental_midline = ?s,
        upper_dental_midline_value = ?s,
        lower_dental_midline = ?s,
        lower_dental_midline_value = ?s,
        upper_lip_tonus = ?s,
        lower_lip_tonus = ?s,
        lip_competence = ?s,
        eline_profile = ?s,
        upper_lip_to_eline = ?s,
        lower_lip_to_eline = ?s,
        updated_by = ?i,
        updated_at = NOW()
        WHERE id = ?i",
        $faceShape, $verticalFaceBalance, $verticalFaceBalanceValue,
        $transversalFaceBalance, $transversalFaceBalanceValue, $chin,
        $upperDentalMidline, $upperDentalMidlineValue,
        $lowerDentalMidline, $lowerDentalMidlineValue,
        $upperLipTonus, $lowerLipTonus, $lipCompetence, $elineProfile,
        $upperLipToEline, $lowerLipToEline,
        $_SESSION['user_id'], $extraOral['id']
    );
} else {
    // Create a new record
    $result = $db->query(
        "INSERT INTO extra_oral_examinations (
            medical_record_id, face_shape, vertical_face_balance, vertical_face_balance_value,
            transversal_face_balance, transversal_face_balance_value, chin,
            upper_dental_midline, upper_dental_midline_value,
            lower_dental_midline, lower_dental_midline_value,
            upper_lip_tonus, lower_lip_tonus, lip_competence, eline_profile,
            upper_lip_to_eline, lower_lip_to_eline,
            created_by, created_at
        ) VALUES (
            ?i, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?i, NOW()
        )",
        $recordId, $faceShape, $verticalFaceBalance, $verticalFaceBalanceValue,
        $transversalFaceBalance, $transversalFaceBalanceValue, $chin,
        $upperDentalMidline, $upperDentalMidlineValue,
        $lowerDentalMidline, $lowerDentalMidlineValue,
        $upperLipTonus, $lowerLipTonus, $lipCompetence, $elineProfile,
        $upperLipToEline, $lowerLipToEline,
        $_SESSION['user_id']
    );
}

// Handle result
if ($result) {
    // Update the medical record timestamp
    $db->query("UPDATE medical_records SET updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
        $_SESSION['user_id'], $recordId);
    
    $successMessage = 'Data pemeriksaan ekstra oral berhasil disimpan.';
    
    // Refresh the extra oral examination data
    $extraOral = $db->getRow("SELECT * FROM extra_oral_examinations WHERE medical_record_id = ?i", $recordId);
    
    // Handle navigation
    if (isset($_POST['save_and_next'])) {
        // Set flash message before redirecting
        setFlashMessage($successMessage, 'success');
        redirect('edit.php?id=' . $recordId . '&section=' . ($currentSection + 1));
    } elseif (isset($_POST['save_and_complete'])) {
        $db->query("UPDATE medical_records SET is_complete = 1, updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
            $_SESSION['user_id'], $recordId);
        setFlashMessage('Rekam medis berhasil diselesaikan.', 'success');
        redirect('view.php?id=' . $recordId);
    }
} else {
    $errorMessage = 'Terjadi kesalahan saat menyimpan data pemeriksaan ekstra oral.';
}
?>