<?php
// Process Section 4 (Pemeriksaan Intra Oral)

// Get form data
$oralHygiene = $_POST['oral_hygiene'] ?? '';
$frenulumLabiiSuperior = $_POST['frenulum_labii_superior'] ?? '';
$frenulumLabiiInferior = $_POST['frenulum_labii_inferior'] ?? '';
$tongue = $_POST['tongue'] ?? '';
$palatum = $_POST['palatum'] ?? '';
$adenoid = $_POST['adenoid'] ?? '';
$crowding = $_POST['crowding'] ?? '';
$jawRelation = $_POST['jaw_relation'] ?? '';
$diastema = $_POST['diastema'] ?? '';
$crossbite = $_POST['crossbite'] ?? '';
$toothShapeAbnormality = $_POST['tooth_shape_abnormality'] ?? '';
$toothShapeAbnormalityRegion = $_POST['tooth_shape_abnormality_region'] ?? '';
$toothNumberAbnormality = $_POST['tooth_number_abnormality'] ?? '';
$toothNumberAbnormalityRegion = $_POST['tooth_number_abnormality_region'] ?? '';

// Sanitize inputs
$oralHygiene = sanitize($oralHygiene);
$frenulumLabiiSuperior = sanitize($frenulumLabiiSuperior);
$frenulumLabiiInferior = sanitize($frenulumLabiiInferior);
$tongue = sanitize($tongue);
$palatum = sanitize($palatum);
$adenoid = sanitize($adenoid);
$crowding = sanitize($crowding);
$jawRelation = sanitize($jawRelation);
$diastema = sanitize($diastema);
$crossbite = sanitize($crossbite);
$toothShapeAbnormality = sanitize($toothShapeAbnormality);
$toothShapeAbnormalityRegion = sanitize($toothShapeAbnormalityRegion);
$toothNumberAbnormality = sanitize($toothNumberAbnormality);
$toothNumberAbnormalityRegion = sanitize($toothNumberAbnormalityRegion);

// Clear region values for normal conditions
if ($toothShapeAbnormality == 'Tidak') {
    $toothShapeAbnormalityRegion = '';
}

if ($toothNumberAbnormality == 'Tidak') {
    $toothNumberAbnormalityRegion = '';
}

// If intra oral examination record already exists, update it
$intraOral = $db->getRow("SELECT * FROM intra_oral_examinations WHERE medical_record_id = ?i", $recordId);

if ($intraOral) {
    $result = $db->query(
        "UPDATE intra_oral_examinations SET 
        oral_hygiene = ?s,
        frenulum_labii_superior = ?s,
        frenulum_labii_inferior = ?s,
        tongue = ?s,
        palatum = ?s,
        adenoid = ?s,
        crowding = ?s,
        jaw_relation = ?s,
        diastema = ?s,
        crossbite = ?s,
        tooth_shape_abnormality = ?s,
        tooth_shape_abnormality_region = ?s,
        tooth_number_abnormality = ?s,
        tooth_number_abnormality_region = ?s,
        updated_by = ?i,
        updated_at = NOW()
        WHERE id = ?i",
        $oralHygiene, $frenulumLabiiSuperior, $frenulumLabiiInferior,
        $tongue, $palatum, $adenoid, $crowding, $jawRelation,
        $diastema, $crossbite,
        $toothShapeAbnormality, $toothShapeAbnormalityRegion,
        $toothNumberAbnormality, $toothNumberAbnormalityRegion,
        $_SESSION['user_id'], $intraOral['id']
    );
} else {
    // Create a new record
    $result = $db->query(
        "INSERT INTO intra_oral_examinations (
            medical_record_id, oral_hygiene, frenulum_labii_superior, frenulum_labii_inferior,
            tongue, palatum, adenoid, crowding, jaw_relation,
            diastema, crossbite,
            tooth_shape_abnormality, tooth_shape_abnormality_region,
            tooth_number_abnormality, tooth_number_abnormality_region,
            created_by, created_at
        ) VALUES (
            ?i, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?i, NOW()
        )",
        $recordId, $oralHygiene, $frenulumLabiiSuperior, $frenulumLabiiInferior,
        $tongue, $palatum, $adenoid, $crowding, $jawRelation,
        $diastema, $crossbite,
        $toothShapeAbnormality, $toothShapeAbnormalityRegion,
        $toothNumberAbnormality, $toothNumberAbnormalityRegion,
        $_SESSION['user_id']
    );
}

// Handle result
if ($result) {
    // Update the medical record timestamp
    $db->query("UPDATE medical_records SET updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
        $_SESSION['user_id'], $recordId);
    
    $successMessage = 'Data pemeriksaan intra oral berhasil disimpan.';
    
    // Refresh the intra oral examination data
    $intraOral = $db->getRow("SELECT * FROM intra_oral_examinations WHERE medical_record_id = ?i", $recordId);
    
    // Handle navigation
    if (isset($_POST['save_and_next'])) {
        // Set flash message before redirecting
        setFlashMessage($successMessage, 'success');
        redirect('edit.php?id=' . $recordId . '&section=' . ($currentSection + 1));
    } elseif (isset($_POST['save_and_complete'])) {
        $db->query("UPDATE medical_records SET is_complete = 1, updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
            $_SESSION['user_id'], $recordId);
        setFlashMessage('Rekam medis berhasil diselesaikan.', 'success');
        redirect('view.php?id=' . $recordId);
    }
} else {
    $errorMessage = 'Terjadi kesalahan saat menyimpan data pemeriksaan intra oral.';
}
?>