<?php
// Process Section 5 (Relasi Gigi Geligi)
$overjet = $_POST['overjet'] ?? '';
$overbite = $_POST['overbite'] ?? '';
$curveSpee = $_POST['curve_spee'] ?? '';
$incisorRelation = $_POST['incisor_relation'] ?? '';

// Molar relation - Right
$rightMolarSagittal = $_POST['right_molar_sagittal'] ?? '';
$rightMolarTransversal = $_POST['right_molar_transversal'] ?? '';
$rightMolarVertical = $_POST['right_molar_vertical'] ?? '';

// Molar relation - Left
$leftMolarSagittal = $_POST['left_molar_sagittal'] ?? '';
$leftMolarTransversal = $_POST['left_molar_transversal'] ?? '';
$leftMolarVertical = $_POST['left_molar_vertical'] ?? '';

// Canine relation - Right
$rightCanineSagittal = $_POST['right_canine_sagittal'] ?? '';
$rightCanineTransversal = $_POST['right_canine_transversal'] ?? '';
$rightCanineVertical = $_POST['right_canine_vertical'] ?? '';

// Canine relation - Left
$leftCanineSagittal = $_POST['left_canine_sagittal'] ?? '';
$leftCanineTransversal = $_POST['left_canine_transversal'] ?? '';
$leftCanineVertical = $_POST['left_canine_vertical'] ?? '';

// Sanitize inputs
$overjet = sanitize($overjet);
$overbite = sanitize($overbite);
$curveSpee = sanitize($curveSpee);
$incisorRelation = sanitize($incisorRelation);
$rightMolarSagittal = sanitize($rightMolarSagittal);
$rightMolarTransversal = sanitize($rightMolarTransversal);
$rightMolarVertical = sanitize($rightMolarVertical);
$leftMolarSagittal = sanitize($leftMolarSagittal);
$leftMolarTransversal = sanitize($leftMolarTransversal);
$leftMolarVertical = sanitize($leftMolarVertical);
$rightCanineSagittal = sanitize($rightCanineSagittal);
$rightCanineTransversal = sanitize($rightCanineTransversal);
$rightCanineVertical = sanitize($rightCanineVertical);
$leftCanineSagittal = sanitize($leftCanineSagittal);
$leftCanineTransversal = sanitize($leftCanineTransversal);
$leftCanineVertical = sanitize($leftCanineVertical);

// If tooth relation examination record already exists, update it
    $toothRelation = $db->getRow("SELECT * FROM tooth_relation_examinations WHERE medical_record_id = ?i", $recordId);

if ($toothRelation) {
    $result = $db->query(
        "UPDATE tooth_relation_examinations SET 
        overjet = ?s,
        overbite = ?s,
        curve_spee = ?s,
        incisor_relation = ?s,
        right_molar_sagittal = ?s,
        right_molar_transversal = ?s,
        right_molar_vertical = ?s,
        left_molar_sagittal = ?s,
        left_molar_transversal = ?s,
        left_molar_vertical = ?s,
        right_canine_sagittal = ?s,
        right_canine_transversal = ?s,
        right_canine_vertical = ?s,
        left_canine_sagittal = ?s,
        left_canine_transversal = ?s,
        left_canine_vertical = ?s,
        updated_by = ?i,
        updated_at = NOW()
        WHERE id = ?i",
        $overjet, $overbite, $curveSpee, $incisorRelation,
        $rightMolarSagittal, $rightMolarTransversal, $rightMolarVertical,
        $leftMolarSagittal, $leftMolarTransversal, $leftMolarVertical,
        $rightCanineSagittal, $rightCanineTransversal, $rightCanineVertical,
        $leftCanineSagittal, $leftCanineTransversal, $leftCanineVertical,
        $_SESSION['user_id'], $toothRelation['id']
    );
} else {
    // Otherwise, create a new record
    $result = $db->query(
        "INSERT INTO tooth_relation_examinations (
            medical_record_id, overjet, overbite, curve_spee, incisor_relation,
            right_molar_sagittal, right_molar_transversal, right_molar_vertical,
            left_molar_sagittal, left_molar_transversal, left_molar_vertical,
            right_canine_sagittal, right_canine_transversal, right_canine_vertical,
            left_canine_sagittal, left_canine_transversal, left_canine_vertical,
            created_by, created_at
        ) VALUES (
            ?i, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?i, NOW()
        )",
        $recordId, $overjet, $overbite, $curveSpee, $incisorRelation,
        $rightMolarSagittal, $rightMolarTransversal, $rightMolarVertical,
        $leftMolarSagittal, $leftMolarTransversal, $leftMolarVertical,
        $rightCanineSagittal, $rightCanineTransversal, $rightCanineVertical,
        $leftCanineSagittal, $leftCanineTransversal, $leftCanineVertical,
        $_SESSION['user_id']
    );
}

// Handle result
if ($result) {
    // Update the medical record timestamp
    $db->query("UPDATE medical_records SET updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
        $_SESSION['user_id'], $recordId);
    
    $successMessage = 'Data relasi gigi geligi berhasil disimpan.';
    
    // Refresh the tooth relation data
    $toothRelation = $db->getRow("SELECT * FROM tooth_relation_examinations WHERE medical_record_id = ?i", $recordId);
    
    // Handle navigation
    if (isset($_POST['save_and_next'])) {
        // Set flash message before redirecting
        setFlashMessage($successMessage, 'success');
        redirect('edit.php?id=' . $recordId . '&section=' . ($currentSection + 1));
    } elseif (isset($_POST['save_and_complete'])) {
        $db->query("UPDATE medical_records SET is_complete = 1, updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
            $_SESSION['user_id'], $recordId);
        setFlashMessage('Rekam medis berhasil diselesaikan.', 'success');
        redirect('view.php?id=' . $recordId);
    }
} else {
    $errorMessage = 'Terjadi kesalahan saat menyimpan data relasi gigi geligi.';
}
?>