<?php
/**
 * Handler for Section 6: Functional Analysis (TMJ and Occlusion)
 */

// Initialize error flag
$hasError = false;

// Check if form was submitted
if (isPostRequest()) {
    // Sanitize and validate inputs
    
    // TMJ - Palpation
    $palpation = sanitize($_POST['palpation'] ?? '');
    $palpationLocation = ($palpation == 'Sakit') ? sanitize($_POST['palpation_location'] ?? '') : '';
    
    // TMJ - Clicking Sound
    $clickingSound = sanitize($_POST['clicking_sound'] ?? '');
    $clickingLocation = ($clickingSound == 'Ada') ? sanitize($_POST['clicking_location'] ?? '') : '';
    $clickingTiming = ($clickingSound == 'Ada') ? sanitize($_POST['clicking_timing'] ?? '') : '';
    
    // Occlusion
    $interocclusalClearance = isset($_POST['interocclusal_clearance']) ? 
        filter_var($_POST['interocclusal_clearance'], FILTER_VALIDATE_FLOAT) : null;
    $centricRelation = sanitize($_POST['centric_relation'] ?? '');
    
    // Vertical Occlusal Interference
    $verticalOcclusalInterference = sanitize($_POST['vertical_occlusal_interference'] ?? '');
    $verticalOcclusalInterferenceRegion = ($verticalOcclusalInterference == 'Ada') ? 
        sanitize($_POST['vertical_occlusal_interference_region'] ?? '') : '';
    
    // Horizontal Occlusal Interference
    $horizontalOcclusalInterference = sanitize($_POST['horizontal_occlusal_interference'] ?? '');
    $horizontalOcclusalInterferenceRegion = ($horizontalOcclusalInterference == 'Ada') ? 
        sanitize($_POST['horizontal_occlusal_interference_region'] ?? '') : '';
    
    // Validation
    if (empty($palpation)) {
        // Fields are now optional, no validation needed
    } elseif ($palpation == 'Sakit' && empty($palpationLocation)) {
        // Optional field
    } elseif (empty($clickingSound)) {
        // Optional field
    } elseif ($clickingSound == 'Ada' && (empty($clickingLocation) || empty($clickingTiming))) {
        // Optional field
    } elseif ($interocclusalClearance === false || $interocclusalClearance === null) {
        // Optional field
    } elseif (empty($centricRelation)) {
        // Optional field
    } elseif (empty($verticalOcclusalInterference)) {
        // Optional field
    } elseif ($verticalOcclusalInterference == 'Ada' && empty($verticalOcclusalInterferenceRegion)) {
        // Optional field
    } elseif (empty($horizontalOcclusalInterference)) {
        // Optional field
    } elseif ($horizontalOcclusalInterference == 'Ada' && empty($horizontalOcclusalInterferenceRegion)) {
        // Optional field
    }
    
    // All fields are optional, so we'll always proceed to save
    $hasError = false;
    
    // If no validation errors, save the data
    if (!$hasError) {
        // Check if functional examination record already exists
        $existingFunctionalExam = $db->getRow("SELECT id FROM functional_examinations WHERE medical_record_id = ?i", $recordId);
        
        // Prepare data for insert/update
        $functionalExamData = [
            'medical_record_id' => $recordId,
            'palpation' => $palpation,
            'palpation_location' => $palpationLocation,
            'clicking_sound' => $clickingSound,
            'clicking_location' => $clickingLocation,
            'clicking_timing' => $clickingTiming,
            'interocclusal_clearance' => $interocclusalClearance,
            'centric_relation' => $centricRelation,
            'vertical_occlusal_interference' => $verticalOcclusalInterference,
            'vertical_occlusal_interference_region' => $verticalOcclusalInterferenceRegion,
            'horizontal_occlusal_interference' => $horizontalOcclusalInterference,
            'horizontal_occlusal_interference_region' => $horizontalOcclusalInterferenceRegion,
            'updated_at' => date('Y-m-d H:i:s'),
            'updated_by' => $_SESSION['user_id']
        ];
        
        if ($existingFunctionalExam) {
            // Update existing record
            $result = $db->query("UPDATE functional_examinations SET ?u WHERE id = ?i", 
                $functionalExamData, $existingFunctionalExam['id']);
        } else {
            // Create new record
            $functionalExamData['created_at'] = date('Y-m-d H:i:s');
            $functionalExamData['created_by'] = $_SESSION['user_id'];
            
            $result = $db->query("INSERT INTO functional_examinations SET ?u", $functionalExamData);
        }
        
        // Update the parent medical record's updated_at and updated_by
        $db->query("UPDATE medical_records SET updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
            $_SESSION['user_id'], $recordId);
        
        if ($result) {
            // Success message
            $successMessage = 'Data Analisis Fungsional berhasil disimpan.';
            
            // Handle save and continue
            if (isset($_POST['save_and_next'])) {
                setFlashMessage('Data Analisis Fungsional berhasil disimpan.', 'success');
                redirect("edit.php?id={$recordId}&section=" . ($currentSection + 1));
            }
        } else {
            $errorMessage = 'Terjadi kesalahan saat menyimpan data. Silakan coba lagi.';
        }
    }
} 