<?php
/**
 * Handler for Section 8: Analisis Model (Model Analysis)
 */

// Initialize error flag
$hasError = false;

// Check if form was submitted
if (isPostRequest()) {
    // Prepare data for model analysis
    $modelData = [
        'medical_record_id' => $recordId,
        'maxillary_arch_shape' => sanitize($_POST['upper_arch_shape'] ?? ''),
        'mandibular_arch_shape' => sanitize($_POST['lower_arch_shape'] ?? ''),
        'updated_at' => date('Y-m-d H:i:s'),
        'updated_by' => $_SESSION['user_id']
    ];
    
    // Handle marked teeth data (make sure it's valid JSON)
    if (isset($_POST['marked_teeth']) && !empty($_POST['marked_teeth'])) {
        // Validate that it's proper JSON
        $markedTeethData = $_POST['marked_teeth'];
        $markedTeeth = json_decode($markedTeethData, true);
        
        if (json_last_error() === JSON_ERROR_NONE) {
            // It's valid JSON, store as is
            $modelData['marked_teeth'] = $markedTeethData;
            
            // Log for debugging
            error_log("Valid marked teeth data saved: " . $markedTeethData);
        } else {
            // Not valid JSON, set to empty object
            $modelData['marked_teeth'] = '{}';
            error_log("Invalid marked teeth data received: " . $markedTeethData);
        }
    } else {
        // Empty or not set, use empty object
        $modelData['marked_teeth'] = '{}';
        error_log("No marked teeth data received");
    }
    
    // Process tooth data (sanitize and encode as JSON)
    if (isset($_POST['tooth_data']) && is_array($_POST['tooth_data'])) {
        $modelData['tooth_data'] = json_encode($_POST['tooth_data']);
    } else {
        $modelData['tooth_data'] = null;
    }
    
    // Check if record already exists
    $existingModelAnalysis = $db->getRow("SELECT id FROM model_analyses WHERE medical_record_id = ?i", $recordId);
    
    if ($existingModelAnalysis) {
        // Update existing record
        $result = $db->query("UPDATE model_analyses SET ?u WHERE id = ?i", 
            $modelData, $existingModelAnalysis['id']);
            
        if ($result) {
            error_log("Updated model analysis record: " . $existingModelAnalysis['id']);
        }
    } else {
        // Create new record
        $modelData['created_at'] = date('Y-m-d H:i:s');
        $modelData['created_by'] = $_SESSION['user_id'];
        
        $result = $db->query("INSERT INTO model_analyses SET ?u", $modelData);
        
        if ($result) {
            error_log("Created new model analysis record");
        }
    }
    
    if ($result) {
        // Update the parent medical record's updated_at and updated_by
        $db->query("UPDATE medical_records SET updated_at = NOW(), updated_by = ?i WHERE id = ?i", 
            $_SESSION['user_id'], $recordId);
        
        // Success message
        $successMessage = 'Data Analisis Model berhasil disimpan.';
        
        // Handle save and continue
        if (isset($_POST['save_and_next'])) {
            setFlashMessage('Data Analisis Model berhasil disimpan.', 'success');
            redirect("edit.php?id={$recordId}&section=" . ($currentSection + 1));
        }
    } else {
        $errorMessage = 'Terjadi kesalahan saat menyimpan data Analisis Model.';
        $hasError = true;
    }
} 