<?php
// Include initialization file
require_once '../init.php';

// Check if user is logged in
if (!isLoggedIn()) {
    redirect('../auth/login.php');
}

// Get all medical records
$medicalRecords = $db->getAll("
    SELECT 
        mr.*,
        p.name AS patient_name,
        p.medical_record_number,
        u.name AS doctor_name,
        TIMESTAMPDIFF(YEAR, p.birth_date, CURDATE()) as age,
        p.gender
    FROM 
        medical_records mr
    JOIN 
        patients p ON mr.patient_id = p.id
    LEFT JOIN 
        users u ON mr.doctor_id = u.id
    ORDER BY 
        mr.examination_date DESC
");
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title>Rekam Medis &mdash; Sistem Rekam Medis Ortodontik</title>

    <!-- General CSS Files -->
    <link rel="stylesheet" href="../assets/modules/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/modules/fontawesome/css/all.min.css">

    <!-- CSS Libraries -->
    <link rel="stylesheet" href="../assets/modules/datatables/datatables.min.css">
    <link rel="stylesheet" href="../assets/modules/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="../assets/modules/datatables/Select-1.2.4/css/select.bootstrap4.min.css">

    <!-- Template CSS -->
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/components.css">
</head>

<body>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <!-- Header -->
            <?php include '../layouts/header.php'; ?>

            <!-- Sidebar -->
            <?php include '../layouts/sidebar.php'; ?>

            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="section-header">
                        <h1>Data Rekam Medis</h1>
                        <div class="section-header-breadcrumb">
                            <div class="breadcrumb-item active"><a href="../index.php">Dashboard</a></div>
                            <div class="breadcrumb-item">Rekam Medis</div>
                        </div>
                    </div>

                    <div class="section-body">
                        <h2 class="section-title">Daftar Rekam Medis</h2>
                        <p class="section-lead">
                            Daftar seluruh rekam medis pasien.
                        </p>

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>Data Rekam Medis</h4>
                                        <?php if (isDoctor()): ?>
                                        <div class="card-header-action">
                                            <a href="../patients/index.php" class="btn btn-primary">
                                                <i class="fas fa-plus"></i> Buat Rekam Medis Baru
                                            </a>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="card-body">
                                        <?php if (!empty(getFlashMessage())): ?>
                                        <div
                                            class="alert alert-<?php echo getFlashMessageType(); ?> alert-dismissible show fade">
                                            <div class="alert-body">
                                                <button class="close" data-dismiss="alert">
                                                    <span>×</span>
                                                </button>
                                                <?php echo getFlashMessage(); ?>
                                            </div>
                                        </div>
                                        <?php endif; ?>

                                        <div class="table-responsive">
                                            <table class="table table-striped" id="medical-records-table">
                                                <thead>
                                                    <tr>
                                                        <th>No</th>
                                                        <th>Tanggal Pemeriksaan</th>
                                                        <th>No Rekam Medis</th>
                                                        <th>Nama Pasien</th>
                                                        <th>Usia</th>
                                                        <th>Jenis Kelamin</th>
                                                        <th>Dokter</th>
                                                        <th>Status</th>
                                                        <th>Aksi</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $no = 1; foreach ($medicalRecords as $record): ?>
                                                    <tr>
                                                        <td><?php echo $no++; ?></td>
                                                        <td><?php echo formatDate($record['examination_date']); ?></td>
                                                        <td><?php echo $record['medical_record_number']; ?></td>
                                                        <td><?php echo $record['patient_name']; ?></td>
                                                        <td><?php echo $record['age']; ?> tahun</td>
                                                        <td><?php echo $record['gender']; ?></td>
                                                        <td><?php echo $record['doctor_name']; ?></td>
                                                        <td>
                                                            <?php if ($record['is_complete'] == 1): ?>
                                                            <span class="badge badge-success">Selesai</span>
                                                            <?php else: ?>
                                                            <span class="badge badge-warning">Dalam Proses</span>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td>
                                                            <a href="view.php?id=<?php echo $record['id']; ?>"
                                                                class="btn btn-info btn-sm">
                                                                <i class="fas fa-eye"></i> Lihat
                                                            </a>
                                                            <?php if (isDoctor() && $record['is_complete'] == 0): ?>
                                                            <a href="edit.php?id=<?php echo $record['id']; ?>"
                                                                class="btn btn-primary btn-sm">
                                                                <i class="fas fa-edit"></i> Edit
                                                            </a>
                                                            <?php endif; ?>
                                                            <?php if (isAdmin()): ?>
                                                            <a href="#" class="btn btn-danger btn-sm btn-delete"
                                                                data-id="<?php echo $record['id']; ?>">
                                                                <i class="fas fa-trash"></i> Hapus
                                                            </a>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>

            <!-- Footer -->
            <?php include '../layouts/footer.php'; ?>

            <!-- Delete Confirmation Modal -->
            <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
                aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteModalLabel">Konfirmasi Hapus</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <p>Apakah Anda yakin ingin menghapus rekam medis ini?</p>
                            <p>Tindakan ini tidak dapat dibatalkan.</p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                            <a href="#" id="btn-confirm-delete" class="btn btn-danger">Hapus</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- General JS Scripts -->
    <script src="../assets/modules/jquery.min.js"></script>
    <script src="../assets/modules/popper.js"></script>
    <script src="../assets/modules/tooltip.js"></script>
    <script src="../assets/modules/bootstrap/js/bootstrap.min.js"></script>
    <script src="../assets/modules/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="../assets/modules/moment.min.js"></script>
    <script src="../assets/js/stisla.js"></script>

    <!-- JS Libraies -->
    <script src="../assets/modules/datatables/datatables.min.js"></script>
    <script src="../assets/modules/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js"></script>
    <script src="../assets/modules/datatables/Select-1.2.4/js/dataTables.select.min.js"></script>

    <!-- Page Specific JS File -->
    <script>
    $(document).ready(function() {
        // Initialize DataTable
        $('#medical-records-table').DataTable({
            "language": {
                "url": "../assets/js/dataTables.indonesian.json"
            }
        });

        // Setup delete confirmation
        $('.btn-delete').on('click', function(e) {
            e.preventDefault();
            const id = $(this).data('id');
            $('#btn-confirm-delete').attr('href', 'delete.php?id=' + id);
            $('#deleteModal').modal('show');
        });
    });
    </script>

    <!-- Template JS File -->
    <script src="../assets/js/scripts.js"></script>
    <script src="../assets/js/custom.js"></script>
</body>

</html>