<!-- First Section: Data Diri Pasien -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4>Data Diri Pasien</h4>
            </div>
            <div class="card-body">
                <?php if ($isViewMode): ?>
                <!-- View mode - display data in a more compact, readable format -->
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-sm">
                            <tr>
                                <td width="40%" class="font-weight-bold">Tanggal Pemeriksaan</td>
                                <td><?php echo viewModeDateDisplay($record['examination_date']); ?></td>
                            </tr>
                            <tr>
                                <td class="font-weight-bold">Tanggal Lahir</td>
                                <td><?php echo viewModeDateDisplay($record['birth_date']); ?></td>
                            </tr>
                            <tr>
                                <td class="font-weight-bold">Jenis Kelamin</td>
                                <td><?php echo viewModeDisplay($record['gender']); ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-sm">
                            <tr>
                                <td width="40%" class="font-weight-bold">Nomor Rekam Medis</td>
                                <td><?php echo viewModeDisplay($record['medical_record_number']); ?></td>
                            </tr>
                            <tr>
                                <td class="font-weight-bold">Usia</td>
                                <td><?php echo viewModeDisplay($age . ' tahun'); ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
                <?php else: ?>
                <!-- Edit mode - display form inputs -->
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Tanggal Pemeriksaan <?php echo getRequiredFieldMarker(); ?></label>
                            <input type="text" class="form-control datepicker" name="examination_date"
                                value="<?php echo !empty($record['examination_date']) ? date('d-m-Y', strtotime($record['examination_date'])) : date('d-m-Y'); ?>"
                                required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Nomor Rekam Medis <?php echo getRequiredFieldMarker(); ?></label>
                            <input type="text" class="form-control" name="medical_record_number"
                                value="<?php echo $record['medical_record_number']; ?>" required readonly>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Tanggal Lahir <?php echo getRequiredFieldMarker(); ?></label>
                            <input type="text" class="form-control"
                                value="<?php echo formatDate($record['birth_date']); ?>" readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Usia <?php echo getRequiredFieldMarker(); ?></label>
                            <input type="text" class="form-control" value="<?php echo $age; ?> tahun"
                                readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Jenis Kelamin <?php echo getRequiredFieldMarker(); ?></label>
                            <input type="text" class="form-control" value="<?php echo $record['gender']; ?>" readonly>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>


<?php if (!$isViewMode): ?>
<script>
$(document).ready(function() {
    // Initialize select2
    $('.select2').select2();

    // Initialize datepicker
    $('.datepicker').daterangepicker({
        locale: {
            format: 'DD-MM-YYYY',
            applyLabel: 'Pilih',
            cancelLabel: 'Batal',
            daysOfWeek: ['Min', 'Sen', 'Sel', 'Rab', 'Kam', 'Jum', 'Sab'],
            monthNames: ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus',
                'September', 'Oktober', 'November', 'Desember'
            ],
            firstDay: 1
        },
        singleDatePicker: true,
        showDropdowns: true,
        autoApply: true
    });

});

// Function to toggle "other" bad habits text field
function toggleOtherBadHabits() {
    const checkbox = document.getElementById('bad_habits_other_check');
    const textField = document.getElementById('bad_habits_other_text');

    if (checkbox.checked) {
        textField.style.display = 'block';
        textField.focus();
    } else {
        textField.style.display = 'none';
        textField.value = '';
    }
}
</script>
<?php endif; ?>