<?php
// Section 10 - Diagnosis
// Get existing diagnosis data if it exists
$diagnosis = $db->getRow("SELECT * FROM diagnoses WHERE medical_record_id = ?i", $recordId);

// Initialize variables with existing data or defaults
$skeletalMalocclusion = isset($diagnosis['skeletal_malocclusion']) ? $diagnosis['skeletal_malocclusion'] : '';
$angleMalocclusion = isset($diagnosis['angle_malocclusion']) ? $diagnosis['angle_malocclusion'] : '';
$cleftLip = isset($diagnosis['cleft_lip']) ? $diagnosis['cleft_lip'] : '';
$cleftLipPalate = isset($diagnosis['cleft_lip_palate']) ? $diagnosis['cleft_lip_palate'] : '';
$cleftPalate = isset($diagnosis['cleft_palate']) ? $diagnosis['cleft_palate'] : '';
$syndrome = isset($diagnosis['syndrome']) ? $diagnosis['syndrome'] : '';
$syndromeName = isset($diagnosis['syndrome_name']) ? $diagnosis['syndrome_name'] : '';
?>
<style>
.selectgroup-input:not(:checked)+.selectgroup-button {
    background-color: #fdfdff !important;
    border-color: #e4e6fc !important;
    color: #495057 !important;
}

.selectgroup-input:checked+.selectgroup-button {
    background-color: #6777ef !important;
    border-color: #6777ef !important;
    color: #fff !important;
}
</style>

<div class="section-body">
    <h2 class="section-title">Diagnosis</h2>

    <?php if (!empty($errorMessage)): ?>
    <div class="alert alert-danger"><?= $errorMessage ?></div>
    <?php endif; ?>

    <?php if (!empty($successMessage)): ?>
    <div class="alert alert-success"><?= $successMessage ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header">
            <h4>Diagnosis</h4>
        </div>
        <div class="card-body">
            <!-- Maloklusi Skeletal -->
            <div class="form-group row mb-4">
                <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3">Maloklusi Skeletal</label>
                <div class="col-sm-12 col-md-9">
                    <div class="selectgroup">
                        <?php foreach (range(1, 5) as $value): ?>
                        <label class="selectgroup-item">
                            <input type="radio" name="skeletal_malocclusion" value="<?= $value ?>"
                                class="selectgroup-input" <?= $skeletalMalocclusion == $value ? 'checked' : '' ?>>
                            <span class="selectgroup-button"><?= $value ?></span>
                        </label>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Maloklusi Angle -->
            <div class="form-group row mb-4">
                <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3">Maloklusi Angle</label>
                <div class="col-sm-12 col-md-9">
                    <div class="selectgroup">
                        <?php foreach (range(1, 3) as $value): ?>
                        <label class="selectgroup-item">
                            <input type="radio" name="angle_malocclusion" value="<?= $value ?>"
                                class="selectgroup-input" <?= $angleMalocclusion == $value ? 'checked' : '' ?>>
                            <span class="selectgroup-button"><?= $value ?></span>
                        </label>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Cleft Lip -->
            <div class="form-group row mb-4">
                <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3">Cleft Lip</label>
                <div class="col-sm-12 col-md-9">
                    <div class="selectgroup">
                        <label class="selectgroup-item">
                            <input type="radio" name="cleft_lip" value="unilateral" class="selectgroup-input"
                                <?= $cleftLip == 'unilateral' ? 'checked' : '' ?>>
                            <span class="selectgroup-button">Unilateral</span>
                        </label>
                        <label class="selectgroup-item">
                            <input type="radio" name="cleft_lip" value="bilateral" class="selectgroup-input"
                                <?= $cleftLip == 'bilateral' ? 'checked' : '' ?>>
                            <span class="selectgroup-button">Bilateral</span>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Cleft Lip Palate -->
            <div class="form-group row mb-4">
                <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3">Cleft Lip Palate</label>
                <div class="col-sm-12 col-md-9">
                    <div class="selectgroup">
                        <label class="selectgroup-item">
                            <input type="radio" name="cleft_lip_palate" value="unilateral" class="selectgroup-input"
                                <?= $cleftLipPalate == 'unilateral' ? 'checked' : '' ?>>
                            <span class="selectgroup-button">Unilateral</span>
                        </label>
                        <label class="selectgroup-item">
                            <input type="radio" name="cleft_lip_palate" value="bilateral" class="selectgroup-input"
                                <?= $cleftLipPalate == 'bilateral' ? 'checked' : '' ?>>
                            <span class="selectgroup-button">Bilateral</span>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Cleft Palate -->
            <div class="form-group row mb-4">
                <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3">Cleft Palate</label>
                <div class="col-sm-12 col-md-9">
                    <div class="selectgroup">
                        <label class="selectgroup-item">
                            <input type="radio" name="cleft_palate" value="unilateral" class="selectgroup-input"
                                <?= $cleftPalate == 'unilateral' ? 'checked' : '' ?>>
                            <span class="selectgroup-button">Unilateral</span>
                        </label>
                        <label class="selectgroup-item">
                            <input type="radio" name="cleft_palate" value="bilateral" class="selectgroup-input"
                                <?= $cleftPalate == 'bilateral' ? 'checked' : '' ?>>
                            <span class="selectgroup-button">Bilateral</span>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Sindrom -->
            <div class="form-group row mb-4">
                <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3">Sindrom</label>
                <div class="col-sm-12 col-md-9">
                    <div class="selectgroup">
                        <label class="selectgroup-item">
                            <input type="radio" name="syndrome" value="Ya" class="selectgroup-input syndrome-radio"
                                <?= $syndrome == 'Ya' ? 'checked' : '' ?>>
                            <span class="selectgroup-button">Ya</span>
                        </label>
                        <label class="selectgroup-item">
                            <input type="radio" name="syndrome" value="Tidak" class="selectgroup-input syndrome-radio"
                                <?= $syndrome == 'Tidak' ? 'checked' : '' ?>>
                            <span class="selectgroup-button">Tidak</span>
                        </label>
                    </div>

                    <!-- Conditional field for syndrome name -->
                    <div id="syndrome-name-container" class="mt-3 <?= $syndrome == 'Ya' ? '' : 'd-none' ?>">
                        <input type="text" name="syndrome_name" class="form-control" placeholder="Nama Sindrom"
                            value="<?= $syndromeName ?>">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Show/hide syndrome name field based on selection
    const syndromeRadios = document.querySelectorAll('.syndrome-radio');
    const syndromeNameContainer = document.getElementById('syndrome-name-container');

    syndromeRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            if (this.value === 'Ya' && this.checked) {
                syndromeNameContainer.classList.remove('d-none');
            } else {
                syndromeNameContainer.classList.add('d-none');
            }
        });
    });

    // Add functionality to unselect radio buttons
    document.querySelectorAll('.selectgroup-input').forEach(radio => {
        radio.addEventListener('click', function(e) {
            // Check if this radio button was already selected
            if (this.getAttribute('data-previously-checked') === 'true') {
                // Unselect it
                this.checked = false;
                this.setAttribute('data-previously-checked', 'false');

                // If this is a syndrome radio and it's being unselected, hide the syndrome name field
                if (this.classList.contains('syndrome-radio') && this.value === 'Ya') {
                    syndromeNameContainer.classList.add('d-none');
                }

                // Create a change event to trigger any handlers
                const changeEvent = new Event('change', {
                    bubbles: true
                });
                this.dispatchEvent(changeEvent);
            } else {
                // Mark this as selected for the next click
                document.querySelectorAll(`input[name="${this.name}"]`).forEach(r => {
                    r.setAttribute('data-previously-checked', 'false');
                });
                this.setAttribute('data-previously-checked', 'true');
            }
        });
    });
});
</script>