<?php
// Section 11 - Rencana Terapi
// Get existing treatment plan data if it exists
$treatmentPlan = $db->getRow("SELECT * FROM treatment_plans WHERE medical_record_id = ?i", $recordId);

// Initialize variables with existing data or defaults
$orthodonticTreatment = isset($treatmentPlan['orthodontic_treatment']) ? $treatmentPlan['orthodontic_treatment'] : 0;
$functionalTreatment = isset($treatmentPlan['functional_treatment']) ? $treatmentPlan['functional_treatment'] : 0;
$surgicalTreatment = isset($treatmentPlan['surgical_treatment']) ? $treatmentPlan['surgical_treatment'] : 0;

// Main appliances
$conventionalFixed = isset($treatmentPlan['conventional_fixed']) ? $treatmentPlan['conventional_fixed'] : 0;
$selfLigatingFixed = isset($treatmentPlan['self_ligating_fixed']) ? $treatmentPlan['self_ligating_fixed'] : 0;
$removableAppliance = isset($treatmentPlan['removable_appliance']) ? $treatmentPlan['removable_appliance'] : 0;
$myofunctional = isset($treatmentPlan['myofunctional']) ? $treatmentPlan['myofunctional'] : 0;
$myofunctionalType = isset($treatmentPlan['myofunctional_type']) ? $treatmentPlan['myofunctional_type'] : '';
$clearAligner = isset($treatmentPlan['clear_aligner']) ? $treatmentPlan['clear_aligner'] : 0;

// Additional appliances
$miniscrew = isset($treatmentPlan['miniscrew']) ? $treatmentPlan['miniscrew'] : 0;
$rpe = isset($treatmentPlan['rpe']) ? $treatmentPlan['rpe'] : 0;
$tpa = isset($treatmentPlan['tpa']) ? $treatmentPlan['tpa'] : 0;
$pendex = isset($treatmentPlan['pendex']) ? $treatmentPlan['pendex'] : 0;
$nance = isset($treatmentPlan['nance']) ? $treatmentPlan['nance'] : 0;
$otherAppliance = isset($treatmentPlan['other_appliance']) ? $treatmentPlan['other_appliance'] : 0;
$otherApplianceType = isset($treatmentPlan['other_appliance_type']) ? $treatmentPlan['other_appliance_type'] : '';

// Retainers
$essixRetainer = isset($treatmentPlan['essix_retainer']) ? $treatmentPlan['essix_retainer'] : 0;
$hawleyRetainer = isset($treatmentPlan['hawley_retainer']) ? $treatmentPlan['hawley_retainer'] : 0;
$fixedRetainer = isset($treatmentPlan['fixed_retainer']) ? $treatmentPlan['fixed_retainer'] : 0;
$otherRetainer = isset($treatmentPlan['other_retainer']) ? $treatmentPlan['other_retainer'] : 0;
$otherRetainerType = isset($treatmentPlan['other_retainer_type']) ? $treatmentPlan['other_retainer_type'] : '';
?>
<style>
.selectgroup-input:not(:checked)+.selectgroup-button {
    background-color: #fdfdff !important;
    border-color: #e4e6fc !important;
    color: #495057 !important;
}

.selectgroup-input:checked+.selectgroup-button {
    background-color: #6777ef !important;
    border-color: #6777ef !important;
    color: #fff !important;
}
</style>
<div class="section-body">
    <h2 class="section-title">Rencana Terapi</h2>

    <?php if (!empty($errorMessage)): ?>
    <div class="alert alert-danger"><?= $errorMessage ?></div>
    <?php endif; ?>

    <?php if (!empty($successMessage)): ?>
    <div class="alert alert-success"><?= $successMessage ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header">
            <h4>Rencana Terapi</h4>
        </div>
        <div class="card-body">
            <!-- Jenis Perawatan -->
            <div class="form-group">
                <label class="form-label">Rencana Terapi</label>
                <div class="selectgroup selectgroup-pills">
                    <label class="selectgroup-item">
                        <input type="checkbox" name="orthodontic_treatment" value="1" class="selectgroup-input"
                            <?= $orthodonticTreatment ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Perawatan Orthodonti</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="functional_treatment" value="1" class="selectgroup-input"
                            <?= $functionalTreatment ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Perawatan Fungsional</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="surgical_treatment" value="1" class="selectgroup-input"
                            <?= $surgicalTreatment ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Perawatan Bedah Ortho</span>
                    </label>
                </div>
            </div>

            <div class="mt-4">
                <h6 class="text-primary">Piranti Ortho yang Digunakan</h6>
            </div>

            <!-- Piranti Utama -->
            <div class="form-group">
                <label class="form-label">Utama</label>
                <div class="selectgroup selectgroup-pills">
                    <label class="selectgroup-item">
                        <input type="checkbox" name="conventional_fixed" value="1" class="selectgroup-input"
                            <?= $conventionalFixed ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Cekat Konvensional</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="self_ligating_fixed" value="1" class="selectgroup-input"
                            <?= $selfLigatingFixed ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Cekat Self-Ligating</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="removable_appliance" value="1" class="selectgroup-input"
                            <?= $removableAppliance ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Removable Appliance</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="myofunctional" value="1"
                            class="selectgroup-input myofunctional-check" <?= $myofunctional ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Myofunctional</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="clear_aligner" value="1" class="selectgroup-input"
                            <?= $clearAligner ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Clear Aligner</span>
                    </label>
                </div>

                <!-- Conditional field for Myofunctional type -->
                <div id="myofunctional-type-container" class="mt-3 <?= $myofunctional ? '' : 'd-none' ?>">
                    <input type="text" name="myofunctional_type" class="form-control" placeholder="Jenis Myofunctional"
                        value="<?= $myofunctionalType ?>">
                </div>
            </div>

            <!-- Piranti Tambahan -->
            <div class="form-group">
                <label class="form-label">Tambahan</label>
                <div class="selectgroup selectgroup-pills">
                    <label class="selectgroup-item">
                        <input type="checkbox" name="miniscrew" value="1" class="selectgroup-input"
                            <?= $miniscrew ? 'checked' : '' ?>>
                        <span class="selectgroup-button">MiniScrew</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="rpe" value="1" class="selectgroup-input"
                            <?= $rpe ? 'checked' : '' ?>>
                        <span class="selectgroup-button">RPE</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="tpa" value="1" class="selectgroup-input"
                            <?= $tpa ? 'checked' : '' ?>>
                        <span class="selectgroup-button">TPA</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="pendex" value="1" class="selectgroup-input"
                            <?= $pendex ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Pendex</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="nance" value="1" class="selectgroup-input"
                            <?= $nance ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Nance</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="other_appliance" value="1"
                            class="selectgroup-input other-appliance-check" <?= $otherAppliance ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Lain-Lain</span>
                    </label>
                </div>

                <!-- Conditional field for Other Appliance type -->
                <div id="other-appliance-container" class="mt-3 <?= $otherAppliance ? '' : 'd-none' ?>">
                    <input type="text" name="other_appliance_type" class="form-control"
                        placeholder="Jenis Piranti Lainnya" value="<?= $otherApplianceType ?>">
                </div>
            </div>

            <!-- Retainer -->
            <div class="form-group">
                <label class="form-label">Retainer</label>
                <div class="selectgroup selectgroup-pills">
                    <label class="selectgroup-item">
                        <input type="checkbox" name="essix_retainer" value="1" class="selectgroup-input"
                            <?= $essixRetainer ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Essix</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="hawley_retainer" value="1" class="selectgroup-input"
                            <?= $hawleyRetainer ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Hawley</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="fixed_retainer" value="1" class="selectgroup-input"
                            <?= $fixedRetainer ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Fixed</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="other_retainer" value="1"
                            class="selectgroup-input other-retainer-check" <?= $otherRetainer ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Lain-Lain</span>
                    </label>
                </div>

                <!-- Conditional field for Other Retainer type -->
                <div id="other-retainer-container" class="mt-3 <?= $otherRetainer ? '' : 'd-none' ?>">
                    <input type="text" name="other_retainer_type" class="form-control"
                        placeholder="Jenis Retainer Lainnya" value="<?= $otherRetainerType ?>">
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Show/hide myofunctional type field
    const myofunctionalCheck = document.querySelector('.myofunctional-check');
    const myofunctionalTypeContainer = document.getElementById('myofunctional-type-container');

    myofunctionalCheck.addEventListener('change', function() {
        if (this.checked) {
            myofunctionalTypeContainer.classList.remove('d-none');
        } else {
            myofunctionalTypeContainer.classList.add('d-none');
        }
    });

    // Show/hide other appliance type field
    const otherApplianceCheck = document.querySelector('.other-appliance-check');
    const otherApplianceContainer = document.getElementById('other-appliance-container');

    otherApplianceCheck.addEventListener('change', function() {
        if (this.checked) {
            otherApplianceContainer.classList.remove('d-none');
        } else {
            otherApplianceContainer.classList.add('d-none');
        }
    });

    // Show/hide other retainer type field
    const otherRetainerCheck = document.querySelector('.other-retainer-check');
    const otherRetainerContainer = document.getElementById('other-retainer-container');

    otherRetainerCheck.addEventListener('change', function() {
        if (this.checked) {
            otherRetainerContainer.classList.remove('d-none');
        } else {
            otherRetainerContainer.classList.add('d-none');
        }
    });
});
</script>