<?php
// Section 13 - Foto
// Get existing photos data if it exists
$photos = $db->getAll("SELECT * FROM patient_photos WHERE medical_record_id = ?i ORDER BY photo_type, photo_category", $recordId);

// Group photos by type and category
$groupedPhotos = [];
$photoTypes = ['Ekstra Oral', 'Intra Oral', 'Model'];
$photoCategories = ['Before', 'After'];

foreach ($photoTypes as $type) {
    $groupedPhotos[$type] = [];
    foreach ($photoCategories as $category) {
        $groupedPhotos[$type][$category] = [];
    }
}

// Populate grouped photos
foreach ($photos as $photo) {
    $groupedPhotos[$photo['photo_type']][$photo['photo_category']][] = $photo;
}
?>

<div class="section-body">
    <h2 class="section-title">Foto Pasien</h2>

    <?php if (!empty($errorMessage)): ?>
    <div class="alert alert-danger"><?= $errorMessage ?></div>
    <?php endif; ?>

    <?php if (!empty($successMessage)): ?>
    <div class="alert alert-success"><?= $successMessage ?></div>
    <?php endif; ?>

    <!-- Photo Upload Tab Navigation -->
    <div class="card">
        <div class="card-header">
            <ul class="nav nav-tabs" id="photoTabs" role="tablist">
                <?php foreach ($photoTypes as $index => $type): ?>
                <li class="nav-item">
                    <a class="nav-link <?= $index === 0 ? 'active' : '' ?>"
                        id="<?= strtolower(str_replace(' ', '-', $type)) ?>-tab" data-toggle="tab"
                        href="#<?= strtolower(str_replace(' ', '-', $type)) ?>" role="tab"
                        aria-controls="<?= strtolower(str_replace(' ', '-', $type)) ?>"
                        aria-selected="<?= $index === 0 ? 'true' : 'false' ?>">
                        <?= $type ?>
                    </a>
                </li>
                <?php endforeach; ?>
            </ul>
        </div>
        <div class="card-body">
            <div class="tab-content" id="photoTabsContent">
                <?php foreach ($photoTypes as $index => $type): ?>
                <div class="tab-pane fade <?= $index === 0 ? 'show active' : '' ?>"
                    id="<?= strtolower(str_replace(' ', '-', $type)) ?>" role="tabpanel"
                    aria-labelledby="<?= strtolower(str_replace(' ', '-', $type)) ?>-tab">

                    <div class="row">
                        <?php foreach ($photoCategories as $catIndex => $category): ?>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4><?= $type ?> - <?= $category ?></h4>
                                    <div class="card-header-action">
                                        <button type="button" class="btn btn-primary"
                                            onclick="document.getElementById('photo-upload-<?= strtolower(str_replace(' ', '-', $type)) ?>-<?= strtolower($category) ?>').click();">
                                            <i class="fas fa-upload"></i> Upload
                                        </button>
                                        <input type="file"
                                            id="photo-upload-<?= strtolower(str_replace(' ', '-', $type)) ?>-<?= strtolower($category) ?>"
                                            name="photos[<?= $type ?>][<?= $category ?>][]" accept="image/*"
                                            style="display: none;" multiple
                                            onchange="previewImages(this, '<?= strtolower(str_replace(' ', '-', $type)) ?>-<?= strtolower($category) ?>-preview')">
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div id="<?= strtolower(str_replace(' ', '-', $type)) ?>-<?= strtolower($category) ?>-preview"
                                        class="row photo-gallery">
                                        <!-- Existing photos -->
                                        <?php if (!empty($groupedPhotos[$type][$category])): ?>
                                        <?php foreach ($groupedPhotos[$type][$category] as $photo): ?>
                                        <div class="col-md-4 mb-3 photo-container">
                                            <div class="position-relative">
                                                <img src="<?= htmlspecialchars($photo['photo_path']) ?>"
                                                    class="img-fluid rounded"
                                                    style="object-fit: cover; height: 120px; width: 100%;"
                                                    onclick="openImageModal('<?= htmlspecialchars($photo['photo_path']) ?>')">

                                                <button type="button" class="btn btn-sm btn-danger position-absolute"
                                                    style="top: 5px; right: 5px;"
                                                    onclick="if(confirm('Hapus foto ini?')) { deletePhoto(<?= $photo['id'] ?>, this) }">
                                                    <i class="fas fa-trash"></i>
                                                </button>

                                                <input type="hidden" name="existing_photos[]"
                                                    value="<?= $photo['id'] ?>">
                                            </div>
                                            <small class="text-muted d-block text-center mt-1">
                                                <?= date('d/m/Y', strtotime($photo['created_at'])) ?>
                                            </small>
                                        </div>
                                        <?php endforeach; ?>
                                        <?php else: ?>
                                        <div class="col-12 text-center text-muted">
                                            <p>Belum ada foto <?= $type ?> (<?= $category ?>)</p>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>

<!-- Image Modal -->
<div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="imageModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="imageModalLabel">Foto Pasien</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body text-center">
                <img id="modalImage" src="" class="img-fluid">
            </div>
        </div>
    </div>
</div>

<script>
// Function to preview images before upload
function previewImages(input, previewId) {
    const preview = document.getElementById(previewId);
    const existingEmptyMessage = preview.querySelector('.text-muted');

    if (existingEmptyMessage) {
        existingEmptyMessage.remove();
    }

    if (input.files) {
        for (let i = 0; i < input.files.length; i++) {
            const reader = new FileReader();

            reader.onload = function(e) {
                const photoContainerDiv = document.createElement('div');
                photoContainerDiv.className = 'col-md-4 mb-3 photo-container new-photo';

                photoContainerDiv.innerHTML = `
                    <div class="position-relative">
                        <img src="${e.target.result}" class="img-fluid rounded" 
                            style="object-fit: cover; height: 120px; width: 100%;"
                            onclick="openImageModal('${e.target.result}')">
                        
                        <button type="button" class="btn btn-sm btn-danger position-absolute" 
                            style="top: 5px; right: 5px;"
                            onclick="removePreview(this)">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    <small class="text-muted d-block text-center mt-1">
                        New Upload
                    </small>
                `;

                preview.appendChild(photoContainerDiv);
            }

            reader.readAsDataURL(input.files[i]);
        }
    }
}

// Function to remove preview
function removePreview(button) {
    const photoContainer = button.closest('.photo-container');
    photoContainer.remove();
}

// Function to delete an existing photo
function deletePhoto(photoId, button) {
    // Send AJAX request to delete photo
    fetch('includes/section_handlers/delete_photo.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: `photo_id=${photoId}`
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Remove the photo container from DOM
                const photoContainer = button.closest('.photo-container');
                photoContainer.remove();

                // Show success message
                iziToast.success({
                    title: 'Sukses',
                    message: 'Foto berhasil dihapus',
                    position: 'topRight'
                });
            } else {
                iziToast.error({
                    title: 'Error',
                    message: data.message || 'Gagal menghapus foto',
                    position: 'topRight'
                });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            iziToast.error({
                title: 'Error',
                message: 'Terjadi kesalahan saat menghapus foto',
                position: 'topRight'
            });
        });
}

// Function to open image modal
function openImageModal(imageSrc) {
    // Set image source
    document.getElementById('modalImage').src = imageSrc;

    // Hide any existing modals and remove lingering backdrops
    $('.modal').modal('hide');
    $('.modal-backdrop').remove();

    // Reset body classes
    $('body').removeClass('modal-open').css('padding-right', '');

    // Show our modal with correct settings
    $('#imageModal').modal({
        backdrop: 'static',
        keyboard: true
    });
}

// Add event listeners once DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
    // Use Bootstrap's built-in handlers for modal events
    $('#imageModal').on('hidden.bs.modal', function() {
        // When modal is hidden, ensure backdrop is removed
        $('.modal-backdrop').remove();
        $('body').removeClass('modal-open').css('padding-right', '');
    });

    // Add proper close button behavior
    $('#imageModal .close').on('click', function() {
        // Properly close the modal using Bootstrap's API
        $('#imageModal').modal('hide');
    });

    // Fix for iOS and Safari issues with modal
    if (/iPad|iPhone|iPod|Safari/.test(navigator.userAgent) && !window.MSStream) {
        $('.modal').appendTo('body');
    }
});
</script>

<style>
.photo-gallery {
    display: flex;
    flex-wrap: wrap;
}

.photo-container {
    transition: all 0.3s ease;
}

.photo-container:hover {
    transform: scale(1.05);
}

.new-photo {
    animation: fadeIn 0.5s;
}

@keyframes fadeIn {
    from {
        opacity: 0;
    }

    to {
        opacity: 1;
    }
}
</style>