<!-- Third Section: Pemeriksaan Ekstra Oral -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4>Pemeriksaan Ekstra Oral</h4>
            </div>
            <div class="card-body">
                <?php if ($isViewMode): ?>
                <!-- View mode - display data in a more readable format -->
                
                <!-- Vertical Part -->
                <div class="section-title mt-0">Vertikal</div>
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-sm">
                            <tr>
                                <td width="40%" class="font-weight-bold">Bentuk Wajah</td>
                                <td><?php echo viewModeDisplay(isset($extraOral['face_shape']) ? $extraOral['face_shape'] : ''); ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-sm">
                            <tr>
                                <td width="40%" class="font-weight-bold">Keseimbangan Wajah</td>
                                <td>
                                    <?php echo viewModeDisplay(isset($extraOral['vertical_face_balance']) ? $extraOral['vertical_face_balance'] : ''); ?>
                                    <?php if (isset($extraOral['vertical_face_balance']) && $extraOral['vertical_face_balance'] == 'Tidak Seimbang' && isset($extraOral['vertical_face_balance_value'])): ?>
                                        (<?php echo $extraOral['vertical_face_balance_value']; ?> mm)
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                <!-- Transversal Part -->
                <div class="section-title mt-3">Transversal</div>
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-sm">
                            <tr>
                                <td width="40%" class="font-weight-bold">Keseimbangan Wajah</td>
                                <td>
                                    <?php echo viewModeDisplay(isset($extraOral['transversal_face_balance']) ? $extraOral['transversal_face_balance'] : ''); ?>
                                    <?php if (isset($extraOral['transversal_face_balance']) && $extraOral['transversal_face_balance'] == 'Tidak Seimbang' && isset($extraOral['transversal_face_balance_value'])): ?>
                                        (<?php echo $extraOral['transversal_face_balance_value']; ?> mm)
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-sm">
                            <tr>
                                <td width="40%" class="font-weight-bold">Dagu</td>
                                <td><?php echo viewModeDisplay(isset($extraOral['chin']) ? $extraOral['chin'] : ''); ?></td>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-sm">
                            <tr>
                                <td width="40%" class="font-weight-bold">Garis Tengah Geligi Atas</td>
                                <td>
                                    <?php echo viewModeDisplay(isset($extraOral['upper_dental_midline']) ? $extraOral['upper_dental_midline'] : ''); ?>
                                    <?php if (isset($extraOral['upper_dental_midline']) && ($extraOral['upper_dental_midline'] == 'Ke Kiri' || $extraOral['upper_dental_midline'] == 'Ke Kanan') && isset($extraOral['upper_dental_midline_value'])): ?>
                                        (<?php echo $extraOral['upper_dental_midline_value']; ?> mm)
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-sm">
                            <tr>
                                <td width="40%" class="font-weight-bold">Garis Tengah Geligi Bawah</td>
                                <td>
                                    <?php echo viewModeDisplay(isset($extraOral['lower_dental_midline']) ? $extraOral['lower_dental_midline'] : ''); ?>
                                    <?php if (isset($extraOral['lower_dental_midline']) && ($extraOral['lower_dental_midline'] == 'Ke Kiri' || $extraOral['lower_dental_midline'] == 'Ke Kanan') && isset($extraOral['lower_dental_midline_value'])): ?>
                                        (<?php echo $extraOral['lower_dental_midline_value']; ?> mm)
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                <!-- Lips Part -->
                <div class="section-title mt-3">Bibir</div>
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-sm">
                            <tr>
                                <td width="40%" class="font-weight-bold">Tonus Bibir Atas</td>
                                <td><?php echo viewModeDisplay(isset($extraOral['upper_lip_tonus']) ? $extraOral['upper_lip_tonus'] : ''); ?></td>
                            </tr>
                            <tr>
                                <td class="font-weight-bold">Tonus Bibir Bawah</td>
                                <td><?php echo viewModeDisplay(isset($extraOral['lower_lip_tonus']) ? $extraOral['lower_lip_tonus'] : ''); ?></td>
                            </tr>
                            <tr>
                                <td class="font-weight-bold">Kompetensi Bibir</td>
                                <td><?php echo viewModeDisplay(isset($extraOral['lip_competence']) ? $extraOral['lip_competence'] : ''); ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-sm">
                            <tr>
                                <td width="40%" class="font-weight-bold">Profil E-Line</td>
                                <td><?php echo viewModeDisplay(isset($extraOral['eline_profile']) ? $extraOral['eline_profile'] : ''); ?></td>
                            </tr>
                            <tr>
                                <td class="font-weight-bold">Bibir Atas terhadap E-Line</td>
                                <td><?php echo isset($extraOral['upper_lip_to_eline']) ? $extraOral['upper_lip_to_eline'] . ' mm' : '<span class="text-muted">-</span>'; ?></td>
                            </tr>
                            <tr>
                                <td class="font-weight-bold">Bibir Bawah terhadap E-Line</td>
                                <td><?php echo isset($extraOral['lower_lip_to_eline']) ? $extraOral['lower_lip_to_eline'] . ' mm' : '<span class="text-muted">-</span>'; ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
                
                <?php else: ?>
                <!-- Edit mode - form inputs -->
                
                <!-- Vertical Part -->
                <div class="section-title mt-0">Vertikal</div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Bentuk Wajah</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="face_shape" id="mesofasial"
                                    value="Mesofasial"
                                    <?php echo isset($extraOral['face_shape']) && $extraOral['face_shape'] == 'Mesofasial' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="mesofasial">
                                    Mesofasial
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="face_shape" id="brakifasial"
                                    value="Brakifasial"
                                    <?php echo isset($extraOral['face_shape']) && $extraOral['face_shape'] == 'Brakifasial' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="brakifasial">
                                    Brakifasial
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="face_shape" id="dolikofasial"
                                    value="Dolikofasial"
                                    <?php echo isset($extraOral['face_shape']) && $extraOral['face_shape'] == 'Dolikofasial' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="dolikofasial">
                                    Dolikofasial
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Keseimbangan Wajah</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="vertical_face_balance"
                                    id="balanced_vertical" value="Seimbang"
                                    <?php echo isset($extraOral['vertical_face_balance']) && $extraOral['vertical_face_balance'] == 'Seimbang' ? 'checked' : ''; ?>
                                    onclick="toggleVerticalFaceBalanceInput(false)">
                                <label class="form-check-label" for="balanced_vertical">
                                    Seimbang
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="vertical_face_balance"
                                    id="unbalanced_vertical" value="Tidak Seimbang"
                                    <?php echo isset($extraOral['vertical_face_balance']) && $extraOral['vertical_face_balance'] == 'Tidak Seimbang' ? 'checked' : ''; ?>
                                    onclick="toggleVerticalFaceBalanceInput(true)">
                                <label class="form-check-label" for="unbalanced_vertical">
                                    Tidak Seimbang
                                </label>
                            </div>
                            <div id="vertical_face_balance_input_container"
                                style="display: <?php echo isset($extraOral['vertical_face_balance']) && $extraOral['vertical_face_balance'] == 'Tidak Seimbang' ? 'block' : 'none'; ?>;">
                                <div class="input-group mt-2">
                                    <input type="number" class="form-control" name="vertical_face_balance_value"
                                        id="vertical_face_balance_value" step="0.1" min="0"
                                        value="<?php echo isset($extraOral['vertical_face_balance_value']) ? $extraOral['vertical_face_balance_value'] : ''; ?>"
                                        placeholder="Masukkan nilai">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transversal Part -->
                <div class="section-title mt-3">Transversal</div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Keseimbangan Wajah</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="transversal_face_balance"
                                    id="balanced_transversal" value="Seimbang"
                                    <?php echo isset($extraOral['transversal_face_balance']) && $extraOral['transversal_face_balance'] == 'Seimbang' ? 'checked' : ''; ?>
                                    onclick="toggleTransversalFaceBalanceInput(false)">
                                <label class="form-check-label" for="balanced_transversal">
                                    Seimbang
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="transversal_face_balance"
                                    id="unbalanced_transversal" value="Tidak Seimbang"
                                    <?php echo isset($extraOral['transversal_face_balance']) && $extraOral['transversal_face_balance'] == 'Tidak Seimbang' ? 'checked' : ''; ?>
                                    onclick="toggleTransversalFaceBalanceInput(true)">
                                <label class="form-check-label" for="unbalanced_transversal">
                                    Tidak Seimbang
                                </label>
                            </div>
                            <div id="transversal_face_balance_input_container"
                                style="display: <?php echo isset($extraOral['transversal_face_balance']) && $extraOral['transversal_face_balance'] == 'Tidak Seimbang' ? 'block' : 'none'; ?>;">
                                <div class="input-group mt-2">
                                    <input type="number" class="form-control" name="transversal_face_balance_value"
                                        id="transversal_face_balance_value" step="0.1" min="0"
                                        value="<?php echo isset($extraOral['transversal_face_balance_value']) ? $extraOral['transversal_face_balance_value'] : ''; ?>"
                                        placeholder="Masukkan nilai">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Dagu</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="chin" id="normal_chin" value="Normal"
                                    <?php echo isset($extraOral['chin']) && $extraOral['chin'] == 'Normal' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="normal_chin">
                                    Normal
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="chin" id="right_chin"
                                    value="Miring ke Kanan"
                                    <?php echo isset($extraOral['chin']) && $extraOral['chin'] == 'Miring ke Kanan' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="right_chin">
                                    Miring ke Kanan
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="chin" id="left_chin"
                                    value="Miring ke Kiri"
                                    <?php echo isset($extraOral['chin']) && $extraOral['chin'] == 'Miring ke Kiri' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="left_chin">
                                    Miring ke Kiri
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Garis Tengah Geligi Atas</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="upper_dental_midline"
                                    id="normal_upper_midline" value="Normal"
                                    <?php echo isset($extraOral['upper_dental_midline']) && $extraOral['upper_dental_midline'] == 'Normal' ? 'checked' : ''; ?>
                                    onclick="toggleUpperMidlineInput(false)">
                                <label class="form-check-label" for="normal_upper_midline">
                                    Normal
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="upper_dental_midline"
                                    id="left_upper_midline" value="Ke Kiri"
                                    <?php echo isset($extraOral['upper_dental_midline']) && $extraOral['upper_dental_midline'] == 'Ke Kiri' ? 'checked' : ''; ?>
                                    onclick="toggleUpperMidlineInput(true)">
                                <label class="form-check-label" for="left_upper_midline">
                                    Ke Kiri
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="upper_dental_midline"
                                    id="right_upper_midline" value="Ke Kanan"
                                    <?php echo isset($extraOral['upper_dental_midline']) && $extraOral['upper_dental_midline'] == 'Ke Kanan' ? 'checked' : ''; ?>
                                    onclick="toggleUpperMidlineInput(true)">
                                <label class="form-check-label" for="right_upper_midline">
                                    Ke Kanan
                                </label>
                            </div>
                            <div id="upper_midline_input_container"
                                style="display: <?php echo isset($extraOral['upper_dental_midline']) && ($extraOral['upper_dental_midline'] == 'Ke Kiri' || $extraOral['upper_dental_midline'] == 'Ke Kanan') ? 'block' : 'none'; ?>;">
                                <div class="input-group mt-2">
                                    <input type="number" class="form-control" name="upper_dental_midline_value"
                                        id="upper_dental_midline_value" step="0.1" min="0"
                                        value="<?php echo isset($extraOral['upper_dental_midline_value']) ? $extraOral['upper_dental_midline_value'] : ''; ?>"
                                        placeholder="Masukkan nilai">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Garis Tengah Geligi Bawah</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="lower_dental_midline"
                                    id="normal_lower_midline" value="Normal"
                                    <?php echo isset($extraOral['lower_dental_midline']) && $extraOral['lower_dental_midline'] == 'Normal' ? 'checked' : ''; ?>
                                    onclick="toggleLowerMidlineInput(false)">
                                <label class="form-check-label" for="normal_lower_midline">
                                    Normal
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="lower_dental_midline"
                                    id="left_lower_midline" value="Ke Kiri"
                                    <?php echo isset($extraOral['lower_dental_midline']) && $extraOral['lower_dental_midline'] == 'Ke Kiri' ? 'checked' : ''; ?>
                                    onclick="toggleLowerMidlineInput(true)">
                                <label class="form-check-label" for="left_lower_midline">
                                    Ke Kiri
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="lower_dental_midline"
                                    id="right_lower_midline" value="Ke Kanan"
                                    <?php echo isset($extraOral['lower_dental_midline']) && $extraOral['lower_dental_midline'] == 'Ke Kanan' ? 'checked' : ''; ?>
                                    onclick="toggleLowerMidlineInput(true)">
                                <label class="form-check-label" for="right_lower_midline">
                                    Ke Kanan
                                </label>
                            </div>
                            <div id="lower_midline_input_container"
                                style="display: <?php echo isset($extraOral['lower_dental_midline']) && ($extraOral['lower_dental_midline'] == 'Ke Kiri' || $extraOral['lower_dental_midline'] == 'Ke Kanan') ? 'block' : 'none'; ?>;">
                                <div class="input-group mt-2">
                                    <input type="number" class="form-control" name="lower_dental_midline_value"
                                        id="lower_dental_midline_value" step="0.1" min="0"
                                        value="<?php echo isset($extraOral['lower_dental_midline_value']) ? $extraOral['lower_dental_midline_value'] : ''; ?>"
                                        placeholder="Masukkan nilai">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Lips Part -->
                <div class="section-title mt-3">Bibir</div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Tonus Bibir Atas</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="upper_lip_tonus"
                                    id="normal_upper_lip" value="Normal"
                                    <?php echo isset($extraOral['upper_lip_tonus']) && $extraOral['upper_lip_tonus'] == 'Normal' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="normal_upper_lip">
                                    Normal
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="upper_lip_tonus"
                                    id="hypertonus_upper_lip" value="Hipertonus"
                                    <?php echo isset($extraOral['upper_lip_tonus']) && $extraOral['upper_lip_tonus'] == 'Hipertonus' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="hypertonus_upper_lip">
                                    Hipertonus
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="upper_lip_tonus"
                                    id="hypotonus_upper_lip" value="Hipotonus"
                                    <?php echo isset($extraOral['upper_lip_tonus']) && $extraOral['upper_lip_tonus'] == 'Hipotonus' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="hypotonus_upper_lip">
                                    Hipotonus
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Tonus Bibir Bawah</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="lower_lip_tonus"
                                    id="normal_lower_lip" value="Normal"
                                    <?php echo isset($extraOral['lower_lip_tonus']) && $extraOral['lower_lip_tonus'] == 'Normal' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="normal_lower_lip">
                                    Normal
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="lower_lip_tonus"
                                    id="hypertonus_lower_lip" value="Hipertonus"
                                    <?php echo isset($extraOral['lower_lip_tonus']) && $extraOral['lower_lip_tonus'] == 'Hipertonus' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="hypertonus_lower_lip">
                                    Hipertonus
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="lower_lip_tonus"
                                    id="hypotonus_lower_lip" value="Hipotonus"
                                    <?php echo isset($extraOral['lower_lip_tonus']) && $extraOral['lower_lip_tonus'] == 'Hipotonus' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="hypotonus_lower_lip">
                                    Hipotonus
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Kompetensi Bibir</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="lip_competence" id="competent_lip"
                                    value="Kompeten"
                                    <?php echo isset($extraOral['lip_competence']) && $extraOral['lip_competence'] == 'Kompeten' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="competent_lip">
                                    Kompeten
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="lip_competence" id="incompetent_lip"
                                    value="Tidak Kompeten"
                                    <?php echo isset($extraOral['lip_competence']) && $extraOral['lip_competence'] == 'Tidak Kompeten' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="incompetent_lip">
                                    Tidak Kompeten
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Profil E-Line</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="eline_profile" id="straight_eline"
                                    value="Lurus"
                                    <?php echo isset($extraOral['eline_profile']) && $extraOral['eline_profile'] == 'Lurus' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="straight_eline">
                                    Lurus
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="eline_profile" id="convex_eline"
                                    value="Cembung"
                                    <?php echo isset($extraOral['eline_profile']) && $extraOral['eline_profile'] == 'Cembung' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="convex_eline">
                                    Cembung
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="eline_profile" id="concave_eline"
                                    value="Cekung"
                                    <?php echo isset($extraOral['eline_profile']) && $extraOral['eline_profile'] == 'Cekung' ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="concave_eline">
                                    Cekung
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Bibir Atas terhadap E-Line (mm)</label>
                            <div class="input-group">
                                <input type="number" class="form-control" name="upper_lip_to_eline" step="0.1"
                                    value="<?php echo isset($extraOral['upper_lip_to_eline']) ? $extraOral['upper_lip_to_eline'] : ''; ?>">
                                <div class="input-group-append">
                                    <span class="input-group-text">mm</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Bibir Bawah terhadap E-Line (mm)</label>
                            <div class="input-group">
                                <input type="number" class="form-control" name="lower_lip_to_eline" step="0.1"
                                    value="<?php echo isset($extraOral['lower_lip_to_eline']) ? $extraOral['lower_lip_to_eline'] : ''; ?>">
                                <div class="input-group-append">
                                    <span class="input-group-text">mm</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>


<?php if (!$isViewMode): ?>
<script>
function toggleVerticalFaceBalanceInput(show) {
    document.getElementById('vertical_face_balance_input_container').style.display = show ? 'block' : 'none';
}

function toggleTransversalFaceBalanceInput(show) {
    document.getElementById('transversal_face_balance_input_container').style.display = show ? 'block' : 'none';
}

function toggleUpperMidlineInput(show) {
    document.getElementById('upper_midline_input_container').style.display = show ? 'block' : 'none';
}

function toggleLowerMidlineInput(show) {
    document.getElementById('lower_midline_input_container').style.display = show ? 'block' : 'none';
}
</script>
<?php endif; ?>