<?php
// Section 6: Functional Analysis (TMJ and Occlusion)

// Get the functional examination data for this record
$functionalExam = $db->getRow("SELECT * FROM functional_examinations WHERE medical_record_id = ?i", $recordId);
?>

<!-- TMJ Section -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4>TMJ (Temporomandibular Joint)</h4>
            </div>
            <div class="card-body">
                <div class="form-group row mb-4">
                    <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3">Palpasi
                        <?php echo getRequiredFieldMarker(); ?></label>
                    <div class="col-sm-12 col-md-9">
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="palpation" id="palpation_normal"
                                value="Normal"
                                <?= isset($functionalExam['palpation']) && $functionalExam['palpation'] == 'Normal' ? 'checked' : '' ?>>
                            <label class="form-check-label" for="palpation_normal">Normal</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="palpation" id="palpation_pain"
                                value="Sakit"
                                <?= isset($functionalExam['palpation']) && $functionalExam['palpation'] == 'Sakit' ? 'checked' : '' ?>>
                            <label class="form-check-label" for="palpation_pain">Sakit</label>
                        </div>

                        <div id="palpation_location" class="mt-3"
                            style="<?= isset($functionalExam['palpation']) && $functionalExam['palpation'] == 'Sakit' ? '' : 'display: none;' ?>">
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="palpation_location"
                                    id="palpation_left" value="Kiri"
                                    <?= isset($functionalExam['palpation_location']) && $functionalExam['palpation_location'] == 'Kiri' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="palpation_left">Kiri</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="palpation_location"
                                    id="palpation_right" value="Kanan"
                                    <?= isset($functionalExam['palpation_location']) && $functionalExam['palpation_location'] == 'Kanan' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="palpation_right">Kanan</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="palpation_location"
                                    id="palpation_bilateral" value="Bilateral"
                                    <?= isset($functionalExam['palpation_location']) && $functionalExam['palpation_location'] == 'Bilateral' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="palpation_bilateral">Bilateral</label>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-4">
                    <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3">Bunyi Clicking/Krepitasi
                        <?php echo getRequiredFieldMarker(); ?></label>
                    <div class="col-sm-12 col-md-9">
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="clicking_sound" id="clicking_yes"
                                value="Ada"
                                <?= isset($functionalExam['clicking_sound']) && $functionalExam['clicking_sound'] == 'Ada' ? 'checked' : '' ?>>
                            <label class="form-check-label" for="clicking_yes">Ada</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="clicking_sound" id="clicking_no"
                                value="Tidak Ada"
                                <?= isset($functionalExam['clicking_sound']) && $functionalExam['clicking_sound'] == 'Tidak Ada' ? 'checked' : '' ?>>
                            <label class="form-check-label" for="clicking_no">Tidak Ada</label>
                        </div>

                        <div id="clicking_details" class="mt-3"
                            style="<?= isset($functionalExam['clicking_sound']) && $functionalExam['clicking_sound'] == 'Ada' ? '' : 'display: none;' ?>">
                            <div class="card border">
                                <div class="card-body p-3">
                                    <div class="form-group mb-3">
                                        <label class="form-label"><strong>Lokasi:</strong></label>
                                        <div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="clicking_location"
                                                    id="clicking_left" value="Kiri"
                                                    <?= isset($functionalExam['clicking_location']) && $functionalExam['clicking_location'] == 'Kiri' ? 'checked' : '' ?>>
                                                <label class="form-check-label" for="clicking_left">Kiri</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="clicking_location"
                                                    id="clicking_right" value="Kanan"
                                                    <?= isset($functionalExam['clicking_location']) && $functionalExam['clicking_location'] == 'Kanan' ? 'checked' : '' ?>>
                                                <label class="form-check-label" for="clicking_right">Kanan</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="clicking_location"
                                                    id="clicking_bilateral" value="Bilateral"
                                                    <?= isset($functionalExam['clicking_location']) && $functionalExam['clicking_location'] == 'Bilateral' ? 'checked' : '' ?>>
                                                <label class="form-check-label"
                                                    for="clicking_bilateral">Bilateral</label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="form-label"><strong>Waktu:</strong></label>
                                        <div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="clicking_timing"
                                                    id="clicking_opening" value="Saat buka mulut"
                                                    <?= isset($functionalExam['clicking_timing']) && $functionalExam['clicking_timing'] == 'Saat buka mulut' ? 'checked' : '' ?>>
                                                <label class="form-check-label" for="clicking_opening">Saat buka
                                                    mulut</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="clicking_timing"
                                                    id="clicking_closing" value="Saat tutup mulut"
                                                    <?= isset($functionalExam['clicking_timing']) && $functionalExam['clicking_timing'] == 'Saat tutup mulut' ? 'checked' : '' ?>>
                                                <label class="form-check-label" for="clicking_closing">Saat tutup
                                                    mulut</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="clicking_timing"
                                                    id="clicking_both" value="Keduanya"
                                                    <?= isset($functionalExam['clicking_timing']) && $functionalExam['clicking_timing'] == 'Keduanya' ? 'checked' : '' ?>>
                                                <label class="form-check-label" for="clicking_both">Keduanya</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Occlusion Section -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4>Oklusi</h4>
            </div>
            <div class="card-body">
                <div class="form-group row mb-4">
                    <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3">Interocclusal Clearance (mm)
                        <?php echo getRequiredFieldMarker(); ?></label>
                    <div class="col-sm-12 col-md-9">
                        <div class="input-group">
                            <input type="number" class="form-control" name="interocclusal_clearance" step="0.1" min="0"
                                max="20"
                                value="<?= isset($functionalExam['interocclusal_clearance']) ? $functionalExam['interocclusal_clearance'] : '' ?>">
                            <div class="input-group-append">
                                <span class="input-group-text">mm</span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-4">
                    <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3">Oklusi Sentrik dan Relasi
                        Sentrik <?php echo getRequiredFieldMarker(); ?></label>
                    <div class="col-sm-12 col-md-9">
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="centric_relation" id="centric_same"
                                value="Sama"
                                <?= isset($functionalExam['centric_relation']) && $functionalExam['centric_relation'] == 'Sama' ? 'checked' : '' ?>>
                            <label class="form-check-label" for="centric_same">Sama</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="centric_relation" id="centric_not_same"
                                value="Tidak Sama"
                                <?= isset($functionalExam['centric_relation']) && $functionalExam['centric_relation'] == 'Tidak Sama' ? 'checked' : '' ?>>
                            <label class="form-check-label" for="centric_not_same">Tidak Sama</label>
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-4">
                    <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3">Hambatan Oklusi
                        Vertikal/Occlusal Interference <?php echo getRequiredFieldMarker(); ?></label>
                    <div class="col-sm-12 col-md-9">
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="vertical_occlusal_interference"
                                id="vertical_interference_yes" value="Ada"
                                <?= isset($functionalExam['vertical_occlusal_interference']) && $functionalExam['vertical_occlusal_interference'] == 'Ada' ? 'checked' : '' ?>>
                            <label class="form-check-label" for="vertical_interference_yes">Ada</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="vertical_occlusal_interference"
                                id="vertical_interference_no" value="Tidak Ada"
                                <?= isset($functionalExam['vertical_occlusal_interference']) && $functionalExam['vertical_occlusal_interference'] == 'Tidak Ada' ? 'checked' : '' ?>>
                            <label class="form-check-label" for="vertical_interference_no">Tidak Ada</label>
                        </div>

                        <div id="vertical_interference_regio" class="mt-2"
                            style="<?= isset($functionalExam['vertical_occlusal_interference']) && $functionalExam['vertical_occlusal_interference'] == 'Ada' ? '' : 'display: none;' ?>">
                            <div class="card border">
                                <div class="card-body p-3">
                                    <label class="form-label"><strong>Regio:</strong></label>
                                    <input type="text" class="form-control" name="vertical_occlusal_interference_region"
                                        placeholder="Regio..."
                                        value="<?= isset($functionalExam['vertical_occlusal_interference_region']) ? $functionalExam['vertical_occlusal_interference_region'] : '' ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-4">
                    <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3">Hambatan Oklusi Horizontal
                        <?php echo getRequiredFieldMarker(); ?></label>
                    <div class="col-sm-12 col-md-9">
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="horizontal_occlusal_interference"
                                id="horizontal_interference_yes" value="Ada"
                                <?= isset($functionalExam['horizontal_occlusal_interference']) && $functionalExam['horizontal_occlusal_interference'] == 'Ada' ? 'checked' : '' ?>>
                            <label class="form-check-label" for="horizontal_interference_yes">Ada</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="horizontal_occlusal_interference"
                                id="horizontal_interference_no" value="Tidak Ada"
                                <?= isset($functionalExam['horizontal_occlusal_interference']) && $functionalExam['horizontal_occlusal_interference'] == 'Tidak Ada' ? 'checked' : '' ?>>
                            <label class="form-check-label" for="horizontal_interference_no">Tidak Ada</label>
                        </div>

                        <div id="horizontal_interference_regio" class="mt-2"
                            style="<?= isset($functionalExam['horizontal_occlusal_interference']) && $functionalExam['horizontal_occlusal_interference'] == 'Ada' ? '' : 'display: none;' ?>">
                            <div class="card border">
                                <div class="card-body p-3">
                                    <label class="form-label"><strong>Regio:</strong></label>
                                    <input type="text" class="form-control"
                                        name="horizontal_occlusal_interference_region" placeholder="Regio..."
                                        value="<?= isset($functionalExam['horizontal_occlusal_interference_region']) ? $functionalExam['horizontal_occlusal_interference_region'] : '' ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Check if jQuery is available
    if (typeof jQuery !== 'undefined') {
        // jQuery is available, use $ syntax
        // Handle showing/hiding of palpation location options
        $('input[name="palpation"]').change(function() {
            if ($(this).val() === 'Sakit') {
                $('#palpation_location').show();
            } else {
                $('#palpation_location').hide();
            }
        });

        // Handle showing/hiding of clicking sound details
        $('input[name="clicking_sound"]').change(function() {
            if ($(this).val() === 'Ada') {
                $('#clicking_details').show();
            } else {
                $('#clicking_details').hide();
            }
        });

        // Handle showing/hiding of vertical interference regio
        $('input[name="vertical_occlusal_interference"]').change(function() {
            if ($(this).val() === 'Ada') {
                $('#vertical_interference_regio').show();
            } else {
                $('#vertical_interference_regio').hide();
            }
        });

        // Handle showing/hiding of horizontal interference regio
        $('input[name="horizontal_occlusal_interference"]').change(function() {
            if ($(this).val() === 'Ada') {
                $('#horizontal_interference_regio').show();
            } else {
                $('#horizontal_interference_regio').hide();
            }
        });
    } else {
        // jQuery is not available, use vanilla JavaScript
        function handleRadioChange(name, showId) {
            var radios = document.querySelectorAll('input[name="' + name + '"]');
            radios.forEach(function(radio) {
                radio.addEventListener('change', function() {
                    var showElement = document.getElementById(showId);
                    if (this.value === this.getAttribute('data-show-value')) {
                        showElement.style.display = '';
                    } else {
                        showElement.style.display = 'none';
                    }
                });
            });
        }

        // Set up data attributes for vanilla JS fallback
        document.querySelectorAll('input[name="palpation"]').forEach(function(el) {
            if (el.value === 'Sakit') el.setAttribute('data-show-value', 'Sakit');
        });

        document.querySelectorAll('input[name="clicking_sound"]').forEach(function(el) {
            if (el.value === 'Ada') el.setAttribute('data-show-value', 'Ada');
        });

        document.querySelectorAll('input[name="vertical_occlusal_interference"]').forEach(function(el) {
            if (el.value === 'Ada') el.setAttribute('data-show-value', 'Ada');
        });

        document.querySelectorAll('input[name="horizontal_occlusal_interference"]').forEach(function(el) {
            if (el.value === 'Ada') el.setAttribute('data-show-value', 'Ada');
        });

        // Attach event handlers
        handleRadioChange('palpation', 'palpation_location');
        handleRadioChange('clicking_sound', 'clicking_details');
        handleRadioChange('vertical_occlusal_interference', 'vertical_interference_regio');
        handleRadioChange('horizontal_occlusal_interference', 'horizontal_interference_regio');
    }
});
</script>