<?php
// Section 8: Analisis Model (Model Analysis)

// Get the model analysis data for this record
$modelAnalysis = $db->getRow("SELECT * FROM model_analyses WHERE medical_record_id = ?i", $recordId);

// Initialize variables with existing data or defaults
$upperArchShape = $modelAnalysis['maxillary_arch_shape'] ?? '';
$lowerArchShape = $modelAnalysis['mandibular_arch_shape'] ?? '';
$toothData = !empty($modelAnalysis['tooth_data']) ? json_decode($modelAnalysis['tooth_data'], true) : [];
?>

<div class="section-container">
    <h2 class="section-title">Analisis Model</h2>

    <?php if (!empty($errorMessage)): ?>
    <div class="alert alert-danger"><?= $errorMessage ?></div>
    <?php endif; ?>

    <?php if (!empty($successMessage)): ?>
    <div class="alert alert-success"><?= $successMessage ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header">
            <h4>Bentuk Lengkung Gigi</h4>
        </div>
        <div class="card-body">
            <div class="form-group row mb-4">
                <label class="col-form-label sanitize col-12 col-md-3 col-lg-2">Rahang Atas</label>
                <div class="col-sm-12 col-md-9 col-lg-10">
                    <select class="form-control select2" name="upper_arch_shape">
                        <option value="" <?= empty($upperArchShape) ? 'selected' : '' ?>>Pilih Bentuk Lengkung</option>
                        <option value="Segi Empat" <?= $upperArchShape === 'Segi Empat' ? 'selected' : '' ?>>Segi
                            Empat/Square</option>
                        <option value="Segitiga" <?= $upperArchShape === 'Segitiga' ? 'selected' : '' ?>>Segitiga
                        </option>
                        <option value="Omega" <?= $upperArchShape === 'Omega' ? 'selected' : '' ?>>Omega</option>
                        <option value="Oval" <?= $upperArchShape === 'Oval' ? 'selected' : '' ?>>Oval</option>
                    </select>
                </div>
            </div>
            <div class="form-group row mb-4">
                <label class="col-form-label sanitize col-12 col-md-3 col-lg-2">Rahang Bawah</label>
                <div class="col-sm-12 col-md-9 col-lg-10">
                    <select class="form-control select2" name="lower_arch_shape">
                        <option value="" <?= empty($lowerArchShape) ? 'selected' : '' ?>>Pilih Bentuk Lengkung</option>
                        <option value="Segi Empat" <?= $lowerArchShape === 'Segi Empat' ? 'selected' : '' ?>>Segi
                            Empat/Square</option>
                        <option value="Segitiga" <?= $lowerArchShape === 'Segitiga' ? 'selected' : '' ?>>Segitiga
                        </option>
                        <option value="Omega" <?= $lowerArchShape === 'Omega' ? 'selected' : '' ?>>Omega</option>
                        <option value="Oval" <?= $lowerArchShape === 'Oval' ? 'selected' : '' ?>>Oval</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <div class="card mt-4">
        <div class="card-header">
            <h4>Lebar mesio-distal gigi-gigi (mm) dan Posisi gigi pada lengkungnya</h4>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="tooth-table">
                    <thead>
                        <tr style="border-bottom: 2px solid #000;">
                            <th class="text-center" style="width: 120px;border-right: 2px solid #000;">Keterangan</th>
                            <?php for ($i = 18; $i >= 11; $i--): ?>
                            <th class="text-center" <?= $i === 11 ? 'style="border-right: 2px solid #000000"' : '' ?>>
                                <?= $i ?></th>
                            <?php endfor; ?>
                            <?php for ($i = 21; $i <= 28; $i++): ?>
                            <th class="text-center"><?= $i ?></th>
                            <?php endfor; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Row 1: Kondisi Gigi (Upper Teeth Condition) -->
                        <tr>
                            <td class="align-middle" style="border-right: 2px solid #000;">Kondisi Gigi</td>
                            <?php for ($i = 18; $i >= 11; $i--): ?>
                            <td<?= $i === 11 ? ' class="" style="border-right: 2px solid #000000"' : '' ?>>
                                <input type="text" class="form-control form-control-sm placeholder-field"
                                    name="tooth_data[condition][upper][<?= $i ?>]" placeholder="KE"
                                    value="<?= $toothData['condition']['upper'][$i] ?? '' ?>">
                                </td>
                                <?php endfor; ?>
                                <?php for ($i = 21; $i <= 28; $i++): ?>
                                <td>
                                    <input type="text" class="form-control form-control-sm placeholder-field"
                                        name="tooth_data[condition][upper][<?= $i ?>]" placeholder="KE"
                                        value="<?= $toothData['condition']['upper'][$i] ?? '' ?>">
                                </td>
                                <?php endfor; ?>
                        </tr>

                        <!-- Row 2: Malposisi (Upper Teeth Malposition) -->
                        <tr>
                            <td class="align-middle" style="border-right: 2px solid #000;">Malposisi</td>
                            <?php for ($i = 18; $i >= 11; $i--): ?>
                            <td<?= $i === 11 ? ' class="" style="border-right: 2px solid #000000"' : '' ?>>
                                <input type="text" class="form-control form-control-sm placeholder-field"
                                    name="tooth_data[malposition][upper][<?= $i ?>]" placeholder="LaTV"
                                    value="<?= $toothData['malposition']['upper'][$i] ?? '' ?>">
                                </td>
                                <?php endfor; ?>
                                <?php for ($i = 21; $i <= 28; $i++): ?>
                                <td>
                                    <input type="text" class="form-control form-control-sm placeholder-field"
                                        name="tooth_data[malposition][upper][<?= $i ?>]" placeholder="LaTV"
                                        value="<?= $toothData['malposition']['upper'][$i] ?? '' ?>">
                                </td>
                                <?php endfor; ?>
                        </tr>

                        <!-- Row 3: Lebar Mesiodistal (Upper Teeth Width) -->
                        <tr>
                            <td class="align-middle" style="border-right: 2px solid #000;">Lebar Mesiodistal</td>
                            <?php for ($i = 18; $i >= 11; $i--): ?>
                            <td<?= $i === 11 ? ' class="" style="border-right: 2px solid #000000"' : '' ?>>
                                <input type="text" class="form-control form-control-sm tooth-width placeholder-field"
                                    name="tooth_data[width][upper][<?= $i ?>]" placeholder="5"
                                    value="<?= $toothData['width']['upper'][$i] ?? '' ?>">
                                </td>
                                <?php endfor; ?>
                                <?php for ($i = 21; $i <= 28; $i++): ?>
                                <td>
                                    <input type="text"
                                        class="form-control form-control-sm tooth-width placeholder-field"
                                        name="tooth_data[width][upper][<?= $i ?>]" placeholder="5"
                                        value="<?= $toothData['width']['upper'][$i] ?? '' ?>">
                                </td>
                                <?php endfor; ?>
                        </tr>

                        <!-- Row 4: Upper Dental Notation (Quadrant Markers) -->
                        <tr class="bg-light">
                            <td class="align-middle" rowspan="2" style="border-right: 2px solid #000;">Rahang Atas</td>
                            <td colspan="3"></td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="right" data-tooth="V"
                                data-value="V">V</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="right" data-tooth="IV"
                                data-value="IV">IV</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="right" data-tooth="III"
                                data-value="III">III</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="right" data-tooth="II"
                                data-value="II">II</td>
                            <td class="text-center clickable-cell" style="border-right: 2px solid #000000"
                                data-jaw="upper" data-side="right" data-tooth="I" data-value="I">I</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="left" data-tooth="I"
                                data-value="I">I</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="left" data-tooth="II"
                                data-value="II">II</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="left" data-tooth="III"
                                data-value="III">III</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="left" data-tooth="IV"
                                data-value="IV">IV</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="left" data-tooth="V"
                                data-value="V">V</td>
                            <td colspan="4"></td>
                        </tr>

                        <!-- Row 5-6: Upper Dental Notation (Numbers) -->
                        <tr class="bg-light" style="height: 50px;border-bottom: 2px solid #000;">
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="right" data-tooth="8"
                                data-value="8">8</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="right" data-tooth="7"
                                data-value="7">7</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="right" data-tooth="6"
                                data-value="6">6</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="right" data-tooth="5"
                                data-value="5">5</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="right" data-tooth="4"
                                data-value="4">4</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="right" data-tooth="3"
                                data-value="3">3</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="right" data-tooth="2"
                                data-value="2">2</td>
                            <td class="text-center clickable-cell" style="border-right: 2px solid #000000"
                                data-jaw="upper" data-side="right" data-tooth="1" data-value="1">1</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="left" data-tooth="1"
                                data-value="1">1</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="left" data-tooth="2"
                                data-value="2">2</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="left" data-tooth="3"
                                data-value="3">3</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="left" data-tooth="4"
                                data-value="4">4</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="left" data-tooth="5"
                                data-value="5">5</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="left" data-tooth="6"
                                data-value="6">6</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="left" data-tooth="7"
                                data-value="7">7</td>
                            <td class="text-center clickable-cell" data-jaw="upper" data-side="left" data-tooth="8"
                                data-value="8">8</td>
                        </tr>

                        <!-- Row 7-8: Lower Dental Notation -->
                        <tr class="bg-light">
                            <td class="align-middle" rowspan="2" style="border-right: 2px solid #000;">Rahang Bawah</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="right" data-tooth="8"
                                data-value="8">8</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="right" data-tooth="7"
                                data-value="7">7</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="right" data-tooth="6"
                                data-value="6">6</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="right" data-tooth="5"
                                data-value="5">5</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="right" data-tooth="4"
                                data-value="4">4</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="right" data-tooth="3"
                                data-value="3">3</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="right" data-tooth="2"
                                data-value="2">2</td>
                            <td class="text-center clickable-cell" style="border-right: 2px solid #000000"
                                data-jaw="lower" data-side="right" data-tooth="1" data-value="1">1</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="left" data-tooth="1"
                                data-value="1">1</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="left" data-tooth="2"
                                data-value="2">2</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="left" data-tooth="3"
                                data-value="3">3</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="left" data-tooth="4"
                                data-value="4">4</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="left" data-tooth="5"
                                data-value="5">5</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="left" data-tooth="6"
                                data-value="6">6</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="left" data-tooth="7"
                                data-value="7">7</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="left" data-tooth="8"
                                data-value="8">8</td>
                        </tr>

                        <!-- Row 9: Lower Dental Notation (Quadrant Markers) -->
                        <tr class="bg-light">
                            <td colspan="3"></td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="right" data-tooth="V"
                                data-value="V">V</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="right" data-tooth="IV"
                                data-value="IV">IV</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="right" data-tooth="III"
                                data-value="III">III</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="right" data-tooth="II"
                                data-value="II">II</td>
                            <td class="text-center clickable-cell" style="border-right: 2px solid #000000"
                                data-jaw="lower" data-side="right" data-tooth="I" data-value="I">I</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="left" data-tooth="I"
                                data-value="I">I</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="left" data-tooth="II"
                                data-value="II">II</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="left" data-tooth="III"
                                data-value="III">III</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="left" data-tooth="IV"
                                data-value="IV">IV</td>
                            <td class="text-center clickable-cell" data-jaw="lower" data-side="left" data-tooth="V"
                                data-value="V">V</td>
                            <td colspan="4"></td>
                        </tr>

                        <!-- Row 10: Lebar Mesiodistal (Lower Teeth Width) -->
                        <tr>
                            <td class="align-middle" style="border-right: 2px solid #000;">Lebar Mesiodistal</td>
                            <?php for ($i = 48; $i >= 41; $i--): ?>
                            <td<?= $i === 41 ? ' class="" style="border-right: 2px solid #000000"' : '' ?>>
                                <input type="text" class="form-control form-control-sm tooth-width placeholder-field"
                                    name="tooth_data[width][lower][<?= $i ?>]" placeholder="5"
                                    value="<?= $toothData['width']['lower'][$i] ?? '' ?>">
                                </td>
                                <?php endfor; ?>
                                <?php for ($i = 31; $i <= 38; $i++): ?>
                                <td>
                                    <input type="text"
                                        class="form-control form-control-sm tooth-width placeholder-field"
                                        name="tooth_data[width][lower][<?= $i ?>]" placeholder="5"
                                        value="<?= $toothData['width']['lower'][$i] ?? '' ?>">
                                </td>
                                <?php endfor; ?>
                        </tr>

                        <!-- Row 11: Malposisi (Lower Teeth Malposition) -->
                        <tr>
                            <td class="align-middle" style="border-right: 2px solid #000;">Malposisi</td>
                            <?php for ($i = 48; $i >= 41; $i--): ?>
                            <td<?= $i === 41 ? ' class="" style="border-right: 2px solid #000000"' : '' ?>>
                                <input type="text" class="form-control form-control-sm placeholder-field"
                                    name="tooth_data[malposition][lower][<?= $i ?>]" placeholder="LaTV"
                                    value="<?= $toothData['malposition']['lower'][$i] ?? '' ?>">
                                </td>
                                <?php endfor; ?>
                                <?php for ($i = 31; $i <= 38; $i++): ?>
                                <td>
                                    <input type="text" class="form-control form-control-sm placeholder-field"
                                        name="tooth_data[malposition][lower][<?= $i ?>]" placeholder="LaTV"
                                        value="<?= $toothData['malposition']['lower'][$i] ?? '' ?>">
                                </td>
                                <?php endfor; ?>
                        </tr>

                        <!-- Row 12: Kondisi Gigi (Lower Teeth Condition) -->
                        <tr>
                            <td class="align-middle" style="border-right: 2px solid #000;">Kondisi Gigi</td>
                            <?php for ($i = 48; $i >= 41; $i--): ?>
                            <td<?= $i === 41 ? ' class="" style="border-right: 2px solid #000000"' : '' ?>>
                                <input type="text" class="form-control form-control-sm placeholder-field"
                                    name="tooth_data[condition][lower][<?= $i ?>]" placeholder="KE"
                                    value="<?= $toothData['condition']['lower'][$i] ?? '' ?>">
                                </td>
                                <?php endfor; ?>
                                <?php for ($i = 31; $i <= 38; $i++): ?>
                                <td>
                                    <input type="text" class="form-control form-control-sm placeholder-field"
                                        name="tooth_data[condition][lower][<?= $i ?>]" placeholder="KE"
                                        value="<?= $toothData['condition']['lower'][$i] ?? '' ?>">
                                </td>
                                <?php endfor; ?>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                <p><strong>Keterangan:</strong></p>
                <ul>
                    <li>Kondisi Gigi:</li>
                    <ul>
                        <li>KE: Karies Email</li>
                        <li>KD: Karies Dentin</li>
                        <li>KMP: Karies Mencapai Pulpa</li>
                    </ul>
                    <li>Malposisi:</li>
                    <ul>
                        <li>LaTV: Labiotorsoversion</li>
                        <li>La: Labioversion</li>
                        <li>Li: Linguoversion</li>
                        <li>Me: Mesioversion</li>
                        <li>Di: Distoversion</li>
                        <li>In: Infraversion</li>
                        <li>Su: Supraversion</li>
                        <li>To: Torsiversion</li>
                        <li>Tr: Transposisi</li>
                    </ul>
                    </li>
                </ul>
            </div>

            <!-- Add hidden input to store marked teeth data -->
            <input type="hidden" name="marked_teeth" id="marked_teeth_input"
                value='<?php echo htmlspecialchars($modelAnalysis ? $modelAnalysis['marked_teeth'] : '{}'); ?>'>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Get references to the elements
    const markedTeethInput = document.getElementById('marked_teeth_input');
    const clickableCells = document.querySelectorAll('.clickable-cell');

    // Initialize the marked teeth object
    let markedTeeth = {};

    try {
        // Try to parse the existing data from the hidden input
        if (markedTeethInput && markedTeethInput.value && markedTeethInput.value !== '{}') {
            console.log('Loading marked teeth data:', markedTeethInput.value);
            markedTeeth = JSON.parse(markedTeethInput.value);
        }
    } catch (e) {
        console.error('Error parsing marked teeth data:', e);
        markedTeeth = {};
    }

    // Apply marks to teeth based on the loaded data
    applyMarksToTeeth(markedTeeth);

    // Add click handlers to all clickable cells
    clickableCells.forEach(function(cell) {
        cell.addEventListener('click', function() {
            const jaw = this.getAttribute('data-jaw');
            const side = this.getAttribute('data-side');
            const tooth = this.getAttribute('data-tooth');

            if (!jaw || !side || !tooth) {
                console.error('Cell missing required data attributes:', this);
                return;
            }

            // Create a unique identifier for this tooth
            const toothId = `${jaw}_${side}_${tooth}`;
            console.log('Clicked tooth:', toothId);

            // Toggle the mark
            if (this.classList.contains('marked')) {
                // Remove the mark
                this.classList.remove('marked');
                this.innerHTML = this.getAttribute('data-value');
                markedTeeth[toothId] = false;
            } else {
                // Add the mark
                this.classList.add('marked');
                this.innerHTML = `<div class="x-mark">${this.getAttribute('data-value')}</div>`;
                markedTeeth[toothId] = true;
            }

            // Update the hidden input with the current data
            markedTeethInput.value = JSON.stringify(markedTeeth);
            console.log('Updated marked teeth data:', markedTeeth);
        });
    });

    /**
     * Apply marks to teeth based on the loaded data
     */
    function applyMarksToTeeth(data) {
        if (!data || typeof data !== 'object') {
            console.warn('Invalid marked teeth data:', data);
            return;
        }

        console.log('Applying marks to teeth', data);

        // Loop through each marked tooth in the data
        for (const toothId in data) {
            // Skip if not marked
            if (!data[toothId]) continue;

            // Parse the tooth ID to get jaw, side, and tooth
            const [jaw, side, tooth] = toothId.split('_');

            // Find the corresponding cell
            const cell = document.querySelector(
                `.clickable-cell[data-jaw="${jaw}"][data-side="${side}"][data-tooth="${tooth}"]`);

            if (cell) {
                // Mark the cell
                cell.classList.add('marked');
                cell.innerHTML = `<div class="x-mark">${cell.getAttribute('data-value')}</div>`;
                console.log(`Marked tooth: ${toothId}`);
            } else {
                console.warn(`Cell not found for tooth ID: ${toothId}`);
            }
        }
    }
});
</script>

<style>
.clickable-cell {
    cursor: pointer;
    position: relative;
    font-weight: bold;
}

.clickable-cell.marked {
    position: relative;
}

.clickable-cell.marked .x-mark {
    position: relative;
    display: flex;
    justify-content: center;
    align-items: center;
    width: 100%;
    height: 100%;
}

.clickable-cell.marked .x-mark::before,
.clickable-cell.marked .x-mark::after {
    content: '';
    position: absolute;
    width: 35%;
    height: 3px;
    background-color: red;
}

.clickable-cell.marked .x-mark::before {
    transform: rotate(45deg);
}

.clickable-cell.marked .x-mark::after {
    transform: rotate(-45deg);
}

/* Improved placeholder styling for inputs */
input::placeholder {
    color: #adb5bd;
    font-style: italic;
    opacity: 0.7;
}

/* Enhanced styling for placeholder fields */
.placeholder-field::placeholder {
    color: #5a6268;
    font-style: italic;
    opacity: 0.8;
    font-size: 85%;
    letter-spacing: 0.5px;
    text-align: center;
}

.placeholder-field:placeholder-shown {
    border: 1px dashed #b8c2cc;
    background-color: #ffffff;
    box-shadow: none;
    text-align: center;
}

.placeholder-field:focus:placeholder-shown {
    background-color: #ffffff;
    border: 1px solid #80bdff;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.1);
}

/* Add distinctive color for filled values */
.placeholder-field:not(:placeholder-shown) {
    font-weight: 500;
    color: #0056b3;
    border: 1px solid #a8d1ff;
    background-color: #ffffff;
    box-shadow: 0 0 4px rgba(0, 86, 179, 0.1);
    text-align: center;
}

/* Make input fields in tables wider and center text */
#tooth-table input.form-control-sm {
    min-width: 45px;
    width: 100%;
    padding: 0.25rem 0.1rem;
    text-align: center;
}

/* Improve table cell spacing for better input display */
#tooth-table td {
    padding: 0.2rem;
    vertical-align: middle;
    min-width: 50px;
}
</style>