<?php
// Section 9: Analisis Kebutuhan Ruang (Space Analysis)

// Get the space analysis data for this record
$spaceAnalysis = $db->getRow("SELECT * FROM space_analyses WHERE medical_record_id = ?i", $recordId);

// Initialize variables with existing data or defaults
$moyers32_31_41_42_width = $spaceAnalysis['moyers_32_31_41_42_width'] ?? '';
$moyersGender = $spaceAnalysis['moyers_gender'] ?? '';
$spaceAnalysisConclusion = $spaceAnalysis['space_analysis_conclusion'] ?? '';

// Space methods
$maxLeftSpaceMethod = !empty($spaceAnalysis['max_left_space_method']) ?
json_decode($spaceAnalysis['max_left_space_method'], true) : [];
$maxRightSpaceMethod = !empty($spaceAnalysis['max_right_space_method']) ?
json_decode($spaceAnalysis['max_right_space_method'], true) : [];
$mandLeftSpaceMethod = !empty($spaceAnalysis['mand_left_space_method']) ?
json_decode($spaceAnalysis['mand_left_space_method'], true) : [];
$mandRightSpaceMethod = !empty($spaceAnalysis['mand_right_space_method']) ?
json_decode($spaceAnalysis['mand_right_space_method'], true) : [];

// Extraction teeth
$maxLeftExtractionTeeth = !empty($spaceAnalysis['max_left_extraction_teeth']) ?
json_decode($spaceAnalysis['max_left_extraction_teeth'], true) : [];
$maxRightExtractionTeeth = !empty($spaceAnalysis['max_right_extraction_teeth']) ?
json_decode($spaceAnalysis['max_right_extraction_teeth'], true) : [];
$mandLeftExtractionTeeth = !empty($spaceAnalysis['mand_left_extraction_teeth']) ?
json_decode($spaceAnalysis['mand_left_extraction_teeth'], true) : [];
$mandRightExtractionTeeth = !empty($spaceAnalysis['mand_right_extraction_teeth']) ?
json_decode($spaceAnalysis['mand_right_extraction_teeth'], true) : [];
?>

<div class="section-container">
    <h2 class="section-title">Analisis Kebutuhan Ruang</h2>

    <?php if (!empty($errorMessage)): ?>
    <div class="alert alert-danger"><?= $errorMessage ?></div>
    <?php endif; ?>

    <?php if (!empty($successMessage)): ?>
    <div class="alert alert-success"><?= $successMessage ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header">
            <h4>Pilih Metode Analisis</h4>
        </div>
        <div class="card-body">
            <div class="form-group">
                <div class="selectgroup selectgroup-pills">
                    <label class="selectgroup-item">
                        <input type="checkbox" name="analysis_methods[]" value="moyers" class="selectgroup-input"
                            <?= !empty($spaceAnalysis) && !empty($spaceAnalysis['moyers_32_31_41_42_width']) ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Moyers</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="analysis_methods[]" value="kesling" class="selectgroup-input"
                            <?= !empty($spaceAnalysis) && !empty($spaceAnalysis['kesling_max_left_required']) ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Kesling</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="analysis_methods[]" value="lundstrum" class="selectgroup-input"
                            <?= !empty($spaceAnalysis) && !empty($spaceAnalysis['lundstrum_max_s1_required']) ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Lundstrum (ALD)</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="analysis_methods[]" value="ponts" class="selectgroup-input"
                            <?= !empty($spaceAnalysis) && !empty($spaceAnalysis['ponts_mpv']) ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Ponts</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="checkbox" name="analysis_methods[]" value="howe" class="selectgroup-input"
                            <?= !empty($spaceAnalysis) && !empty($spaceAnalysis['howe_pmbaw']) ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Howe</span>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <ul class="nav nav-tabs card-header-tabs" id="spaceAnalysisTab" role="tablist">
                <li class="nav-item" id="moyers-tab-item"
                    style="<?= !empty($spaceAnalysis) && !empty($spaceAnalysis['moyers_32_31_41_42_width']) ? '' : 'display: none;' ?>">
                    <a class="nav-link <?= !empty($spaceAnalysis) && !empty($spaceAnalysis['moyers_32_31_41_42_width']) ? 'active' : '' ?>"
                        id="moyers-tab" data-toggle="tab" href="#moyers" role="tab" aria-controls="moyers"
                        aria-selected="true">Moyers</a>
                </li>
                <li class="nav-item" id="kesling-tab-item"
                    style="<?= !empty($spaceAnalysis) && !empty($spaceAnalysis['kesling_max_left_required']) ? '' : 'display: none;' ?>">
                    <a class="nav-link <?= empty($spaceAnalysis) || empty($spaceAnalysis['moyers_32_31_41_42_width']) && !empty($spaceAnalysis['kesling_max_left_required']) ? 'active' : '' ?>"
                        id="kesling-tab" data-toggle="tab" href="#kesling" role="tab" aria-controls="kesling"
                        aria-selected="false">Kesling</a>
                </li>
                <li class="nav-item" id="lundstrum-tab-item"
                    style="<?= !empty($spaceAnalysis) && !empty($spaceAnalysis['lundstrum_max_s1_required']) ? '' : 'display: none;' ?>">
                    <a class="nav-link <?= !empty($spaceAnalysis) && !empty($spaceAnalysis['lundstrum_max_s1_required']) && empty($spaceAnalysis['moyers_32_31_41_42_width']) && empty($spaceAnalysis['kesling_max_left_required']) ? 'active' : '' ?>"
                        id="lundstrum-tab" data-toggle="tab" href="#lundstrum" role="tab" aria-controls="lundstrum"
                        aria-selected="false">Lundstrum (ALD)</a>
                </li>
                <li class="nav-item" id="ponts-tab-item"
                    style="<?= !empty($spaceAnalysis) && !empty($spaceAnalysis['ponts_mpv']) ? '' : 'display: none;' ?>">
                    <a class="nav-link <?= !empty($spaceAnalysis) && !empty($spaceAnalysis['ponts_mpv']) && empty($spaceAnalysis['moyers_32_31_41_42_width']) && empty($spaceAnalysis['kesling_max_left_required']) && empty($spaceAnalysis['lundstrum_max_s1_required']) ? 'active' : '' ?>"
                        id="ponts-tab" data-toggle="tab" href="#ponts" role="tab" aria-controls="ponts"
                        aria-selected="false">Ponts</a>
                </li>
                <li class="nav-item" id="howe-tab-item"
                    style="<?= !empty($spaceAnalysis) && !empty($spaceAnalysis['howe_pmbaw']) ? '' : 'display: none;' ?>">
                    <a class="nav-link <?= !empty($spaceAnalysis) && !empty($spaceAnalysis['howe_pmbaw']) && empty($spaceAnalysis['moyers_32_31_41_42_width']) && empty($spaceAnalysis['kesling_max_left_required']) && empty($spaceAnalysis['lundstrum_max_s1_required']) && empty($spaceAnalysis['ponts_mpv']) ? 'active' : '' ?>"
                        id="howe-tab" data-toggle="tab" href="#howe" role="tab" aria-controls="howe"
                        aria-selected="false">Howe</a>
                </li>
            </ul>
        </div>
        <div class="card-body">
            <div class="tab-content" id="spaceAnalysisTabContent">
                <!-- Moyers Analysis Tab -->
                <div class="tab-pane fade <?= !empty($spaceAnalysis) && !empty($spaceAnalysis['moyers_32_31_41_42_width']) ? 'show active' : '' ?>"
                    id="moyers" role="tabpanel" aria-labelledby="moyers-tab">
                    <h5 class="card-title">Analisis Moyers</h5>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Jenis Kelamin <?php echo getRequiredFieldMarker(); ?></label>
                                <select class="form-control" name="moyers_gender" id="moyers_gender">
                                    <option value="">Pilih Jenis Kelamin</option>
                                    <option value="Laki-Laki"
                                        <?= $moyersGender === 'Laki-Laki' || $patient['gender'] === 'Laki-laki' ? 'selected' : '' ?>>
                                        Laki-Laki</option>
                                    <option value="Perempuan"
                                        <?= $moyersGender === 'Perempuan' || $patient['gender'] === 'Perempuan' ? 'selected' : '' ?>>
                                        Perempuan</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Jumlah Lebar Gigi 32, 31, 41, 42 (mm)
                                    <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control" name="moyers_32_31_41_42_width"
                                        id="moyers_32_31_41_42_width" step="0.01" min="0"
                                        value="<?= !empty($moyers32_31_41_42_width) ? $moyers32_31_41_42_width : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                                <small class="form-text text-muted">Lebar keempat insisif mandibula</small>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-12">
                            <h6>Ruang yang Tersedia (Available Space)</h6>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Maxillary Left (mm) <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control moyers-available"
                                        name="moyers_max_left_available" id="moyers_max_left_available" step="0.01"
                                        min="0"
                                        value="<?= !empty($spaceAnalysis['moyers_max_left_available']) ? $spaceAnalysis['moyers_max_left_available'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Maxillary Right (mm) <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control moyers-available"
                                        name="moyers_max_right_available" id="moyers_max_right_available" step="0.01"
                                        min="0"
                                        value="<?= !empty($spaceAnalysis['moyers_max_right_available']) ? $spaceAnalysis['moyers_max_right_available'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Mandibular Left (mm) <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control moyers-available"
                                        name="moyers_mand_left_available" id="moyers_mand_left_available" step="0.01"
                                        min="0"
                                        value="<?= !empty($spaceAnalysis['moyers_mand_left_available']) ? $spaceAnalysis['moyers_mand_left_available'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Mandibular Right (mm) <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control moyers-available"
                                        name="moyers_mand_right_available" id="moyers_mand_right_available" step="0.01"
                                        min="0"
                                        value="<?= !empty($spaceAnalysis['moyers_mand_right_available']) ? $spaceAnalysis['moyers_mand_right_available'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-12">
                            <h6>Ruang yang Dibutuhkan (Required Space)</h6>
                            <p class="text-muted">Berdasarkan tabel Moyers dengan probabilitas 75%</p>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Maxillary Left (mm)</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" name="moyers_max_left_required"
                                        id="moyers_max_left_required" step="0.01" min="0" readonly
                                        value="<?= !empty($spaceAnalysis['moyers_max_left_required']) ? $spaceAnalysis['moyers_max_left_required'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Maxillary Right (mm)</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" name="moyers_max_right_required"
                                        id="moyers_max_right_required" step="0.01" min="0" readonly
                                        value="<?= !empty($spaceAnalysis['moyers_max_right_required']) ? $spaceAnalysis['moyers_max_right_required'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Mandibular Left (mm)</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" name="moyers_mand_left_required"
                                        id="moyers_mand_left_required" step="0.01" min="0" readonly
                                        value="<?= !empty($spaceAnalysis['moyers_mand_left_required']) ? $spaceAnalysis['moyers_mand_left_required'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Mandibular Right (mm)</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" name="moyers_mand_right_required"
                                        id="moyers_mand_right_required" step="0.01" min="0" readonly
                                        value="<?= !empty($spaceAnalysis['moyers_mand_right_required']) ? $spaceAnalysis['moyers_mand_right_required'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-12">
                            <h6>Ketersediaan Ruang (Space Availability)</h6>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Region</th>
                                    <th>Available Space (mm)</th>
                                    <th>Required Space (mm)</th>
                                    <th>Difference (mm)</th>
                                    <th>Assessment</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Maxillary Left</td>
                                    <td id="moyers_max_left_available_display">
                                        <?= !empty($spaceAnalysis['moyers_max_left_available']) ? $spaceAnalysis['moyers_max_left_available'] : '-' ?>
                                    </td>
                                    <td id="moyers_max_left_required_display">
                                        <?= !empty($spaceAnalysis['moyers_max_left_required']) ? $spaceAnalysis['moyers_max_left_required'] : '-' ?>
                                    </td>
                                    <td id="moyers_max_left_diff_display">
                                        <?php
                                        if (!empty($spaceAnalysis['moyers_max_left_available']) && !empty($spaceAnalysis['moyers_max_left_required'])) {
                                            echo number_format($spaceAnalysis['moyers_max_left_available'] - $spaceAnalysis['moyers_max_left_required'], 2);
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                    <td id="moyers_max_left_assessment_display">
                                        <?php
                                        if (!empty($spaceAnalysis['moyers_max_left_available']) && !empty($spaceAnalysis['moyers_max_left_required'])) {
                                            $diff = $spaceAnalysis['moyers_max_left_available'] - $spaceAnalysis['moyers_max_left_required'];
                                            if ($diff >= 0) {
                                                echo '<span class="text-success">Cukup Ruang</span>';
                                            } else {
                                                echo '<span class="text-danger">Kekurangan Ruang</span>';
                                            }
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Maxillary Right</td>
                                    <td id="moyers_max_right_available_display">
                                        <?= !empty($spaceAnalysis['moyers_max_right_available']) ? $spaceAnalysis['moyers_max_right_available'] : '-' ?>
                                    </td>
                                    <td id="moyers_max_right_required_display">
                                        <?= !empty($spaceAnalysis['moyers_max_right_required']) ? $spaceAnalysis['moyers_max_right_required'] : '-' ?>
                                    </td>
                                    <td id="moyers_max_right_diff_display">
                                        <?php
                                        if (!empty($spaceAnalysis['moyers_max_right_available']) && !empty($spaceAnalysis['moyers_max_right_required'])) {
                                            echo number_format($spaceAnalysis['moyers_max_right_available'] - $spaceAnalysis['moyers_max_right_required'], 2);
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                    <td id="moyers_max_right_assessment_display">
                                        <?php
                                        if (!empty($spaceAnalysis['moyers_max_right_available']) && !empty($spaceAnalysis['moyers_max_right_required'])) {
                                            $diff = $spaceAnalysis['moyers_max_right_available'] - $spaceAnalysis['moyers_max_right_required'];
                                            if ($diff >= 0) {
                                                echo '<span class="text-success">Cukup Ruang</span>';
                                            } else {
                                                echo '<span class="text-danger">Kekurangan Ruang</span>';
                                            }
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Mandibular Left</td>
                                    <td id="moyers_mand_left_available_display">
                                        <?= !empty($spaceAnalysis['moyers_mand_left_available']) ? $spaceAnalysis['moyers_mand_left_available'] : '-' ?>
                                    </td>
                                    <td id="moyers_mand_left_required_display">
                                        <?= !empty($spaceAnalysis['moyers_mand_left_required']) ? $spaceAnalysis['moyers_mand_left_required'] : '-' ?>
                                    </td>
                                    <td id="moyers_mand_left_diff_display">
                                        <?php
                                        if (!empty($spaceAnalysis['moyers_mand_left_available']) && !empty($spaceAnalysis['moyers_mand_left_required'])) {
                                            echo number_format($spaceAnalysis['moyers_mand_left_available'] - $spaceAnalysis['moyers_mand_left_required'], 2);
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                    <td id="moyers_mand_left_assessment_display">
                                        <?php
                                        if (!empty($spaceAnalysis['moyers_mand_left_available']) && !empty($spaceAnalysis['moyers_mand_left_required'])) {
                                            $diff = $spaceAnalysis['moyers_mand_left_available'] - $spaceAnalysis['moyers_mand_left_required'];
                                            if ($diff >= 0) {
                                                echo '<span class="text-success">Cukup Ruang</span>';
                                            } else {
                                                echo '<span class="text-danger">Kekurangan Ruang</span>';
                                            }
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Mandibular Right</td>
                                    <td id="moyers_mand_right_available_display">
                                        <?= !empty($spaceAnalysis['moyers_mand_right_available']) ? $spaceAnalysis['moyers_mand_right_available'] : '-' ?>
                                    </td>
                                    <td id="moyers_mand_right_required_display">
                                        <?= !empty($spaceAnalysis['moyers_mand_right_required']) ? $spaceAnalysis['moyers_mand_right_required'] : '-' ?>
                                    </td>
                                    <td id="moyers_mand_right_diff_display">
                                        <?php
                                        if (!empty($spaceAnalysis['moyers_mand_right_available']) && !empty($spaceAnalysis['moyers_mand_right_required'])) {
                                            echo number_format($spaceAnalysis['moyers_mand_right_available'] - $spaceAnalysis['moyers_mand_right_required'], 2);
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                    <td id="moyers_mand_right_assessment_display">
                                        <?php
                                        if (!empty($spaceAnalysis['moyers_mand_right_available']) && !empty($spaceAnalysis['moyers_mand_right_required'])) {
                                            $diff = $spaceAnalysis['moyers_mand_right_available'] - $spaceAnalysis['moyers_mand_right_required'];
                                            if ($diff >= 0) {
                                                echo '<span class="text-success">Cukup Ruang</span>';
                                            } else {
                                                echo '<span class="text-danger">Kekurangan Ruang</span>';
                                            }
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Kesling Analysis Tab -->
                <div class="tab-pane fade" id="kesling" role="tabpanel" aria-labelledby="kesling-tab">
                    <h5 class="card-title">Analisis Kesling</h5>

                    <div class="row mb-4">
                        <div class="col-12">
                            <h6>Ruang yang Dibutuhkan (Required Space)</h6>
                            <p class="text-muted">Jumlah lebar gigi dari premolar kedua hingga insisif sentral untuk
                                setiap kuadran</p>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Maxillary Left (mm) <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control kesling-required"
                                        name="kesling_max_left_required" id="kesling_max_left_required" step="0.01"
                                        min="0"
                                        value="<?= !empty($spaceAnalysis['kesling_max_left_required']) ? $spaceAnalysis['kesling_max_left_required'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Maxillary Right (mm) <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control kesling-required"
                                        name="kesling_max_right_required" id="kesling_max_right_required" step="0.01"
                                        min="0"
                                        value="<?= !empty($spaceAnalysis['kesling_max_right_required']) ? $spaceAnalysis['kesling_max_right_required'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Mandibular Left (mm) <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control kesling-required"
                                        name="kesling_mand_left_required" id="kesling_mand_left_required" step="0.01"
                                        min="0"
                                        value="<?= !empty($spaceAnalysis['kesling_mand_left_required']) ? $spaceAnalysis['kesling_mand_left_required'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Mandibular Right (mm) <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control kesling-required"
                                        name="kesling_mand_right_required" id="kesling_mand_right_required" step="0.01"
                                        min="0"
                                        value="<?= !empty($spaceAnalysis['kesling_mand_right_required']) ? $spaceAnalysis['kesling_mand_right_required'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-12">
                            <h6>Ruang yang Tersedia (Available Space)</h6>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Maxillary Left (mm) <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control kesling-available"
                                        name="kesling_max_left_available" id="kesling_max_left_available" step="0.01"
                                        min="0"
                                        value="<?= !empty($spaceAnalysis['kesling_max_left_available']) ? $spaceAnalysis['kesling_max_left_available'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Maxillary Right (mm) <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control kesling-available"
                                        name="kesling_max_right_available" id="kesling_max_right_available" step="0.01"
                                        min="0"
                                        value="<?= !empty($spaceAnalysis['kesling_max_right_available']) ? $spaceAnalysis['kesling_max_right_available'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Mandibular Left (mm) <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control kesling-available"
                                        name="kesling_mand_left_available" id="kesling_mand_left_available" step="0.01"
                                        min="0"
                                        value="<?= !empty($spaceAnalysis['kesling_mand_left_available']) ? $spaceAnalysis['kesling_mand_left_available'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Mandibular Right (mm) <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control kesling-available"
                                        name="kesling_mand_right_available" id="kesling_mand_right_available"
                                        step="0.01" min="0"
                                        value="<?= !empty($spaceAnalysis['kesling_mand_right_available']) ? $spaceAnalysis['kesling_mand_right_available'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-12">
                            <h6>Ketersediaan Ruang (Space Availability)</h6>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Region</th>
                                    <th>Available Space (mm)</th>
                                    <th>Required Space (mm)</th>
                                    <th>Difference (mm)</th>
                                    <th>Assessment</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Maxillary Left</td>
                                    <td id="kesling_max_left_available_display">
                                        <?= !empty($spaceAnalysis['kesling_max_left_available']) ? $spaceAnalysis['kesling_max_left_available'] : '-' ?>
                                    </td>
                                    <td id="kesling_max_left_required_display">
                                        <?= !empty($spaceAnalysis['kesling_max_left_required']) ? $spaceAnalysis['kesling_max_left_required'] : '-' ?>
                                    </td>
                                    <td id="kesling_max_left_diff_display">
                                        <?php
                                        if (!empty($spaceAnalysis['kesling_max_left_available']) && !empty($spaceAnalysis['kesling_max_left_required'])) {
                                            echo number_format($spaceAnalysis['kesling_max_left_available'] - $spaceAnalysis['kesling_max_left_required'], 2);
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                    <td id="kesling_max_left_assessment_display">
                                        <?php
                                        if (!empty($spaceAnalysis['kesling_max_left_available']) && !empty($spaceAnalysis['kesling_max_left_required'])) {
                                            $diff = $spaceAnalysis['kesling_max_left_available'] - $spaceAnalysis['kesling_max_left_required'];
                                            if ($diff >= 0) {
                                                echo '<span class="text-success">Cukup Ruang</span>';
                                            } else {
                                                echo '<span class="text-danger">Kekurangan Ruang</span>';
                                            }
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Maxillary Right</td>
                                    <td id="kesling_max_right_available_display">
                                        <?= !empty($spaceAnalysis['kesling_max_right_available']) ? $spaceAnalysis['kesling_max_right_available'] : '-' ?>
                                    </td>
                                    <td id="kesling_max_right_required_display">
                                        <?= !empty($spaceAnalysis['kesling_max_right_required']) ? $spaceAnalysis['kesling_max_right_required'] : '-' ?>
                                    </td>
                                    <td id="kesling_max_right_diff_display">
                                        <?php
                                        if (!empty($spaceAnalysis['kesling_max_right_available']) && !empty($spaceAnalysis['kesling_max_right_required'])) {
                                            echo number_format($spaceAnalysis['kesling_max_right_available'] - $spaceAnalysis['kesling_max_right_required'], 2);
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                    <td id="kesling_max_right_assessment_display">
                                        <?php
                                        if (!empty($spaceAnalysis['kesling_max_right_available']) && !empty($spaceAnalysis['kesling_max_right_required'])) {
                                            $diff = $spaceAnalysis['kesling_max_right_available'] - $spaceAnalysis['kesling_max_right_required'];
                                            if ($diff >= 0) {
                                                echo '<span class="text-success">Cukup Ruang</span>';
                                            } else {
                                                echo '<span class="text-danger">Kekurangan Ruang</span>';
                                            }
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Mandibular Left</td>
                                    <td id="kesling_mand_left_available_display">
                                        <?= !empty($spaceAnalysis['kesling_mand_left_available']) ? $spaceAnalysis['kesling_mand_left_available'] : '-' ?>
                                    </td>
                                    <td id="kesling_mand_left_required_display">
                                        <?= !empty($spaceAnalysis['kesling_mand_left_required']) ? $spaceAnalysis['kesling_mand_left_required'] : '-' ?>
                                    </td>
                                    <td id="kesling_mand_left_diff_display">
                                        <?php
                                        if (!empty($spaceAnalysis['kesling_mand_left_available']) && !empty($spaceAnalysis['kesling_mand_left_required'])) {
                                            echo number_format($spaceAnalysis['kesling_mand_left_available'] - $spaceAnalysis['kesling_mand_left_required'], 2);
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                    <td id="kesling_mand_left_assessment_display">
                                        <?php
                                        if (!empty($spaceAnalysis['kesling_mand_left_available']) && !empty($spaceAnalysis['kesling_mand_left_required'])) {
                                            $diff = $spaceAnalysis['kesling_mand_left_available'] - $spaceAnalysis['kesling_mand_left_required'];
                                            if ($diff >= 0) {
                                                echo '<span class="text-success">Cukup Ruang</span>';
                                            } else {
                                                echo '<span class="text-danger">Kekurangan Ruang</span>';
                                            }
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Mandibular Right</td>
                                    <td id="kesling_mand_right_available_display">
                                        <?= !empty($spaceAnalysis['kesling_mand_right_available']) ? $spaceAnalysis['kesling_mand_right_available'] : '-' ?>
                                    </td>
                                    <td id="kesling_mand_right_required_display">
                                        <?= !empty($spaceAnalysis['kesling_mand_right_required']) ? $spaceAnalysis['kesling_mand_right_required'] : '-' ?>
                                    </td>
                                    <td id="kesling_mand_right_diff_display">
                                        <?php
                                        if (!empty($spaceAnalysis['kesling_mand_right_available']) && !empty($spaceAnalysis['kesling_mand_right_required'])) {
                                            echo number_format($spaceAnalysis['kesling_mand_right_available'] - $spaceAnalysis['kesling_mand_right_required'], 2);
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                    <td id="kesling_mand_right_assessment_display">
                                        <?php
                                        if (!empty($spaceAnalysis['kesling_mand_right_available']) && !empty($spaceAnalysis['kesling_mand_right_required'])) {
                                            $diff = $spaceAnalysis['kesling_mand_right_available'] - $spaceAnalysis['kesling_mand_right_required'];
                                            if ($diff >= 0) {
                                                echo '<span class="text-success">Cukup Ruang</span>';
                                            } else {
                                                echo '<span class="text-danger">Kekurangan Ruang</span>';
                                            }
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Lundstrum Analysis Tab -->
                <div class="tab-pane fade" id="lundstrum" role="tabpanel" aria-labelledby="lundstrum-tab">
                    <h5 class="card-title">Analisis Lundstrum (ALD)</h5>

                    <!-- Maxilla Section -->
                    <div class="card mb-4">
                        <div class="card-header bg-primary text-white">
                            <h6 class="mb-0">Maxilla</h6>
                        </div>
                        <div class="card-body">
                            <!-- S1 (16-15) -->

                            <!-- Required Space Row -->
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <div class="text-center mb-2"><strong>Required Space (mm)</strong></div>
                                </div>
                                <div class="col-md-10">
                                    <div class="row">
                                        <!-- S1 (16-15) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label>S1 (16-15)
                                                    <?php echo getRequiredFieldMarker(); ?></label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-required"
                                                        name="lundstrum_max_s1_required" id="lundstrum_max_s1_required"
                                                        step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_max_s1_required']) ? $spaceAnalysis['lundstrum_max_s1_required'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S2 (14-13) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label>S2 (14-13)
                                                    <?php echo getRequiredFieldMarker(); ?></label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-required"
                                                        name="lundstrum_max_s2_required" id="lundstrum_max_s2_required"
                                                        step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_max_s2_required']) ? $spaceAnalysis['lundstrum_max_s2_required'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S3 (12-11) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label>S3 (12-11)
                                                    <?php echo getRequiredFieldMarker(); ?></label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-required"
                                                        name="lundstrum_max_s3_required" id="lundstrum_max_s3_required"
                                                        step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_max_s3_required']) ? $spaceAnalysis['lundstrum_max_s3_required'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S4 (21-22) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label>S4 (21-22)
                                                    <?php echo getRequiredFieldMarker(); ?></label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-required"
                                                        name="lundstrum_max_s4_required" id="lundstrum_max_s4_required"
                                                        step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_max_s4_required']) ? $spaceAnalysis['lundstrum_max_s4_required'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S5 (23-24) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label>S5 (23-24)
                                                    <?php echo getRequiredFieldMarker(); ?></label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-required"
                                                        name="lundstrum_max_s5_required" id="lundstrum_max_s5_required"
                                                        step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_max_s5_required']) ? $spaceAnalysis['lundstrum_max_s5_required'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S6 (25-26) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label>S6 (25-26)
                                                    <?php echo getRequiredFieldMarker(); ?></label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-required"
                                                        name="lundstrum_max_s6_required" id="lundstrum_max_s6_required"
                                                        step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_max_s6_required']) ? $spaceAnalysis['lundstrum_max_s6_required'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Available Space Row -->
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="text-center mb-2"><strong>Available Space (mm)</strong></div>
                                </div>
                                <div class="col-md-10">
                                    <div class="row">
                                        <!-- S1 (16-15) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-available"
                                                        name="lundstrum_max_s1_available"
                                                        id="lundstrum_max_s1_available" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_max_s1_available']) ? $spaceAnalysis['lundstrum_max_s1_available'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S2 (14-13) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-available"
                                                        name="lundstrum_max_s2_available"
                                                        id="lundstrum_max_s2_available" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_max_s2_available']) ? $spaceAnalysis['lundstrum_max_s2_available'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S3 (12-11) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-available"
                                                        name="lundstrum_max_s3_available"
                                                        id="lundstrum_max_s3_available" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_max_s3_available']) ? $spaceAnalysis['lundstrum_max_s3_available'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S4 (21-22) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-available"
                                                        name="lundstrum_max_s4_available"
                                                        id="lundstrum_max_s4_available" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_max_s4_available']) ? $spaceAnalysis['lundstrum_max_s4_available'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S5 (23-24) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-available"
                                                        name="lundstrum_max_s5_available"
                                                        id="lundstrum_max_s5_available" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_max_s5_available']) ? $spaceAnalysis['lundstrum_max_s5_available'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S6 (25-26) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-available"
                                                        name="lundstrum_max_s6_available"
                                                        id="lundstrum_max_s6_available" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_max_s6_available']) ? $spaceAnalysis['lundstrum_max_s6_available'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Summary Table for Maxilla -->
                    <div class="table-responsive mb-4">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Parameter</th>
                                    <th>S1 (16-15)</th>
                                    <th>S2 (14-13)</th>
                                    <th>S3 (12-11)</th>
                                    <th>S4 (21-22)</th>
                                    <th>S5 (23-24)</th>
                                    <th>S6 (25-26)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><strong>Available Space (mm)</strong></td>
                                    <td id="lundstrum_max_s1_available_display">
                                        <?= !empty($spaceAnalysis['lundstrum_max_s1_available']) ? $spaceAnalysis['lundstrum_max_s1_available'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_max_s2_available_display">
                                        <?= !empty($spaceAnalysis['lundstrum_max_s2_available']) ? $spaceAnalysis['lundstrum_max_s2_available'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_max_s3_available_display">
                                        <?= !empty($spaceAnalysis['lundstrum_max_s3_available']) ? $spaceAnalysis['lundstrum_max_s3_available'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_max_s4_available_display">
                                        <?= !empty($spaceAnalysis['lundstrum_max_s4_available']) ? $spaceAnalysis['lundstrum_max_s4_available'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_max_s5_available_display">
                                        <?= !empty($spaceAnalysis['lundstrum_max_s5_available']) ? $spaceAnalysis['lundstrum_max_s5_available'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_max_s6_available_display">
                                        <?= !empty($spaceAnalysis['lundstrum_max_s6_available']) ? $spaceAnalysis['lundstrum_max_s6_available'] : '-' ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Required Space (mm)</strong></td>
                                    <td id="lundstrum_max_s1_required_display">
                                        <?= !empty($spaceAnalysis['lundstrum_max_s1_required']) ? $spaceAnalysis['lundstrum_max_s1_required'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_max_s2_required_display">
                                        <?= !empty($spaceAnalysis['lundstrum_max_s2_required']) ? $spaceAnalysis['lundstrum_max_s2_required'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_max_s3_required_display">
                                        <?= !empty($spaceAnalysis['lundstrum_max_s3_required']) ? $spaceAnalysis['lundstrum_max_s3_required'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_max_s4_required_display">
                                        <?= !empty($spaceAnalysis['lundstrum_max_s4_required']) ? $spaceAnalysis['lundstrum_max_s4_required'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_max_s5_required_display">
                                        <?= !empty($spaceAnalysis['lundstrum_max_s5_required']) ? $spaceAnalysis['lundstrum_max_s5_required'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_max_s6_required_display">
                                        <?= !empty($spaceAnalysis['lundstrum_max_s6_required']) ? $spaceAnalysis['lundstrum_max_s6_required'] : '-' ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Difference (mm)</strong></td>
                                    <td id="lundstrum_max_s1_diff_display">-</td>
                                    <td id="lundstrum_max_s2_diff_display">-</td>
                                    <td id="lundstrum_max_s3_diff_display">-</td>
                                    <td id="lundstrum_max_s4_diff_display">-</td>
                                    <td id="lundstrum_max_s5_diff_display">-</td>
                                    <td id="lundstrum_max_s6_diff_display">-</td>
                                </tr>
                                <tr>
                                    <td><strong>Assessment</strong></td>
                                    <td id="lundstrum_max_s1_assessment_display">-</td>
                                    <td id="lundstrum_max_s2_assessment_display">-</td>
                                    <td id="lundstrum_max_s3_assessment_display">-</td>
                                    <td id="lundstrum_max_s4_assessment_display">-</td>
                                    <td id="lundstrum_max_s5_assessment_display">-</td>
                                    <td id="lundstrum_max_s6_assessment_display">-</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- Mandibula Section -->
                    <div class="card mb-4">
                        <div class="card-header bg-primary text-white">
                            <h6 class="mb-0">Mandibula</h6>
                        </div>
                        <div class="card-body">
                            <!-- Required Space Row -->
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <div class="text-center mb-2"><strong>Required Space (mm)</strong></div>
                                </div>
                                <div class="col-md-10">
                                    <div class="row">
                                        <!-- S1 (45-46) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label>S1 (45-46)
                                                    <?php echo getRequiredFieldMarker(); ?></label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-required"
                                                        name="lundstrum_mand_s1_required"
                                                        id="lundstrum_mand_s1_required" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_mand_s1_required']) ? $spaceAnalysis['lundstrum_mand_s1_required'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S2 (43-44) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label>S2 (43-44)
                                                    <?php echo getRequiredFieldMarker(); ?></label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-required"
                                                        name="lundstrum_mand_s2_required"
                                                        id="lundstrum_mand_s2_required" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_mand_s2_required']) ? $spaceAnalysis['lundstrum_mand_s2_required'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S3 (41-42) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label>S3 (41-42)
                                                    <?php echo getRequiredFieldMarker(); ?></label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-required"
                                                        name="lundstrum_mand_s3_required"
                                                        id="lundstrum_mand_s3_required" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_mand_s3_required']) ? $spaceAnalysis['lundstrum_mand_s3_required'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S4 (31-32) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label>S4 (31-32)
                                                    <?php echo getRequiredFieldMarker(); ?></label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-required"
                                                        name="lundstrum_mand_s4_required"
                                                        id="lundstrum_mand_s4_required" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_mand_s4_required']) ? $spaceAnalysis['lundstrum_mand_s4_required'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S5 (33-34) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label>S5 (33-34)
                                                    <?php echo getRequiredFieldMarker(); ?></label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-required"
                                                        name="lundstrum_mand_s5_required"
                                                        id="lundstrum_mand_s5_required" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_mand_s5_required']) ? $spaceAnalysis['lundstrum_mand_s5_required'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S6 (35-36) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label>S6 (35-36)
                                                    <?php echo getRequiredFieldMarker(); ?></label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-required"
                                                        name="lundstrum_mand_s6_required"
                                                        id="lundstrum_mand_s6_required" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_mand_s6_required']) ? $spaceAnalysis['lundstrum_mand_s6_required'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Available Space Row -->
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="text-center mb-2"><strong>Available Space (mm)</strong></div>
                                </div>
                                <div class="col-md-10">
                                    <div class="row">
                                        <!-- S1 (45-46) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-available"
                                                        name="lundstrum_mand_s1_available"
                                                        id="lundstrum_mand_s1_available" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_mand_s1_available']) ? $spaceAnalysis['lundstrum_mand_s1_available'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S2 (43-44) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-available"
                                                        name="lundstrum_mand_s2_available"
                                                        id="lundstrum_mand_s2_available" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_mand_s2_available']) ? $spaceAnalysis['lundstrum_mand_s2_available'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S3 (41-42) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-available"
                                                        name="lundstrum_mand_s3_available"
                                                        id="lundstrum_mand_s3_available" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_mand_s3_available']) ? $spaceAnalysis['lundstrum_mand_s3_available'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S4 (31-32) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-available"
                                                        name="lundstrum_mand_s4_available"
                                                        id="lundstrum_mand_s4_available" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_mand_s4_available']) ? $spaceAnalysis['lundstrum_mand_s4_available'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S5 (33-34) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-available"
                                                        name="lundstrum_mand_s5_available"
                                                        id="lundstrum_mand_s5_available" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_mand_s5_available']) ? $spaceAnalysis['lundstrum_mand_s5_available'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- S6 (35-36) -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <input type="number" class="form-control lundstrum-available"
                                                        name="lundstrum_mand_s6_available"
                                                        id="lundstrum_mand_s6_available" step="0.01" min="0"
                                                        value="<?= !empty($spaceAnalysis['lundstrum_mand_s6_available']) ? $spaceAnalysis['lundstrum_mand_s6_available'] : '' ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">mm</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Summary Table for Mandibula -->
                    <div class="table-responsive mb-4">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Parameter</th>
                                    <th>S1 (45-46)</th>
                                    <th>S2 (43-44)</th>
                                    <th>S3 (41-42)</th>
                                    <th>S4 (31-32)</th>
                                    <th>S5 (33-34)</th>
                                    <th>S6 (35-36)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><strong>Available Space (mm)</strong></td>
                                    <td id="lundstrum_mand_s1_available_display">
                                        <?= !empty($spaceAnalysis['lundstrum_mand_s1_available']) ? $spaceAnalysis['lundstrum_mand_s1_available'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_mand_s2_available_display">
                                        <?= !empty($spaceAnalysis['lundstrum_mand_s2_available']) ? $spaceAnalysis['lundstrum_mand_s2_available'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_mand_s3_available_display">
                                        <?= !empty($spaceAnalysis['lundstrum_mand_s3_available']) ? $spaceAnalysis['lundstrum_mand_s3_available'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_mand_s4_available_display">
                                        <?= !empty($spaceAnalysis['lundstrum_mand_s4_available']) ? $spaceAnalysis['lundstrum_mand_s4_available'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_mand_s5_available_display">
                                        <?= !empty($spaceAnalysis['lundstrum_mand_s5_available']) ? $spaceAnalysis['lundstrum_mand_s5_available'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_mand_s6_available_display">
                                        <?= !empty($spaceAnalysis['lundstrum_mand_s6_available']) ? $spaceAnalysis['lundstrum_mand_s6_available'] : '-' ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Required Space (mm)</strong></td>
                                    <td id="lundstrum_mand_s1_required_display">
                                        <?= !empty($spaceAnalysis['lundstrum_mand_s1_required']) ? $spaceAnalysis['lundstrum_mand_s1_required'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_mand_s2_required_display">
                                        <?= !empty($spaceAnalysis['lundstrum_mand_s2_required']) ? $spaceAnalysis['lundstrum_mand_s2_required'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_mand_s3_required_display">
                                        <?= !empty($spaceAnalysis['lundstrum_mand_s3_required']) ? $spaceAnalysis['lundstrum_mand_s3_required'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_mand_s4_required_display">
                                        <?= !empty($spaceAnalysis['lundstrum_mand_s4_required']) ? $spaceAnalysis['lundstrum_mand_s4_required'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_mand_s5_required_display">
                                        <?= !empty($spaceAnalysis['lundstrum_mand_s5_required']) ? $spaceAnalysis['lundstrum_mand_s5_required'] : '-' ?>
                                    </td>
                                    <td id="lundstrum_mand_s6_required_display">
                                        <?= !empty($spaceAnalysis['lundstrum_mand_s6_required']) ? $spaceAnalysis['lundstrum_mand_s6_required'] : '-' ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Difference (mm)</strong></td>
                                    <td id="lundstrum_mand_s1_diff_display">-</td>
                                    <td id="lundstrum_mand_s2_diff_display">-</td>
                                    <td id="lundstrum_mand_s3_diff_display">-</td>
                                    <td id="lundstrum_mand_s4_diff_display">-</td>
                                    <td id="lundstrum_mand_s5_diff_display">-</td>
                                    <td id="lundstrum_mand_s6_diff_display">-</td>
                                </tr>
                                <tr>
                                    <td><strong>Assessment</strong></td>
                                    <td id="lundstrum_mand_s1_assessment_display">-</td>
                                    <td id="lundstrum_mand_s2_assessment_display">-</td>
                                    <td id="lundstrum_mand_s3_assessment_display">-</td>
                                    <td id="lundstrum_mand_s4_assessment_display">-</td>
                                    <td id="lundstrum_mand_s5_assessment_display">-</td>
                                    <td id="lundstrum_mand_s6_assessment_display">-</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Ponts tab content -->
                <div class="tab-pane fade" id="ponts" role="tabpanel" aria-labelledby="ponts-tab">
                    <h5 class="card-title">Analisis Ponts</h5>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Measured Premolar Value (MPV)
                                    <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control" name="ponts_mpv" id="ponts_mpv"
                                        step="0.01" min="0"
                                        value="<?= !empty($spaceAnalysis['ponts_mpv']) ? $spaceAnalysis['ponts_mpv'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                                <small class="form-text text-muted">Jarak antar premolar</small>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Measured Molar Value (MMV)
                                    <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control" name="ponts_mmv" id="ponts_mmv"
                                        step="0.01" min="0"
                                        value="<?= !empty($spaceAnalysis['ponts_mmv']) ? $spaceAnalysis['ponts_mmv'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                                <small class="form-text text-muted">Jarak antar molar</small>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Sum of Incisors (S.I)
                                    <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control" name="ponts_si" id="ponts_si" step="0.01"
                                        min="0"
                                        value="<?= !empty($spaceAnalysis['ponts_si']) ? $spaceAnalysis['ponts_si'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                                <small class="form-text text-muted">Jumlah lebar 4 insisif
                                    maksila</small>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-12">
                            <h6>Hasil Perhitungan</h6>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Parameter</th>
                                    <th>Formula</th>
                                    <th>Nilai</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Calculated Premolar Value (CPV)</td>
                                    <td>SI/80*100</td>
                                    <td id="ponts_cpv_display">
                                        <?php
                                            if (!empty($spaceAnalysis['ponts_si'])) {
                                                $cpv = ($spaceAnalysis['ponts_si'] / 80) * 100;
                                                echo number_format($cpv, 2);
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Calculated Molar Value (CMV)</td>
                                    <td>SI/64*100</td>
                                    <td id="ponts_cmv_display">
                                        <?php
                                            if (!empty($spaceAnalysis['ponts_si'])) {
                                                $cmv = ($spaceAnalysis['ponts_si'] / 64) * 100;
                                                echo number_format($cmv, 2);
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Premolar Comparison</td>
                                    <td>MPV vs CPV</td>
                                    <td id="ponts_premolar_comparison_display">
                                        <?php
                                            if (!empty($spaceAnalysis['ponts_si']) && !empty($spaceAnalysis['ponts_mpv'])) {
                                                $cpv = ($spaceAnalysis['ponts_si'] / 80) * 100;
                                                $mpv = $spaceAnalysis['ponts_mpv'];
                                                $diff = $mpv - $cpv;
                                                
                                                if (abs($diff) <= 1) {
                                                    echo '<span class="text-success">Normal</span>';
                                                } elseif ($diff < -1) {
                                                    echo '<span class="text-danger">Konstriksi</span>';
                                                } else {
                                                    echo '<span class="text-warning">Ekspansi</span>';
                                                }
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Molar Comparison</td>
                                    <td>MMV vs CMV</td>
                                    <td id="ponts_molar_comparison_display">
                                        <?php
                                            if (!empty($spaceAnalysis['ponts_si']) && !empty($spaceAnalysis['ponts_mmv'])) {
                                                $cmv = ($spaceAnalysis['ponts_si'] / 64) * 100;
                                                $mmv = $spaceAnalysis['ponts_mmv'];
                                                $diff = $mmv - $cmv;
                                                
                                                if (abs($diff) <= 1) {
                                                    echo '<span class="text-success">Normal</span>';
                                                } elseif ($diff < -1) {
                                                    echo '<span class="text-danger">Konstriksi</span>';
                                                } else {
                                                    echo '<span class="text-warning">Ekspansi</span>';
                                                }
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Howe tab content -->
                <div class="tab-pane fade" id="howe" role="tabpanel" aria-labelledby="howe-tab">
                    <h5 class="card-title">Analisis Howe</h5>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Premolar Basal Arc Width (PMBAW)
                                    <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control" name="howe_pmbaw" id="howe_pmbaw"
                                        step="0.01" min="0"
                                        value="<?= !empty($spaceAnalysis['howe_pmbaw']) ? $spaceAnalysis['howe_pmbaw'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                                <small class="form-text text-muted">Lebar lengkung basal
                                    premolar</small>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Total Tooth Material (TTM)
                                    <?php echo getRequiredFieldMarker(); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control" name="howe_ttm" id="howe_ttm" step="0.01"
                                        min="0"
                                        value="<?= !empty($spaceAnalysis['howe_ttm']) ? $spaceAnalysis['howe_ttm'] : '' ?>">
                                    <div class="input-group-append">
                                        <span class="input-group-text">mm</span>
                                    </div>
                                </div>
                                <small class="form-text text-muted">Jumlah lebar gigi maksila kecuali
                                    molar
                                    kedua</small>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-12">
                            <h6>Hasil Perhitungan</h6>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Parameter</th>
                                    <th>Formula</th>
                                    <th>Nilai</th>
                                    <th>Interpretasi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>PMBAW/TTM Ratio (%)</td>
                                    <td>PMBAW/TTM*100</td>
                                    <td id="howe_ratio_display">
                                        <?php
                                            if (!empty($spaceAnalysis['howe_pmbaw']) && !empty($spaceAnalysis['howe_ttm']) && $spaceAnalysis['howe_ttm'] != 0) {
                                                $ratio = ($spaceAnalysis['howe_pmbaw'] / $spaceAnalysis['howe_ttm']) * 100;
                                                echo number_format($ratio, 2);
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                    </td>
                                    <td id="howe_interpretation_display">
                                        <?php
                                            if (!empty($spaceAnalysis['howe_pmbaw']) && !empty($spaceAnalysis['howe_ttm']) && $spaceAnalysis['howe_ttm'] != 0) {
                                                $ratio = ($spaceAnalysis['howe_pmbaw'] / $spaceAnalysis['howe_ttm']) * 100;
                                                
                                                if ($ratio < 44) {
                                                    echo '<span class="text-danger">Ekstraksi</span>';
                                                } elseif ($ratio >= 44 && ratio <= 46) {
                                                } elseif ($ratio >= 44 && $ratio <= 46) {
                                                    echo '<span class="text-warning">Borderline</span>';
                                                } else {
                                                    echo '<span class="text-success">Non-Ekstraksi</span>';
                                                }
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Kesimpulan Analisis section (outside of tabs) -->
    <div class="card mt-4">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Kesimpulan Analisis Kebutuhan Ruang</h5>
        </div>
        <div class="card-body">
            <div class="form-group">
                <label>Kesimpulan Analisis Kebutuhan Ruang <?php echo getRequiredFieldMarker(); ?></label>
                <div class="selectgroup">
                    <label class="selectgroup-item">
                        <input type="radio" name="space_analysis_conclusion" value="Ekstraksi" class="selectgroup-input"
                            <?= $spaceAnalysisConclusion === 'Ekstraksi' ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Ekstraksi</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="radio" name="space_analysis_conclusion" value="Borderline"
                            class="selectgroup-input" <?= $spaceAnalysisConclusion === 'Borderline' ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Borderline</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="radio" name="space_analysis_conclusion" value="Non-Ekstraksi"
                            class="selectgroup-input"
                            <?= $spaceAnalysisConclusion === 'Non-Ekstraksi' ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Non-Ekstraksi</span>
                    </label>
                </div>
            </div>

            <!-- Metode Pencarian Ruang -->
            <div class="form-group mt-4">
                <label><strong>Metode Pencarian Ruang</strong></label>
                <div class="row">
                    <!-- Maxillary Right -->
                    <div class="col-md-6">
                        <div class="card mb-3">
                            <div class="card-header bg-light">
                                <h6 class="mb-0">Maxillary Right</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input space-method" type="checkbox"
                                            id="max_right_extraction" name="max_right_method[]" value="Ekstraksi"
                                            data-quadrant="max_right"
                                            <?= in_array('Ekstraksi', $maxRightSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="max_right_extraction">Ekstraksi</label>
                                    </div>

                                    <!-- Extraction options for Maxillary Right -->
                                    <div id="max_right_extraction_options" class="extraction-options ml-4 mt-2 mb-2"
                                        style="display: <?= in_array('Ekstraksi', $maxRightSpaceMethod ?? []) ? 'block' : 'none' ?>;">
                                        <label class="form-label">Pilih gigi yang akan diekstraksi:</label>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_right_extract_1" name="max_right_extract[]" value="1"
                                                        <?= in_array('1', $maxRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_right_extract_1">Gigi
                                                        1</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_right_extract_2" name="max_right_extract[]" value="2"
                                                        <?= in_array('2', $maxRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_right_extract_2">Gigi
                                                        2</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_right_extract_3" name="max_right_extract[]" value="3"
                                                        <?= in_array('3', $maxRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_right_extract_3">Gigi
                                                        3</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_right_extract_4" name="max_right_extract[]" value="4"
                                                        <?= in_array('4', $maxRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_right_extract_4">Gigi
                                                        4</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_right_extract_5" name="max_right_extract[]" value="5"
                                                        <?= in_array('5', $maxRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_right_extract_5">Gigi
                                                        5</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_right_extract_6" name="max_right_extract[]" value="6"
                                                        <?= in_array('6', $maxRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_right_extract_6">Gigi
                                                        6</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_right_extract_7" name="max_right_extract[]" value="7"
                                                        <?= in_array('7', $maxRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_right_extract_7">Gigi
                                                        7</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_right_extract_8" name="max_right_extract[]" value="8"
                                                        <?= in_array('8', $maxRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_right_extract_8">Gigi
                                                        8</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox"
                                                id="max_right_extract_supernumerary" name="max_right_extract[]"
                                                value="supernumerary"
                                                <?= in_array('supernumerary', $maxRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                            <label class="form-check-label" for="max_right_extract_supernumerary">Gigi
                                                Supernumerary</label>
                                        </div>
                                    </div>

                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="max_right_protraksi"
                                            name="max_right_method[]" value="Protraksi"
                                            <?= in_array('Protraksi', $maxRightSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="max_right_protraksi">Protraksi</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="max_right_slicing"
                                            name="max_right_method[]" value="Slicing"
                                            <?= in_array('Slicing', $maxRightSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="max_right_slicing">Slicing</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="max_right_distalisasi"
                                            name="max_right_method[]" value="Distalisasi Molar"
                                            <?= in_array('Distalisasi Molar', $maxRightSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="max_right_distalisasi">Distalisasi
                                            Molar</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="max_right_ekspansi"
                                            name="max_right_method[]" value="Ekspansi"
                                            <?= in_array('Ekspansi', $maxRightSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="max_right_ekspansi">Ekspansi</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Maxillary Left -->
                    <div class="col-md-6">
                        <div class="card mb-3">
                            <div class="card-header bg-light">
                                <h6 class="mb-0">Maxillary Left</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input space-method" type="checkbox"
                                            id="max_left_extraction" name="max_left_method[]" value="Ekstraksi"
                                            data-quadrant="max_left"
                                            <?= in_array('Ekstraksi', $maxLeftSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="max_left_extraction">Ekstraksi</label>
                                    </div>

                                    <!-- Extraction options for Maxillary Left -->
                                    <div id="max_left_extraction_options" class="extraction-options ml-4 mt-2 mb-2"
                                        style="display: <?= in_array('Ekstraksi', $maxLeftSpaceMethod ?? []) ? 'block' : 'none' ?>;">
                                        <label class="form-label">Pilih gigi yang akan diekstraksi:</label>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_left_extract_1" name="max_left_extract[]" value="1"
                                                        <?= in_array('1', $maxLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_left_extract_1">Gigi
                                                        1</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_left_extract_2" name="max_left_extract[]" value="2"
                                                        <?= in_array('2', $maxLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_left_extract_2">Gigi
                                                        2</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_left_extract_3" name="max_left_extract[]" value="3"
                                                        <?= in_array('3', $maxLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_left_extract_3">Gigi
                                                        3</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_left_extract_4" name="max_left_extract[]" value="4"
                                                        <?= in_array('4', $maxLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_left_extract_4">Gigi
                                                        4</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_left_extract_5" name="max_left_extract[]" value="5"
                                                        <?= in_array('5', $maxLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_left_extract_5">Gigi
                                                        5</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_left_extract_6" name="max_left_extract[]" value="6"
                                                        <?= in_array('6', $maxLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_left_extract_6">Gigi
                                                        6</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_left_extract_7" name="max_left_extract[]" value="7"
                                                        <?= in_array('7', $maxLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_left_extract_7">Gigi
                                                        7</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="max_left_extract_8" name="max_left_extract[]" value="8"
                                                        <?= in_array('8', $maxLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="max_left_extract_8">Gigi
                                                        8</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox"
                                                id="max_left_extract_supernumerary" name="max_left_extract[]"
                                                value="supernumerary"
                                                <?= in_array('supernumerary', $maxLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                            <label class="form-check-label" for="max_left_extract_supernumerary">Gigi
                                                Supernumerary</label>
                                        </div>
                                    </div>

                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="max_left_protraksi"
                                            name="max_left_method[]" value="Protraksi"
                                            <?= in_array('Protraksi', $maxLeftSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="max_left_protraksi">Protraksi</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="max_left_slicing"
                                            name="max_left_method[]" value="Slicing"
                                            <?= in_array('Slicing', $maxLeftSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="max_left_slicing">Slicing</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="max_left_distalisasi"
                                            name="max_left_method[]" value="Distalisasi Molar"
                                            <?= in_array('Distalisasi Molar', $maxLeftSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="max_left_distalisasi">Distalisasi
                                            Molar</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="max_left_ekspansi"
                                            name="max_left_method[]" value="Ekspansi"
                                            <?= in_array('Ekspansi', $maxLeftSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="max_left_ekspansi">Ekspansi</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Mandibular Right -->
                    <div class="col-md-6">
                        <div class="card mb-3">
                            <div class="card-header bg-light">
                                <h6 class="mb-0">Mandibular Right</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input space-method" type="checkbox"
                                            id="mand_right_extraction" name="mand_right_method[]" value="Ekstraksi"
                                            data-quadrant="mand_right"
                                            <?= in_array('Ekstraksi', $mandRightSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="mand_right_extraction">Ekstraksi</label>
                                    </div>

                                    <!-- Extraction options for Mandibular Right -->
                                    <div id="mand_right_extraction_options" class="extraction-options ml-4 mt-2 mb-2"
                                        style="display: <?= in_array('Ekstraksi', $mandRightSpaceMethod ?? []) ? 'block' : 'none' ?>;">
                                        <label class="form-label">Pilih gigi yang akan diekstraksi:</label>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_right_extract_1" name="mand_right_extract[]" value="1"
                                                        <?= in_array('1', $mandRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_right_extract_1">Gigi
                                                        1</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_right_extract_2" name="mand_right_extract[]" value="2"
                                                        <?= in_array('2', $mandRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_right_extract_2">Gigi
                                                        2</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_right_extract_3" name="mand_right_extract[]" value="3"
                                                        <?= in_array('3', $mandRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_right_extract_3">Gigi
                                                        3</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_right_extract_4" name="mand_right_extract[]" value="4"
                                                        <?= in_array('4', $mandRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_right_extract_4">Gigi
                                                        4</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_right_extract_5" name="mand_right_extract[]" value="5"
                                                        <?= in_array('5', $mandRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_right_extract_5">Gigi
                                                        5</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_right_extract_6" name="mand_right_extract[]" value="6"
                                                        <?= in_array('6', $mandRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_right_extract_6">Gigi
                                                        6</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_right_extract_7" name="mand_right_extract[]" value="7"
                                                        <?= in_array('7', $mandRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_right_extract_7">Gigi
                                                        7</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_right_extract_8" name="mand_right_extract[]" value="8"
                                                        <?= in_array('8', $mandRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_right_extract_8">Gigi
                                                        8</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox"
                                                id="mand_right_extract_supernumerary" name="mand_right_extract[]"
                                                value="supernumerary"
                                                <?= in_array('supernumerary', $mandRightExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                            <label class="form-check-label" for="mand_right_extract_supernumerary">Gigi
                                                Supernumerary</label>
                                        </div>
                                    </div>

                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="mand_right_protraksi"
                                            name="mand_right_method[]" value="Protraksi"
                                            <?= in_array('Protraksi', $mandRightSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="mand_right_protraksi">Protraksi</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="mand_right_slicing"
                                            name="mand_right_method[]" value="Slicing"
                                            <?= in_array('Slicing', $mandRightSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="mand_right_slicing">Slicing</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="mand_right_distalisasi"
                                            name="mand_right_method[]" value="Distalisasi Molar"
                                            <?= in_array('Distalisasi Molar', $mandRightSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="mand_right_distalisasi">Distalisasi
                                            Molar</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="mand_right_ekspansi"
                                            name="mand_right_method[]" value="Ekspansi"
                                            <?= in_array('Ekspansi', $mandRightSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="mand_right_ekspansi">Ekspansi</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Mandibular Left -->
                    <div class="col-md-6">
                        <div class="card mb-3">
                            <div class="card-header bg-light">
                                <h6 class="mb-0">Mandibular Left</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input space-method" type="checkbox"
                                            id="mand_left_extraction" name="mand_left_method[]" value="Ekstraksi"
                                            data-quadrant="mand_left"
                                            <?= in_array('Ekstraksi', $mandLeftSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="mand_left_extraction">Ekstraksi</label>
                                    </div>

                                    <!-- Extraction options for Mandibular Left -->
                                    <div id="mand_left_extraction_options" class="extraction-options ml-4 mt-2 mb-2"
                                        style="display: <?= in_array('Ekstraksi', $mandLeftSpaceMethod ?? []) ? 'block' : 'none' ?>;">
                                        <label class="form-label">Pilih gigi yang akan diekstraksi:</label>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_left_extract_1" name="mand_left_extract[]" value="1"
                                                        <?= in_array('1', $mandLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_left_extract_1">Gigi
                                                        1</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_left_extract_2" name="mand_left_extract[]" value="2"
                                                        <?= in_array('2', $mandLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_left_extract_2">Gigi
                                                        2</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_left_extract_3" name="mand_left_extract[]" value="3"
                                                        <?= in_array('3', $mandLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_left_extract_3">Gigi
                                                        3</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_left_extract_4" name="mand_left_extract[]" value="4"
                                                        <?= in_array('4', $mandLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_left_extract_4">Gigi
                                                        4</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_left_extract_5" name="mand_left_extract[]" value="5"
                                                        <?= in_array('5', $mandLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_left_extract_5">Gigi
                                                        5</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_left_extract_6" name="mand_left_extract[]" value="6"
                                                        <?= in_array('6', $mandLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_left_extract_6">Gigi
                                                        6</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_left_extract_7" name="mand_left_extract[]" value="7"
                                                        <?= in_array('7', $mandLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_left_extract_7">Gigi
                                                        7</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="mand_left_extract_8" name="mand_left_extract[]" value="8"
                                                        <?= in_array('8', $mandLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="mand_left_extract_8">Gigi
                                                        8</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox"
                                                id="mand_left_extract_supernumerary" name="mand_left_extract[]"
                                                value="supernumerary"
                                                <?= in_array('supernumerary', $mandLeftExtractionTeeth ?? []) ? 'checked' : '' ?>>
                                            <label class="form-check-label" for="mand_left_extract_supernumerary">Gigi
                                                Supernumerary</label>
                                        </div>
                                    </div>

                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="mand_left_protraksi"
                                            name="mand_left_method[]" value="Protraksi"
                                            <?= in_array('Protraksi', $mandLeftSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="mand_left_protraksi">Protraksi</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="mand_left_slicing"
                                            name="mand_left_method[]" value="Slicing"
                                            <?= in_array('Slicing', $mandLeftSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="mand_left_slicing">Slicing</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="mand_left_distalisasi"
                                            name="mand_left_method[]" value="Distalisasi Molar"
                                            <?= in_array('Distalisasi Molar', $mandLeftSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="mand_left_distalisasi">Distalisasi
                                            Molar</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="mand_left_ekspansi"
                                            name="mand_left_method[]" value="Ekspansi"
                                            <?= in_array('Ekspansi', $mandLeftSpaceMethod ?? []) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="mand_left_ekspansi">Ekspansi</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
<script src="../assets/modules/jquery.min.js"></script>

<script>
$(document).ready(function() {
    // Show or hide analysis tabs based on checkboxes
    function updateAnalysisTabs() {
        // First hide all tabs
        $('#moyers-tab-item, #kesling-tab-item, #lundstrum-tab-item, #ponts-tab-item, #howe-tab-item').hide();

        // Determine which tabs should be shown
        var showMoyers = $('input[name="analysis_methods[]"][value="moyers"]').is(':checked');
        var showKesling = $('input[name="analysis_methods[]"][value="kesling"]').is(':checked');
        var showLundstrum = $('input[name="analysis_methods[]"][value="lundstrum"]').is(':checked');
        var showPonts = $('input[name="analysis_methods[]"][value="ponts"]').is(':checked');
        var showHowe = $('input[name="analysis_methods[]"][value="howe"]').is(':checked');

        // Hide tabs content initially
        $('.tab-pane').removeClass('show active');

        // Show tabs based on selected methods
        if (showMoyers) $('#moyers-tab-item').show();
        if (showKesling) $('#kesling-tab-item').show();
        if (showLundstrum) $('#lundstrum-tab-item').show();
        if (showPonts) $('#ponts-tab-item').show();
        if (showHowe) $('#howe-tab-item').show();

        // Determine which tab to activate (first visible tab)
        var activeTabSet = false;

        if (showMoyers && !activeTabSet) {
            $('#moyers-tab').tab('show');
            $('#moyers').addClass('show active');
            activeTabSet = true;
        } else if (showKesling && !activeTabSet) {
            $('#kesling-tab').tab('show');
            $('#kesling').addClass('show active');
            activeTabSet = true;
        } else if (showLundstrum && !activeTabSet) {
            $('#lundstrum-tab').tab('show');
            $('#lundstrum').addClass('show active');
            activeTabSet = true;
        } else if (showPonts && !activeTabSet) {
            $('#ponts-tab').tab('show');
            $('#ponts').addClass('show active');
            activeTabSet = true;
        } else if (showHowe && !activeTabSet) {
            $('#howe-tab').tab('show');
            $('#howe').addClass('show active');
            activeTabSet = true;
        }

        // Hide card if no analysis is selected
        if (!showMoyers && !showKesling && !showLundstrum && !showPonts && !showHowe) {
            $('#spaceAnalysisTab').closest('.card').hide();
        } else {
            $('#spaceAnalysisTab').closest('.card').show();
        }
    }

    // Run on page load
    updateAnalysisTabs();

    // Run when analysis methods checkboxes change
    $('input[name="analysis_methods[]"]').on('change', function() {
        updateAnalysisTabs();
    });

    // Handle tab clicks to properly initialize tab content
    $('.nav-tabs .nav-link').on('click', function(e) {
        e.preventDefault();
        var targetTab = $(this).attr('href');
        $('.tab-pane').removeClass('show active');
        $(targetTab).addClass('show active');
    });

    // Moyers Analysis
    // Moyers table for 75% probability (sum of mandibular incisors vs. required space)
    const moyersTable = {
        '19.5': {
            maxillary: 20.6,
            mandibular: 20.1
        },
        '20.0': {
            maxillary: 20.9,
            mandibular: 20.4
        },
        '20.5': {
            maxillary: 21.2,
            mandibular: 20.7
        },
        '21.0': {
            maxillary: 21.5,
            mandibular: 21.0
        },
        '21.5': {
            maxillary: 21.8,
            mandibular: 21.3
        },
        '22.0': {
            maxillary: 22.0,
            mandibular: 21.6
        },
        '22.5': {
            maxillary: 22.3,
            mandibular: 21.9
        },
        '23.0': {
            maxillary: 22.6,
            mandibular: 22.2
        },
        '23.5': {
            maxillary: 22.9,
            mandibular: 22.5
        },
        '24.0': {
            maxillary: 23.1,
            mandibular: 22.8
        },
        '24.5': {
            maxillary: 23.4,
            mandibular: 23.1
        },
        '25.0': {
            maxillary: 23.7,
            mandibular: 23.4
        },
        '25.5': {
            maxillary: 24.0,
            mandibular: 23.7
        },
        '26.0': {
            maxillary: 24.2,
            mandibular: 24.0
        },
        '26.5': {
            maxillary: 24.5,
            mandibular: 24.3
        },
        '27.0': {
            maxillary: 24.8,
            mandibular: 24.6
        }
    };

    // Calculate Moyers required space
    function calculateMoyersRequiredSpace(width) {
        // Round to nearest 0.5
        let roundedWidth = Math.round(width * 2) / 2;
        roundedWidth = roundedWidth.toFixed(1);

        // Check if width is in range
        if (roundedWidth < 19.5) {
            roundedWidth = '19.5';
        } else if (roundedWidth > 27.0) {
            roundedWidth = '27.0';
        }

        // Get values from table
        if (moyersTable[roundedWidth]) {
            return moyersTable[roundedWidth];
        }

        // If no exact match, find the closest
        let keys = Object.keys(moyersTable);
        let closest = keys[0];
        let minDiff = Math.abs(parseFloat(roundedWidth) - parseFloat(closest));

        for (let key of keys) {
            let diff = Math.abs(parseFloat(roundedWidth) - parseFloat(key));
            if (diff < minDiff) {
                closest = key;
                minDiff = diff;
            }
        }

        return moyersTable[closest];
    }

    // Update Moyers analysis when inputs change
    $('#moyers_32_31_41_42_width, #moyers_gender').on('input change', function() {
        const width = parseFloat($('#moyers_32_31_41_42_width').val());
        const gender = $('#moyers_gender').val();

        if (!isNaN(width) && width > 0 && gender) {
            const requiredSpace = calculateMoyersRequiredSpace(width);

            // Set required space values
            $('#moyers_max_left_required').val(requiredSpace.maxillary.toFixed(2));
            $('#moyers_max_right_required').val(requiredSpace.maxillary.toFixed(2));
            $('#moyers_mand_left_required').val(requiredSpace.mandibular.toFixed(2));
            $('#moyers_mand_right_required').val(requiredSpace.mandibular.toFixed(2));

            // Update table displays
            $('#moyers_max_left_required_display').text(requiredSpace.maxillary.toFixed(2));
            $('#moyers_max_right_required_display').text(requiredSpace.maxillary.toFixed(2));
            $('#moyers_mand_left_required_display').text(requiredSpace.mandibular.toFixed(2));
            $('#moyers_mand_right_required_display').text(requiredSpace.mandibular.toFixed(2));

            // Update difference and assessment
            updateMoyersDifferences();
        }
    });

    // Update available space displays and calculations
    $('.moyers-available').on('input change', function() {
        const id = $(this).attr('id');
        const value = $(this).val();

        // Update display
        $(`#${id}_display`).text(value || '-');

        // Update differences
        updateMoyersDifferences();
    });

    // Function to update differences and assessments
    function updateMoyersDifferences() {
        const regions = ['max_left', 'max_right', 'mand_left', 'mand_right'];

        regions.forEach(function(region) {
            const available = parseFloat($(`#moyers_${region}_available`).val());
            const required = parseFloat($(`#moyers_${region}_required`).val());

            if (!isNaN(available) && !isNaN(required)) {
                const diff = available - required;

                // Update difference display
                $(`#moyers_${region}_diff_display`).text(diff.toFixed(2));

                // Update assessment
                if (diff >= 0) {
                    $(`#moyers_${region}_assessment_display`).html(
                        '<span class="text-success">Cukup Ruang</span>');
                } else {
                    $(`#moyers_${region}_assessment_display`).html(
                        '<span class="text-danger">Kekurangan Ruang</span>');
                }
            } else {
                $(`#moyers_${region}_diff_display`).text('-');
                $(`#moyers_${region}_assessment_display`).text('-');
            }
        });
    }

    // Initialize Moyers calculations on page load
    if ($('#moyers_32_31_41_42_width').val() && $('#moyers_gender').val()) {
        $('#moyers_32_31_41_42_width').trigger('change');
    }

    // Kesling Analysis
    // Update Kesling input display values and calculations
    $('.kesling-available, .kesling-required').on('input change', function() {
        const id = $(this).attr('id');
        const value = $(this).val();

        // Update display
        $(`#${id}_display`).text(value || '-');

        // Update differences
        updateKeslingDifferences();
    });

    // Function to update differences and assessments for Kesling
    function updateKeslingDifferences() {
        const regions = ['max_left', 'max_right', 'mand_left', 'mand_right'];

        regions.forEach(function(region) {
            const available = parseFloat($(`#kesling_${region}_available`).val());
            const required = parseFloat($(`#kesling_${region}_required`).val());

            if (!isNaN(available) && !isNaN(required)) {
                const diff = available - required;

                // Update difference display
                $(`#kesling_${region}_diff_display`).text(diff.toFixed(2));

                // Update assessment
                if (diff >= 0) {
                    $(`#kesling_${region}_assessment_display`).html(
                        '<span class="text-success">Cukup Ruang</span>');
                } else {
                    $(`#kesling_${region}_assessment_display`).html(
                        '<span class="text-danger">Kekurangan Ruang</span>');
                }
            } else {
                $(`#kesling_${region}_diff_display`).text('-');
                $(`#kesling_${region}_assessment_display`).text('-');
            }
        });
    }

    // Initialize Kesling calculations on page load
    updateKeslingDifferences();

    // Lundstrum Analysis
    // Update Lundstrum input display values and calculations
    $('.lundstrum-available, .lundstrum-required').on('input change', function() {
        const id = $(this).attr('id');
        const value = $(this).val();

        // Update display
        $(`#${id}_display`).text(value || '-');

        // Update differences
        updateLundstrumDifferences();
    });

    // Function to update Lundstrum Analysis differences and assessments
    function updateLundstrumDifferences() {
        // Maxilla
        const maxSegments = ['s1', 's2', 's3', 's4', 's5', 's6'];

        for (let i = 0; i < maxSegments.length; i++) {
            const segment = maxSegments[i];
            const requiredId = `lundstrum_max_${segment}_required`;
            const availableId = `lundstrum_max_${segment}_available`;
            const diffDisplayId = `lundstrum_max_${segment}_diff_display`;
            const assessmentDisplayId = `lundstrum_max_${segment}_assessment_display`;

            const requiredInput = $(`#${requiredId}`);
            const availableInput = $(`#${availableId}`);

            if (requiredInput.length && availableInput.length) {
                const requiredVal = parseFloat(requiredInput.val()) || 0;
                const availableVal = parseFloat(availableInput.val()) || 0;

                if (requiredVal > 0 && availableVal > 0) {
                    const diff = availableVal - requiredVal;
                    const roundedDiff = diff.toFixed(2);

                    // Update difference display
                    $(`#${diffDisplayId}`).text(roundedDiff);

                    // Update assessment display
                    const assessmentElem = $(`#${assessmentDisplayId}`);
                    if (diff >= 0) {
                        assessmentElem.html('<span class="text-success">Cukup Ruang</span>');
                    } else {
                        assessmentElem.html('<span class="text-danger">Kekurangan Ruang</span>');
                    }
                } else {
                    $(`#${diffDisplayId}`).text('-');
                    $(`#${assessmentDisplayId}`).text('-');
                }
            }
        }

        // Mandibula
        const mandSegments = ['s1', 's2', 's3', 's4', 's5', 's6'];

        for (let i = 0; i < mandSegments.length; i++) {
            const segment = mandSegments[i];
            const requiredId = `lundstrum_mand_${segment}_required`;
            const availableId = `lundstrum_mand_${segment}_available`;
            const diffDisplayId = `lundstrum_mand_${segment}_diff_display`;
            const assessmentDisplayId = `lundstrum_mand_${segment}_assessment_display`;

            const requiredInput = $(`#${requiredId}`);
            const availableInput = $(`#${availableId}`);

            if (requiredInput.length && availableInput.length) {
                const requiredVal = parseFloat(requiredInput.val()) || 0;
                const availableVal = parseFloat(availableInput.val()) || 0;

                if (requiredVal > 0 && availableVal > 0) {
                    const diff = availableVal - requiredVal;
                    const roundedDiff = diff.toFixed(2);

                    // Update difference display
                    $(`#${diffDisplayId}`).text(roundedDiff);

                    // Update assessment display
                    const assessmentElem = $(`#${assessmentDisplayId}`);
                    if (diff >= 0) {
                        assessmentElem.html('<span class="text-success">Cukup Ruang</span>');
                    } else {
                        assessmentElem.html('<span class="text-danger">Kekurangan Ruang</span>');
                    }
                } else {
                    $(`#${diffDisplayId}`).text('-');
                    $(`#${assessmentDisplayId}`).text('-');
                }
            }
        }
    }

    // Initialize Lundstrum calculations on page load
    updateLundstrumDifferences();

    // Ponts Analysis
    // Update Ponts calculations when inputs change
    $('#ponts_si, #ponts_mpv, #ponts_mmv').on('input change', function() {
        updatePontsCalculations();
    });

    // Function to update Ponts calculations and display
    function updatePontsCalculations() {
        const si = parseFloat($('#ponts_si').val());
        const mpv = parseFloat($('#ponts_mpv').val());
        const mmv = parseFloat($('#ponts_mmv').val());

        // Calculate CPV and CMV if SI is available
        if (!isNaN(si)) {
            const cpv = (si / 80) * 100;
            const cmv = (si / 64) * 100;

            // Update CPV and CMV displays
            $('#ponts_cpv_display').text(cpv.toFixed(2));
            $('#ponts_cmv_display').text(cmv.toFixed(2));

            // Update premolar comparison if MPV is also available
            if (!isNaN(mpv)) {
                const premolarDiff = mpv - cpv;
                let premolarStatus;

                if (Math.abs(premolarDiff) <= 1) {
                    premolarStatus = '<span class="text-success">Normal</span>';
                } else if (premolarDiff < -1) {
                    premolarStatus = '<span class="text-danger">Konstriksi</span>';
                } else {
                    premolarStatus = '<span class="text-warning">Ekspansi</span>';
                }

                $('#ponts_premolar_comparison_display').html(premolarStatus);
            } else {
                $('#ponts_premolar_comparison_display').text('-');
            }

            // Update molar comparison if MMV is also available
            if (!isNaN(mmv)) {
                const molarDiff = mmv - cmv;
                let molarStatus;

                if (Math.abs(molarDiff) <= 1) {
                    molarStatus = '<span class="text-success">Normal</span>';
                } else if (molarDiff < -1) {
                    molarStatus = '<span class="text-danger">Konstriksi</span>';
                } else {
                    molarStatus = '<span class="text-warning">Ekspansi</span>';
                }

                $('#ponts_molar_comparison_display').html(molarStatus);
            } else {
                $('#ponts_molar_comparison_display').text('-');
            }
        } else {
            // If SI is not available, clear all displays
            $('#ponts_cpv_display').text('-');
            $('#ponts_cmv_display').text('-');
            $('#ponts_premolar_comparison_display').text('-');
            $('#ponts_molar_comparison_display').text('-');
        }
    }

    // Initialize Ponts calculations on page load
    updatePontsCalculations();

    // Howe Analysis
    // Update Howe calculations when inputs change
    $('#howe_pmbaw, #howe_ttm').on('input change', function() {
        updateHoweCalculations();
    });

    // Function to update Howe calculations and display
    function updateHoweCalculations() {
        const pmbaw = parseFloat($('#howe_pmbaw').val());
        const ttm = parseFloat($('#howe_ttm').val());

        if (!isNaN(pmbaw) && !isNaN(ttm) && ttm !== 0) {
            const ratio = (pmbaw / ttm) * 100;

            // Update ratio display
            $('#howe_ratio_display').text(ratio.toFixed(2));

            // Update interpretation
            let interpretation;
            if (ratio < 37) {
                interpretation = '<span class="text-danger">Ekstraksi</span>';
            } else if (ratio >= 37 && ratio <= 44) {
                interpretation = '<span class="text-warning">Borderline</span>';
            } else {
                interpretation = '<span class="text-success">Non-Ekstraksi</span>';
            }

            $('#howe_interpretation_display').html(interpretation);
        } else {
            // If inputs are not valid, clear displays
            $('#howe_ratio_display').text('-');
            $('#howe_interpretation_display').text('-');
        }
    }

    // Initialize Howe calculations on page load
    updateHoweCalculations();

    // Form navigation
    $('.prev-section').click(function() {
        window.location.href = 'edit.php?id=<?= $recordId ?>&section=8';
    });

    $('.next-section').click(function() {
        window.location.href = 'edit.php?id=<?= $recordId ?>&section=10';
    });

    // Handle showing/hiding extraction options
    $('.space-method').on('change', function() {
        var quadrant = $(this).data('quadrant');
        var optionsId = '#' + quadrant + '_extraction_options';

        if ($(this).is(':checked') && $(this).val() === 'Ekstraksi') {
            $(optionsId).slideDown();
        } else if (!$(this).is(':checked') && $(this).val() === 'Ekstraksi') {
            $(optionsId).slideUp();
        }
    });

    // Initialize extraction options display on page load
    $('.space-method').each(function() {
        if ($(this).is(':checked') && $(this).val() === 'Ekstraksi') {
            var quadrant = $(this).data('quadrant');
            var optionsId = '#' + quadrant + '_extraction_options';
            $(optionsId).show();
        }
    });

    // Fix for Stisla selectgroup visual feedback issue - more aggressive approach
    // Add custom CSS to override Stisla's styling
    $('head').append(`
        <style>
            .selectgroup-input:not(:checked) + .selectgroup-button {
                background-color: #fdfdff !important;
                border-color: #e4e6fc !important;
                color: #495057 !important;
            }
            .selectgroup-input:checked + .selectgroup-button {
                background-color: #6777ef !important;
                border-color: #6777ef !important;
                color: #fff !important;
            }
        </style>
    `);

    // Replace click handler with a custom one
    $('.selectgroup-input').each(function() {
        var $input = $(this);
        var $parent = $input.closest('.selectgroup-item');

        // Remove existing click handlers
        $parent.off('click');
        $input.off('click');

        // Add our custom handler
        $input.on('change', function() {
            // Force redraw by removing and re-adding the element
            var isChecked = $(this).prop('checked');
            var $button = $(this).next('.selectgroup-button');

            setTimeout(function() {
                // Force browser to redraw the element
                $button.hide().show(0);

                // Manually toggle active class
                if (isChecked) {
                    $parent.addClass('active');
                } else {
                    $parent.removeClass('active');
                }
            }, 0);
        });
    });

    // Auto-populate values from Section 8's tooth data
    function populateValuesFromSection8() {
        // Get the tooth data from Section 8 via AJAX
        $.ajax({
            url: 'includes/ajax/get_tooth_data.php',
            type: 'POST',
            data: {
                record_id: <?= $recordId ?>
            },
            dataType: 'json',
            success: function(response) {
                if (response.success && response.tooth_data) {
                    const toothData = response.tooth_data;

                    // 1. Moyers Analysis - Sum of mandibular incisors (32, 31, 41, 42)
                    // Only populate if Moyers is selected and the field is empty
                    if (toothData.width && toothData.width.lower &&
                        $('input[name="analysis_methods[]"][value="moyers"]').is(':checked') &&
                        $('#moyers_32_31_41_42_width').val() === '') {

                        let sum = 0;
                        let found = 0;

                        // Get teeth 32, 31, 41, 42
                        if (toothData.width.lower['32'] && !isNaN(parseFloat(toothData.width.lower[
                                '32']))) {
                            sum += parseFloat(toothData.width.lower['32']);
                            found++;
                        }
                        if (toothData.width.lower['31'] && !isNaN(parseFloat(toothData.width.lower[
                                '31']))) {
                            sum += parseFloat(toothData.width.lower['31']);
                            found++;
                        }
                        if (toothData.width.lower['41'] && !isNaN(parseFloat(toothData.width.lower[
                                '41']))) {
                            sum += parseFloat(toothData.width.lower['41']);
                            found++;
                        }
                        if (toothData.width.lower['42'] && !isNaN(parseFloat(toothData.width.lower[
                                '42']))) {
                            sum += parseFloat(toothData.width.lower['42']);
                            found++;
                        }

                        // Only set the value if we found all 4 teeth
                        if (found === 4) {
                            $('#moyers_32_31_41_42_width').val(sum.toFixed(2));
                            // Trigger calculations
                            $('#moyers_32_31_41_42_width').trigger('change');
                        }
                    }

                    // 2. Kesling Analysis - Required space for each quadrant
                    // Only populate if Kesling is selected and fields are empty
                    if (toothData.width &&
                        $('input[name="analysis_methods[]"][value="kesling"]').is(':checked')) {

                        // Maxillary Left (teeth 25, 24, 23, 22, 21)
                        if ($('#kesling_max_left_required').val() === '') {
                            let maxLeftSum = 0;
                            let maxLeftFound = 0;
                            const maxLeftTeeth = ['25', '24', '23', '22', '21'];

                            maxLeftTeeth.forEach(tooth => {
                                if (toothData.width.upper[tooth] && !isNaN(parseFloat(
                                        toothData.width.upper[tooth]))) {
                                    maxLeftSum += parseFloat(toothData.width.upper[tooth]);
                                    maxLeftFound++;
                                }
                            });

                            if (maxLeftFound === 5) {
                                $('#kesling_max_left_required').val(maxLeftSum.toFixed(2));
                                // Trigger calculation update for this field
                                $('#kesling_max_left_required').trigger('change');
                            }
                        }

                        // Maxillary Right (teeth 11, 12, 13, 14, 15)
                        if ($('#kesling_max_right_required').val() === '') {
                            let maxRightSum = 0;
                            let maxRightFound = 0;
                            const maxRightTeeth = ['11', '12', '13', '14', '15'];

                            maxRightTeeth.forEach(tooth => {
                                if (toothData.width.upper[tooth] && !isNaN(parseFloat(
                                        toothData.width.upper[tooth]))) {
                                    maxRightSum += parseFloat(toothData.width.upper[tooth]);
                                    maxRightFound++;
                                }
                            });

                            if (maxRightFound === 5) {
                                $('#kesling_max_right_required').val(maxRightSum.toFixed(2));
                                // Trigger calculation update for this field
                                $('#kesling_max_right_required').trigger('change');
                            }
                        }

                        // Mandibular Left (teeth 35, 34, 33, 32, 31)
                        if ($('#kesling_mand_left_required').val() === '') {
                            let mandLeftSum = 0;
                            let mandLeftFound = 0;
                            const mandLeftTeeth = ['35', '34', '33', '32', '31'];

                            mandLeftTeeth.forEach(tooth => {
                                if (toothData.width.lower[tooth] && !isNaN(parseFloat(
                                        toothData.width.lower[tooth]))) {
                                    mandLeftSum += parseFloat(toothData.width.lower[tooth]);
                                    mandLeftFound++;
                                }
                            });

                            if (mandLeftFound === 5) {
                                $('#kesling_mand_left_required').val(mandLeftSum.toFixed(2));
                                // Trigger calculation update for this field
                                $('#kesling_mand_left_required').trigger('change');
                            }
                        }

                        // Mandibular Right (teeth 41, 42, 43, 44, 45)
                        if ($('#kesling_mand_right_required').val() === '') {
                            let mandRightSum = 0;
                            let mandRightFound = 0;
                            const mandRightTeeth = ['41', '42', '43', '44', '45'];

                            mandRightTeeth.forEach(tooth => {
                                if (toothData.width.lower[tooth] && !isNaN(parseFloat(
                                        toothData.width.lower[tooth]))) {
                                    mandRightSum += parseFloat(toothData.width.lower[
                                        tooth]);
                                    mandRightFound++;
                                }
                            });

                            if (mandRightFound === 5) {
                                $('#kesling_mand_right_required').val(mandRightSum.toFixed(2));
                                // Trigger calculation update for this field
                                $('#kesling_mand_right_required').trigger('change');
                            }
                        }
                    }

                    // 3. Lundstrum Analysis (ALD)
                    // Only populate if Lundstrum is selected and fields are empty
                    if (toothData.width &&
                        $('input[name="analysis_methods[]"][value="lundstrum"]').is(':checked')) {

                        // Maxilla S1 (teeth 16, 15)
                        if ($('#lundstrum_max_s1_required').val() === '') {
                            let maxS1Sum = 0;
                            let maxS1Found = 0;
                            const maxS1Teeth = ['16', '15'];

                            maxS1Teeth.forEach(tooth => {
                                if (toothData.width.upper[tooth] && !isNaN(parseFloat(
                                        toothData.width.upper[tooth]))) {
                                    maxS1Sum += parseFloat(toothData.width.upper[tooth]);
                                    maxS1Found++;
                                }
                            });

                            if (maxS1Found === 2) {
                                $('#lundstrum_max_s1_required').val(maxS1Sum.toFixed(2)).trigger(
                                    'change');
                            }
                        }

                        // Maxilla S2 (teeth 14, 13)
                        if ($('#lundstrum_max_s2_required').val() === '') {
                            let maxS2Sum = 0;
                            let maxS2Found = 0;
                            const maxS2Teeth = ['14', '13'];

                            maxS2Teeth.forEach(tooth => {
                                if (toothData.width.upper[tooth] && !isNaN(parseFloat(
                                        toothData.width.upper[tooth]))) {
                                    maxS2Sum += parseFloat(toothData.width.upper[tooth]);
                                    maxS2Found++;
                                }
                            });

                            if (maxS2Found === 2) {
                                $('#lundstrum_max_s2_required').val(maxS2Sum.toFixed(2)).trigger(
                                    'change');
                            }
                        }

                        // Maxilla S3 (teeth 12, 11)
                        if ($('#lundstrum_max_s3_required').val() === '') {
                            let maxS3Sum = 0;
                            let maxS3Found = 0;
                            const maxS3Teeth = ['12', '11'];

                            maxS3Teeth.forEach(tooth => {
                                if (toothData.width.upper[tooth] && !isNaN(parseFloat(
                                        toothData.width.upper[tooth]))) {
                                    maxS3Sum += parseFloat(toothData.width.upper[tooth]);
                                    maxS3Found++;
                                }
                            });

                            if (maxS3Found === 2) {
                                $('#lundstrum_max_s3_required').val(maxS3Sum.toFixed(2)).trigger(
                                    'change');
                            }
                        }

                        // Maxilla S4 (teeth 21, 22)
                        if ($('#lundstrum_max_s4_required').val() === '') {
                            let maxS4Sum = 0;
                            let maxS4Found = 0;
                            const maxS4Teeth = ['21', '22'];

                            maxS4Teeth.forEach(tooth => {
                                if (toothData.width.upper[tooth] && !isNaN(parseFloat(
                                        toothData.width.upper[tooth]))) {
                                    maxS4Sum += parseFloat(toothData.width.upper[tooth]);
                                    maxS4Found++;
                                }
                            });

                            if (maxS4Found === 2) {
                                $('#lundstrum_max_s4_required').val(maxS4Sum.toFixed(2)).trigger(
                                    'change');
                            }
                        }

                        // Maxilla S5 (teeth 23, 24)
                        if ($('#lundstrum_max_s5_required').val() === '') {
                            let maxS5Sum = 0;
                            let maxS5Found = 0;
                            const maxS5Teeth = ['23', '24'];

                            maxS5Teeth.forEach(tooth => {
                                if (toothData.width.upper[tooth] && !isNaN(parseFloat(
                                        toothData.width.upper[tooth]))) {
                                    maxS5Sum += parseFloat(toothData.width.upper[tooth]);
                                    maxS5Found++;
                                }
                            });

                            if (maxS5Found === 2) {
                                $('#lundstrum_max_s5_required').val(maxS5Sum.toFixed(2)).trigger(
                                    'change');
                            }
                        }

                        // Maxilla S6 (teeth 25, 26)
                        if ($('#lundstrum_max_s6_required').val() === '') {
                            let maxS6Sum = 0;
                            let maxS6Found = 0;
                            const maxS6Teeth = ['25', '26'];

                            maxS6Teeth.forEach(tooth => {
                                if (toothData.width.upper[tooth] && !isNaN(parseFloat(
                                        toothData.width.upper[tooth]))) {
                                    maxS6Sum += parseFloat(toothData.width.upper[tooth]);
                                    maxS6Found++;
                                }
                            });

                            if (maxS6Found === 2) {
                                $('#lundstrum_max_s6_required').val(maxS6Sum.toFixed(2)).trigger(
                                    'change');
                            }
                        }

                        // Mandibula S1 (teeth 46, 45)
                        if ($('#lundstrum_mand_s1_required').val() === '') {
                            let mandS1Sum = 0;
                            let mandS1Found = 0;
                            const mandS1Teeth = ['46', '45'];

                            mandS1Teeth.forEach(tooth => {
                                if (toothData.width.lower[tooth] && !isNaN(parseFloat(
                                        toothData.width.lower[tooth]))) {
                                    mandS1Sum += parseFloat(toothData.width.lower[tooth]);
                                    mandS1Found++;
                                }
                            });

                            if (mandS1Found === 2) {
                                $('#lundstrum_mand_s1_required').val(mandS1Sum.toFixed(2)).trigger(
                                    'change');
                            }
                        }

                        // Mandibula S2 (teeth 44, 43)
                        if ($('#lundstrum_mand_s2_required').val() === '') {
                            let mandS2Sum = 0;
                            let mandS2Found = 0;
                            const mandS2Teeth = ['44', '43'];

                            mandS2Teeth.forEach(tooth => {
                                if (toothData.width.lower[tooth] && !isNaN(parseFloat(
                                        toothData.width.lower[tooth]))) {
                                    mandS2Sum += parseFloat(toothData.width.lower[tooth]);
                                    mandS2Found++;
                                }
                            });

                            if (mandS2Found === 2) {
                                $('#lundstrum_mand_s2_required').val(mandS2Sum.toFixed(2)).trigger(
                                    'change');
                            }
                        }

                        // Mandibula S3 (teeth 41, 42)
                        if ($('#lundstrum_mand_s3_required').val() === '') {
                            let mandS3Sum = 0;
                            let mandS3Found = 0;
                            const mandS3Teeth = ['41', '42'];

                            mandS3Teeth.forEach(tooth => {
                                if (toothData.width.lower[tooth] && !isNaN(parseFloat(
                                        toothData.width.lower[tooth]))) {
                                    mandS3Sum += parseFloat(toothData.width.lower[tooth]);
                                    mandS3Found++;
                                }
                            });

                            if (mandS3Found === 2) {
                                $('#lundstrum_mand_s3_required').val(mandS3Sum.toFixed(2)).trigger(
                                    'change');
                            }
                        }

                        // Mandibula S4 (teeth 31, 32)
                        if ($('#lundstrum_mand_s4_required').val() === '') {
                            let mandS4Sum = 0;
                            let mandS4Found = 0;
                            const mandS4Teeth = ['31', '32'];

                            mandS4Teeth.forEach(tooth => {
                                if (toothData.width.lower[tooth] && !isNaN(parseFloat(
                                        toothData.width.lower[tooth]))) {
                                    mandS4Sum += parseFloat(toothData.width.lower[tooth]);
                                    mandS4Found++;
                                }
                            });

                            if (mandS4Found === 2) {
                                $('#lundstrum_mand_s4_required').val(mandS4Sum.toFixed(2)).trigger(
                                    'change');
                            }
                        }

                        // Mandibula S5 (teeth 33, 34)
                        if ($('#lundstrum_mand_s5_required').val() === '') {
                            let mandS5Sum = 0;
                            let mandS5Found = 0;
                            const mandS5Teeth = ['33', '34'];

                            mandS5Teeth.forEach(tooth => {
                                if (toothData.width.lower[tooth] && !isNaN(parseFloat(
                                        toothData.width.lower[tooth]))) {
                                    mandS5Sum += parseFloat(toothData.width.lower[tooth]);
                                    mandS5Found++;
                                }
                            });

                            if (mandS5Found === 2) {
                                $('#lundstrum_mand_s5_required').val(mandS5Sum.toFixed(2)).trigger(
                                    'change');
                            }
                        }

                        // Mandibula S6 (teeth 35, 36)
                        if ($('#lundstrum_mand_s6_required').val() === '') {
                            let mandS6Sum = 0;
                            let mandS6Found = 0;
                            const mandS6Teeth = ['35', '36'];

                            mandS6Teeth.forEach(tooth => {
                                if (toothData.width.lower[tooth] && !isNaN(parseFloat(
                                        toothData.width.lower[tooth]))) {
                                    mandS6Sum += parseFloat(toothData.width.lower[tooth]);
                                    mandS6Found++;
                                }
                            });

                            if (mandS6Found === 2) {
                                $('#lundstrum_mand_s6_required').val(mandS6Sum.toFixed(2)).trigger(
                                    'change');
                            }
                        }
                    }

                    // 4. Ponts Analysis - SI (Sum of Maxillary Incisors)
                    // Only populate if Ponts is selected and the field is empty
                    if (toothData.width && toothData.width.upper &&
                        $('input[name="analysis_methods[]"][value="ponts"]').is(':checked') &&
                        $('#ponts_si').val() === '') {

                        // Sum of 4 maxillary incisors (12, 11, 21, 22)
                        let siSum = 0;
                        let siFound = 0;
                        const siTeeth = ['12', '11', '21', '22'];

                        siTeeth.forEach(tooth => {
                            if (toothData.width.upper[tooth] && !isNaN(parseFloat(toothData
                                    .width.upper[tooth]))) {
                                siSum += parseFloat(toothData.width.upper[tooth]);
                                siFound++;
                            }
                        });

                        if (siFound === 4) {
                            $('#ponts_si').val(siSum.toFixed(2));
                            // Trigger calculations
                            $('#ponts_si').trigger('change');
                        }
                    }

                    // 5. Howe Analysis - TTM (Total Tooth Material)
                    // Only populate if Howe is selected and the field is empty
                    if (toothData.width && toothData.width.upper &&
                        $('input[name="analysis_methods[]"][value="howe"]').is(':checked') &&
                        $('#howe_ttm').val() === '') {

                        // Total Tooth Material (sum of all maxillary teeth except 2nd molars)
                        let ttmSum = 0;
                        let ttmCount = 0;

                        // Teeth 16-26 (skipping 17, 27, 18, 28)
                        const ttmTeeth = ['16', '15', '14', '13', '12', '11', '21', '22', '23',
                            '24', '25', '26'
                        ];

                        ttmTeeth.forEach(tooth => {
                            if (toothData.width.upper[tooth] && !isNaN(parseFloat(toothData
                                    .width.upper[tooth]))) {
                                ttmSum += parseFloat(toothData.width.upper[tooth]);
                                ttmCount++;
                            }
                        });

                        if (ttmCount > 0) {
                            $('#howe_ttm').val(ttmSum.toFixed(2));
                            // Trigger calculations
                            $('#howe_ttm').trigger('change');
                        }
                    }
                }
            },
            error: function(xhr, status, error) {
                console.error("Error fetching tooth data:", error);
            }
        });
    }

    // Call the function to populate values when the page loads
    populateValuesFromSection8();

    // Also call it when analysis methods are selected
    $('input[name="analysis_methods[]"]').on('change', function() {
        populateValuesFromSection8();
    });
});
</script>