<?php
// Section 9: Analisis Kebutuhan Ruang (Space Analysis)

// Get the space analysis data for this record
$spaceAnalysis = $db->getRow("SELECT * FROM space_analyses WHERE medical_record_id = ?i", $recordId);

// Initialize variables with existing data or defaults
$spaceAnalysisConclusion = $spaceAnalysis['space_analysis_conclusion'] ?? '';

// Space methods
$maxLeftSpaceMethod = !empty($spaceAnalysis['max_left_space_method']) ? json_decode($spaceAnalysis['max_left_space_method'], true) : [];
$maxRightSpaceMethod = !empty($spaceAnalysis['max_right_space_method']) ? json_decode($spaceAnalysis['max_right_space_method'], true) : [];
$mandLeftSpaceMethod = !empty($spaceAnalysis['mand_left_space_method']) ? json_decode($spaceAnalysis['mand_left_space_method'], true) : [];
$mandRightSpaceMethod = !empty($spaceAnalysis['mand_right_space_method']) ? json_decode($spaceAnalysis['mand_right_space_method'], true) : [];

// Extraction teeth
$maxLeftExtractionTeeth = !empty($spaceAnalysis['max_left_extraction_teeth']) ? json_decode($spaceAnalysis['max_left_extraction_teeth'], true) : [];
$maxRightExtractionTeeth = !empty($spaceAnalysis['max_right_extraction_teeth']) ? json_decode($spaceAnalysis['max_right_extraction_teeth'], true) : [];
$mandLeftExtractionTeeth = !empty($spaceAnalysis['mand_left_extraction_teeth']) ? json_decode($spaceAnalysis['mand_left_extraction_teeth'], true) : [];
$mandRightExtractionTeeth = !empty($spaceAnalysis['mand_right_extraction_teeth']) ? json_decode($spaceAnalysis['mand_right_extraction_teeth'], true) : [];
?>

<div class="section-container">
    <h2 class="section-title">Analisis Kebutuhan Ruang</h2>

    <!-- Kesimpulan Analisis section -->
    <div class="card">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Kesimpulan Analisis Kebutuhan Ruang</h5>
        </div>
        <div class="card-body">
            <div class="form-group">
                <label>Kesimpulan Analisis Kebutuhan Ruang <?php echo getRequiredFieldMarker(); ?></label>
                <div class="selectgroup">
                    <label class="selectgroup-item">
                        <input type="radio" name="space_analysis_conclusion" value="Ekstraksi" class="selectgroup-input"
                            <?= $spaceAnalysisConclusion === 'Ekstraksi' ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Ekstraksi</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="radio" name="space_analysis_conclusion" value="Borderline"
                            class="selectgroup-input" <?= $spaceAnalysisConclusion === 'Borderline' ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Borderline</span>
                    </label>
                    <label class="selectgroup-item">
                        <input type="radio" name="space_analysis_conclusion" value="Non-Ekstraksi"
                            class="selectgroup-input"
                            <?= $spaceAnalysisConclusion === 'Non-Ekstraksi' ? 'checked' : '' ?>>
                        <span class="selectgroup-button">Non-Ekstraksi</span>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <!-- Form navigation buttons -->
    <div class="form-group mt-4">
        <div class="d-flex justify-content-between">
            <button type="button" class="btn btn-secondary prev-section">Sebelumnya</button>
            <button type="button" class="btn btn-primary next-section">Selanjutnya</button>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Form navigation
    $('.prev-section').click(function() {
        window.location.href = 'edit.php?id=<?= $recordId ?>&section=8';
    });

    $('.next-section').click(function() {
        window.location.href = 'edit.php?id=<?= $recordId ?>&section=10';
    });
});
</script>