<?php
// Include initialization file
require_once '../init.php';

// Authentication checks
if (!isLoggedIn()) {
    redirect('../auth/login.php');
}

// Validate record ID
if (!isset($_GET['id']) || empty($_GET['id'])) {
    setFlashMessage('ID rekam medis tidak valid.', 'danger');
    redirect('index.php');
}
$recordId = intval($_GET['id']);

// Get medical record and patient data
$record = $db->getRow("SELECT mr.*, p.name as patient_name, p.birth_date, p.gender, p.medical_record_number as patient_mrn,
                      u.name as doctor_name 
                      FROM medical_records mr 
                      JOIN patients p ON mr.patient_id = p.id
                      JOIN users u ON mr.doctor_id = u.id
                      WHERE mr.id = ?i", $recordId);
if (!$record) {
    setFlashMessage('Rekam medis tidak ditemukan.', 'danger');
    redirect('index.php');
}

// Calculate patient's age
$birthDate = new DateTime($record['birth_date']);
$today = new DateTime();
$age = $birthDate->diff($today)->y;

// Set isViewMode flag for templates (always true in this file)
$isViewMode = true;

// Load all data needed for all sections
require_once 'includes/data_loader.php';

// HTML Header
$pageTitle = "Lihat Rekam Medis";
include_once 'includes/view_header.php';
?>

<div class="section-header">
    <h1>Lihat Rekam Medis</h1>
    <div class="section-header-breadcrumb">
        <div class="breadcrumb-item"><a href="../index.php">Dashboard</a></div>
        <div class="breadcrumb-item"><a href="index.php">Rekam Medis</a></div>
        <div class="breadcrumb-item active">Lihat Rekam Medis</div>
    </div>
</div>

<div class="section-body">
    <?php if(isset($_SESSION['flash_message']) && isset($_SESSION['flash_type'])): ?>
    <div class="alert alert-<?php echo $_SESSION['flash_type']; ?> alert-dismissible show fade">
        <div class="alert-body">
            <button class="close" data-dismiss="alert">
                <span>&times;</span>
            </button>
            <?php echo $_SESSION['flash_message']; ?>
        </div>
    </div>
    <?php 
    unset($_SESSION['flash_message']);
    unset($_SESSION['flash_type']);
    endif; ?>

    <!-- Patient Information and Action Buttons -->
    <div class="card mb-4">
        <div class="card-header">
            <h4>Informasi Pasien</h4>
            <div class="card-header-action">
                <!-- <div class="dropdown d-inline">
                    <button class="btn btn-primary dropdown-toggle" type="button" id="exportDropdown"
                        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-download"></i> Export
                    </button>
                    <div class="dropdown-menu" aria-labelledby="exportDropdown">
                        <a class="dropdown-item" href="export/to_pdf.php?id=<?= $recordId ?>" target="_blank">
                            <i class="far fa-file-pdf text-danger"></i> Export PDF
                        </a>
                        <a class="dropdown-item" href="export/to_excel.php?id=<?= $recordId ?>">
                            <i class="far fa-file-excel text-success"></i> Export Excel
                        </a>
                        <a class="dropdown-item" href="export/to_word.php?id=<?= $recordId ?>">
                            <i class="far fa-file-word text-primary"></i> Export Word
                        </a>
                    </div>
                </div>
                <a href="export/to_pdf_simple.php?id=<?php echo $recordId; ?>" class="btn btn-info btn-sm" target="_blank">
                    <i class="fas fa-file-pdf"></i> Ekspor PDF (Alternatif)
                </a> -->
                <button class="btn btn-info ml-2" id="printButton">
                    <i class="fas fa-print"></i> Print
                </button>
                <?php if (isDoctor() && $record['is_complete'] == 0): ?>
                <a href="edit.php?id=<?= $recordId ?>" class="btn btn-warning ml-2">
                    <i class="fas fa-edit"></i> Edit
                </a>
                <?php endif; ?>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm">
                        <tr>
                            <td width="40%" class="font-weight-bold">Nomor Rekam Medis</td>
                            <td><?php echo viewModeDisplay($record['medical_record_number']); ?></td>
                        </tr>
                        <tr>
                            <td class="font-weight-bold">Nama Pasien</td>
                            <td><?php echo viewModeDisplay($record['patient_name']); ?></td>
                        </tr>
                        <tr>
                            <td class="font-weight-bold">Tanggal Lahir</td>
                            <td><?php echo viewModeDateDisplay($record['birth_date']); ?></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm">
                        <tr>
                            <td width="40%" class="font-weight-bold">Tanggal Pemeriksaan</td>
                            <td><?php echo viewModeDateDisplay($record['examination_date']); ?></td>
                        </tr>
                        <tr>
                            <td class="font-weight-bold">Usia</td>
                            <td><?php echo viewModeDisplay($age . ' tahun'); ?></td>
                        </tr>
                        <tr>
                            <td class="font-weight-bold">Jenis Kelamin</td>
                            <td><?php echo viewModeDisplay($record['gender']); ?></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-center mb-4">
        <a href="#section1" class="btn btn-icon btn-primary mx-1">1</a>
        <a href="#section2" class="btn btn-icon btn-primary mx-1">2</a>
        <a href="#section3" class="btn btn-icon btn-primary mx-1">3</a>
        <a href="#section4" class="btn btn-icon btn-primary mx-1">4</a>
        <a href="#section5" class="btn btn-icon btn-primary mx-1">5</a>
        <a href="#section6" class="btn btn-icon btn-primary mx-1">6</a>
        <a href="#section7" class="btn btn-icon btn-primary mx-1">7</a>
        <a href="#section8" class="btn btn-icon btn-primary mx-1">8</a>
        <a href="#section9" class="btn btn-icon btn-primary mx-1">9</a>
        <a href="#section10" class="btn btn-icon btn-primary mx-1">10</a>
        <a href="#section11" class="btn btn-icon btn-primary mx-1">11</a>
        <a href="#section12" class="btn btn-icon btn-primary mx-1">12</a>
        <a href="#section13" class="btn btn-icon btn-primary mx-1">13</a>
    </div>

    <!-- All sections, one after another -->
    <div id="section1" class="card-anchor"></div>
    <?php
    $currentSection = 1;
    include 'sections/section1.php';
    ?>

    <div id="section2" class="card-anchor"></div>
    <?php
    $currentSection = 2;
    include 'sections/section2.php';
    ?>

    <div id="section3" class="card-anchor"></div>
    <?php
    $currentSection = 3;
    include 'sections/section3.php';
    ?>

    <div id="section4" class="card-anchor"></div>
    <?php
    $currentSection = 4;
    include 'sections/section4.php';
    ?>

    <div id="section5" class="card-anchor"></div>
    <?php
    $currentSection = 5;
    include 'sections/section5.php';
    ?>

    <div id="section6" class="card-anchor"></div>
    <?php
    $currentSection = 6;
    include 'sections/section6.php';
    ?>

    <div id="section7" class="card-anchor"></div>
    <?php
    $currentSection = 7;
    include 'sections/section7.php';
    ?>

    <div id="section8" class="card-anchor"></div>
    <?php
    $currentSection = 8;
    include 'sections/section8.php';
    ?>

    <div id="section9" class="card-anchor"></div>
    <?php
    $currentSection = 9;
    include 'sections/section9.php';
    ?>

    <div id="section10" class="card-anchor"></div>
    <?php
    $currentSection = 10;
    include 'sections/section10.php';
    ?>

    <div id="section11" class="card-anchor"></div>
    <?php
    $currentSection = 11;
    include 'sections/section11.php';
    ?>

    <div id="section12" class="card-anchor"></div>
    <?php
    $currentSection = 12;
    include 'sections/section12.php';
    ?>

    <div id="section13" class="card-anchor"></div>
    <?php
    $currentSection = 13;
    include 'sections/section13.php';
    ?>

    <!-- Back to top button -->
    <a href="#" class="btn btn-icon btn-primary back-to-top"
        style="position: fixed; bottom: 20px; right: 20px; display: none;">
        <i class="fas fa-arrow-up"></i>
    </a>
</div>

<script>
// Initialize print functionality
document.getElementById('printButton').addEventListener('click', function() {
    window.print();
});

// Back to top button
$(window).scroll(function() {
    if ($(this).scrollTop() > 300) {
        $('.back-to-top').fadeIn();
    } else {
        $('.back-to-top').fadeOut();
    }
});

$('.back-to-top').click(function(e) {
    e.preventDefault();
    $('html, body').animate({
        scrollTop: 0
    }, 500);
});

// Smooth scrolling for section links
$('a[href^="#section"]').click(function(e) {
    e.preventDefault();

    var target = $(this.getAttribute('href'));
    if (target.length) {
        $('html, body').animate({
            scrollTop: target.offset().top - 80 // Offset for fixed header
        }, 500);
    }
});
</script>

<?php
// HTML Footer
include_once 'includes/view_footer.php';
?>