<?php
// Include initialization file
require_once '../init.php';

// Check if user is logged in
if (!isLoggedIn()) {
    redirect('../auth/login.php');
}

// Initialize variables
$name = '';
$medical_record_number = '';
$birth_date = '';
$gender = '';
$address = '';
$phone_number = '';
$email = '';
$occupation = '';
$errorMessage = '';
$successMessage = '';

// Generate next medical record number
$latestMRN = $db->getOne("SELECT medical_record_number FROM patients ORDER BY id DESC LIMIT 1");
$nextMRN = '001/ORT/' . date('Y');

if ($latestMRN) {
    // Extract the numeric part of the MRN
    $parts = explode('/', $latestMRN);
    if (count($parts) >= 3) {
        $numericPart = intval($parts[0]);
        $nextNumericPart = $numericPart + 1;
        $nextMRN = sprintf('%03d', $nextNumericPart) . '/ORT/' . date('Y');
    }
}

// Process form submission
if (isPostRequest()) {
    // Get form data
    $name = $_POST['name'] ?? '';
    $medical_record_number = $_POST['medical_record_number'] ?? '';
    $birth_date = $_POST['birth_date'] ?? '';
    $gender = $_POST['gender'] ?? '';
    $address = $_POST['address'] ?? '';
    $phone_number = $_POST['phone_number'] ?? '';
    $email = $_POST['email'] ?? '';
    $occupation = $_POST['occupation'] ?? '';
    
    // Validate form data
    if (empty($name)) {
        $errorMessage = 'Nama pasien harus diisi.';
    } else if (empty($medical_record_number)) {
        $errorMessage = 'Nomor rekam medis harus diisi.';
    } else if (empty($birth_date)) {
        $errorMessage = 'Tanggal lahir harus diisi.';
    } else if (empty($gender)) {
        $errorMessage = 'Jenis kelamin harus dipilih.';
    } else {
        // Sanitize data
        $name = sanitize($name);
        $medical_record_number = sanitize($medical_record_number);
        $birth_date = formatDateToMysql($birth_date);
        $gender = sanitize($gender);
        $address = sanitize($address);
        $phone_number = sanitize($phone_number);
        $email = sanitize($email);
        $occupation = sanitize($occupation);
        
        // Check if MRN already exists
        $existingMRN = $db->getOne("SELECT COUNT(*) FROM patients WHERE medical_record_number = ?s", $medical_record_number);
        
        if ($existingMRN > 0) {
            $errorMessage = 'Nomor rekam medis sudah digunakan oleh pasien lain.';
        } else {
            // Insert data into database
            $result = $db->query(
                "INSERT INTO patients (name, medical_record_number, birth_date, gender, address, phone_number, email, occupation, created_by) 
                VALUES (?s, ?s, ?s, ?s, ?s, ?s, ?s, ?s, ?i)",
                $name, $medical_record_number, $birth_date, $gender, $address, $phone_number, $email, $occupation, $_SESSION['user_id']
            );
            
            if ($result) {
                $patientId = $db->insertId();
                setFlashMessage('Data pasien berhasil disimpan.', 'success');
                redirect('index.php');
            } else {
                $errorMessage = 'Terjadi kesalahan saat menyimpan data pasien.';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title>Tambah Pasien Baru &mdash; Sistem Rekam Medis Ortodontik</title>

    <!-- General CSS Files -->
    <link rel="stylesheet" href="../assets/modules/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/modules/fontawesome/css/all.min.css">

    <!-- CSS Libraries -->
    <link rel="stylesheet" href="../assets/modules/bootstrap-daterangepicker/daterangepicker.css">
    <link rel="stylesheet" href="../assets/modules/select2/dist/css/select2.min.css">

    <!-- Template CSS -->
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/components.css">
</head>

<body>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <!-- Header -->
            <?php include '../layouts/header.php'; ?>

            <!-- Sidebar -->
            <?php include '../layouts/sidebar.php'; ?>

            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="section-header">
                        <h1>Tambah Pasien Baru</h1>
                        <div class="section-header-breadcrumb">
                            <div class="breadcrumb-item active"><a href="../index.php">Dashboard</a></div>
                            <div class="breadcrumb-item"><a href="index.php">Data Pasien</a></div>
                            <div class="breadcrumb-item">Tambah Pasien Baru</div>
                        </div>
                    </div>

                    <div class="section-body">
                        <h2 class="section-title">Formulir Pasien Baru</h2>
                        <p class="section-lead">
                            Isi formulir berikut untuk menambahkan data pasien baru ke dalam sistem.
                        </p>

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>Data Diri Pasien</h4>
                                    </div>
                                    <div class="card-body">
                                        <?php if (!empty($errorMessage)): ?>
                                        <div class="alert alert-danger alert-dismissible show fade">
                                            <div class="alert-body">
                                                <button class="close" data-dismiss="alert">
                                                    <span>×</span>
                                                </button>
                                                <?php echo $errorMessage; ?>
                                            </div>
                                        </div>
                                        <?php endif; ?>

                                        <?php if (!empty($successMessage)): ?>
                                        <div class="alert alert-success alert-dismissible show fade">
                                            <div class="alert-body">
                                                <button class="close" data-dismiss="alert">
                                                    <span>×</span>
                                                </button>
                                                <?php echo $successMessage; ?>
                                            </div>
                                        </div>
                                        <?php endif; ?>

                                        <form action="" method="POST">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Nomor Rekam Medis
                                                            <?php echo getRequiredFieldMarker(); ?></label>
                                                        <input type="text" class="form-control"
                                                            name="medical_record_number"
                                                            value="<?php echo !empty($medical_record_number) ? $medical_record_number : $nextMRN; ?>"
                                                            required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Nama Lengkap
                                                            <?php echo getRequiredFieldMarker(); ?></label>
                                                        <input type="text" class="form-control" name="name"
                                                            value="<?php echo $name; ?>" required>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Tanggal Lahir
                                                            <?php echo getRequiredFieldMarker(); ?></label>
                                                        <input type="text" class="form-control datepicker"
                                                            name="birth_date"
                                                            value="<?php echo formatDate($birth_date); ?>" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Jenis Kelamin
                                                            <?php echo getRequiredFieldMarker(); ?></label>
                                                        <select class="form-control" name="gender" required>
                                                            <option value="" disabled selected>Pilih Jenis Kelamin
                                                            </option>
                                                            <option value="Laki-laki"
                                                                <?php echo $gender === 'Laki-laki' ? 'selected' : ''; ?>>
                                                                Laki-laki</option>
                                                            <option value="Perempuan"
                                                                <?php echo $gender === 'Perempuan' ? 'selected' : ''; ?>>
                                                                Perempuan</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label>Alamat</label>
                                                        <textarea class="form-control"
                                                            name="address"><?php echo $address; ?></textarea>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Nomor Telepon</label>
                                                        <input type="text" class="form-control" name="phone_number"
                                                            value="<?php echo $phone_number; ?>">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Email</label>
                                                        <input type="email" class="form-control" name="email"
                                                            value="<?php echo $email; ?>">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Pekerjaan</label>
                                                        <input type="text" class="form-control" name="occupation"
                                                            value="<?php echo $occupation; ?>">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group row mb-4">
                                                <div class="col-md-12 text-right">
                                                    <button type="submit" class="btn btn-primary">Simpan Data
                                                        Pasien</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>

            <!-- Footer -->
            <?php include '../layouts/footer.php'; ?>
        </div>
    </div>

    <!-- General JS Scripts -->
    <script src="../assets/modules/jquery.min.js"></script>
    <script src="../assets/modules/popper.js"></script>
    <script src="../assets/modules/tooltip.js"></script>
    <script src="../assets/modules/bootstrap/js/bootstrap.min.js"></script>
    <script src="../assets/modules/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="../assets/modules/moment.min.js"></script>
    <script src="../assets/js/stisla.js"></script>

    <!-- JS Libraies -->
    <script src="../assets/modules/select2/dist/js/select2.full.min.js"></script>
    <script src="../assets/modules/bootstrap-daterangepicker/daterangepicker.js"></script>

    <!-- Page Specific JS File -->
    <script>
    $(document).ready(function() {
        // Initialize select2
        $('.select2').select2();

        // Initialize datepicker
        $('.datepicker').daterangepicker({
            locale: {
                format: 'DD-MM-YYYY',
                applyLabel: 'Pilih',
                cancelLabel: 'Batal',
                daysOfWeek: ['Min', 'Sen', 'Sel', 'Rab', 'Kam', 'Jum', 'Sab'],
                monthNames: ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus',
                    'September', 'Oktober', 'November', 'Desember'
                ],
                firstDay: 1
            },
            singleDatePicker: true,
            showDropdowns: true,
            autoApply: true
        });
    });
    </script>

    <!-- Template JS File -->
    <script src="../assets/js/scripts.js"></script>
    <script src="../assets/js/custom.js"></script>
</body>

</html>