<?php
// Include initialization file
require_once '../init.php';

// Check if user is logged in
if (!isLoggedIn()) {
    redirect('../auth/login.php');
}

// Check if user is admin (only admins can delete patients)
if (!isAdmin()) {
    setFlashMessage('Anda tidak memiliki izin untuk menghapus data pasien.', 'danger');
    redirect('index.php');
}

// Check if ID is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    setFlashMessage('ID pasien tidak valid.', 'danger');
    redirect('index.php');
}

$patientId = intval($_GET['id']);

// Get patient data to confirm deletion
$patient = $db->getRow("SELECT * FROM patients WHERE id = ?i", $patientId);

if (!$patient) {
    setFlashMessage('Pasien tidak ditemukan.', 'danger');
    redirect('index.php');
}

// Check if there are any medical records for this patient
$hasMedicalRecords = $db->getOne("SELECT COUNT(*) FROM medical_records WHERE patient_id = ?i", $patientId);

if ($hasMedicalRecords > 0) {
    setFlashMessage('Pasien tidak dapat dihapus karena memiliki rekam medis. Hapus rekam medis terlebih dahulu.', 'danger');
    redirect('index.php');
}

// Check if deletion is confirmed
if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes') {
    // Delete patient
    $result = $db->query("DELETE FROM patients WHERE id = ?i", $patientId);
    
    if ($result) {
        // Log the deletion
        logActivity('Menghapus pasien: ' . $patient['name'] . ' (ID: ' . $patientId . ')');
        
        setFlashMessage('Pasien berhasil dihapus.', 'success');
        redirect('index.php');
    } else {
        setFlashMessage('Terjadi kesalahan saat menghapus pasien.', 'danger');
        redirect('index.php');
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
  <title>Hapus Pasien &mdash; Sistem Rekam Medis Ortodontik</title>

  <!-- General CSS Files -->
  <link rel="stylesheet" href="../assets/modules/bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/modules/fontawesome/css/all.min.css">

  <!-- Template CSS -->
  <link rel="stylesheet" href="../assets/css/style.css">
  <link rel="stylesheet" href="../assets/css/components.css">
</head>

<body>
  <div id="app">
    <div class="main-wrapper main-wrapper-1">
      <!-- Header -->
      <?php include '../layouts/header.php'; ?>

      <!-- Sidebar -->
      <?php include '../layouts/sidebar.php'; ?>

      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1>Hapus Pasien</h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="../index.php">Dashboard</a></div>
              <div class="breadcrumb-item"><a href="index.php">Data Pasien</a></div>
              <div class="breadcrumb-item">Hapus Pasien</div>
            </div>
          </div>

          <div class="section-body">
            <h2 class="section-title">Konfirmasi Penghapusan</h2>
            <p class="section-lead">
              Anda akan menghapus data pasien. Tindakan ini tidak dapat dibatalkan.
            </p>

            <div class="row">
              <div class="col-12">
                <div class="card">
                  <div class="card-header">
                    <h4>Informasi Pasien yang Akan Dihapus</h4>
                  </div>
                  <div class="card-body">
                    <div class="alert alert-danger">
                      <p>Anda akan menghapus pasien dengan data berikut:</p>
                      <ul>
                        <li><strong>Nama:</strong> <?php echo $patient['name']; ?></li>
                        <li><strong>Nomor Rekam Medis:</strong> <?php echo $patient['medical_record_number']; ?></li>
                        <li><strong>Tanggal Lahir:</strong> <?php echo formatDate($patient['birth_date']); ?></li>
                        <li><strong>Jenis Kelamin:</strong> <?php echo $patient['gender']; ?></li>
                      </ul>
                      <p>Tindakan ini akan menghapus semua data pasien dan tidak dapat dibatalkan. Apakah Anda yakin ingin melanjutkan?</p>
                    </div>
                    
                    <div class="text-right">
                      <a href="index.php" class="btn btn-secondary mr-2">Batal</a>
                      <a href="delete.php?id=<?php echo $patientId; ?>&confirm=yes" class="btn btn-danger">Hapus Pasien</a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
      </div>
      
      <!-- Footer -->
      <?php include '../layouts/footer.php'; ?>
    </div>
  </div>

  <!-- General JS Scripts -->
  <script src="../assets/modules/jquery.min.js"></script>
  <script src="../assets/modules/popper.js"></script>
  <script src="../assets/modules/tooltip.js"></script>
  <script src="../assets/modules/bootstrap/js/bootstrap.min.js"></script>
  <script src="../assets/modules/nicescroll/jquery.nicescroll.min.js"></script>
  <script src="../assets/modules/moment.min.js"></script>
  <script src="../assets/js/stisla.js"></script>
  
  <!-- Template JS File -->
  <script src="../assets/js/scripts.js"></script>
  <script src="../assets/js/custom.js"></script>
</body>
</html> 