<?php
// Include initialization file
require_once '../init.php';

// Check if user is logged in
if (!isLoggedIn()) {
    redirect('../auth/login.php');
}

// Get all patients
$patients = $db->getAll("SELECT * FROM patients ORDER BY name ASC");
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title>Data Pasien &mdash; Sistem Rekam Medis Ortodontik</title>

    <!-- General CSS Files -->
    <link rel="stylesheet" href="../assets/modules/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/modules/fontawesome/css/all.min.css">

    <!-- CSS Libraries -->
    <link rel="stylesheet" href="../assets/modules/datatables/datatables.min.css">
    <link rel="stylesheet" href="../assets/modules/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="../assets/modules/datatables/Select-1.2.4/css/select.bootstrap4.min.css">

    <!-- Template CSS -->
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/components.css">
</head>

<body>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <!-- Header -->
            <?php include '../layouts/header.php'; ?>

            <!-- Sidebar -->
            <?php include '../layouts/sidebar.php'; ?>

            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="section-header">
                        <h1>Data Pasien</h1>
                        <div class="section-header-button">
                            <a href="create.php" class="btn btn-primary">Tambah Pasien Baru</a>
                        </div>
                        <div class="section-header-breadcrumb">
                            <div class="breadcrumb-item active"><a href="../index.php">Dashboard</a></div>
                            <div class="breadcrumb-item">Data Pasien</div>
                        </div>
                    </div>

                    <div class="section-body">
                        <h2 class="section-title">Daftar Pasien</h2>
                        <p class="section-lead">
                            Daftar seluruh pasien yang terdaftar dalam sistem.
                        </p>

                        <div class="card">
                            <div class="card-header">
                                <h4>Daftar Pasien</h4>
                            </div>
                            <div class="card-body">
                                <?php echo getFlashMessage(); ?>

                                <div class="table-responsive">
                                    <table class="table table-striped" id="table-patients">
                                        <thead>
                                            <tr>
                                                <th>No. RM</th>
                                                <th>Nama</th>
                                                <th>Tanggal Lahir</th>
                                                <th>Usia</th>
                                                <th>Jenis Kelamin</th>
                                                <th>Alamat</th>
                                                <th>No. Telepon</th>
                                                <th>Aksi</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($patients as $patient): ?>
                                            <tr>
                                                <td><?php echo $patient['medical_record_number']; ?></td>
                                                <td><?php echo $patient['name']; ?></td>
                                                <td><?php echo formatDate($patient['birth_date']); ?></td>
                                                <td><?php echo calculateAge($patient['birth_date']); ?> tahun</td>
                                                <td><?php echo $patient['gender']; ?></td>
                                                <td><?php echo $patient['address']; ?></td>
                                                <td><?php echo $patient['phone_number']; ?></td>
                                                <td>
                                                    <div class="dropdown">
                                                        <button class="btn btn-primary dropdown-toggle" type="button"
                                                            id="dropdownMenuButton" data-toggle="dropdown"
                                                            aria-haspopup="true" aria-expanded="false">
                                                            Aksi
                                                        </button>
                                                        <div class="dropdown-menu">
                                                            <a class="dropdown-item"
                                                                href="view.php?id=<?php echo $patient['id']; ?>">
                                                                <i class="fas fa-eye"></i> Lihat
                                                            </a>
                                                            <a class="dropdown-item"
                                                                href="edit.php?id=<?php echo $patient['id']; ?>">
                                                                <i class="fas fa-edit"></i> Edit
                                                            </a>
                                                            <a class="dropdown-item"
                                                                href="../medical_records/create.php?patient_id=<?php echo $patient['id']; ?>">
                                                                <i class="fas fa-plus"></i> Tambah Rekam Medis
                                                            </a>
                                                            <a class="dropdown-item"
                                                                href="../medical_records/index.php?patient_id=<?php echo $patient['id']; ?>">
                                                                <i class="fas fa-file-medical"></i> Lihat Rekam Medis
                                                            </a>
                                                            <div class="dropdown-divider"></div>
                                                            <a class="dropdown-item text-danger" href="#"
                                                                onclick="confirmDelete(<?php echo $patient['id']; ?>, '<?php echo $patient['name']; ?>')">
                                                                <i class="fas fa-trash"></i> Hapus
                                                            </a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>

            <!-- Footer -->
            <?php include '../layouts/footer.php'; ?>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Konfirmasi Hapus</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Anda yakin ingin menghapus pasien <strong id="patientName"></strong>?</p>
                    <p class="text-danger">Perhatian: Tindakan ini akan menghapus semua rekam medis terkait pasien ini
                        dan tidak dapat dibatalkan!</p>
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="delete.php" method="POST">
                        <input type="hidden" name="id" id="patientId" value="">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-danger">Hapus</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- General JS Scripts -->
    <script src="../assets/modules/jquery.min.js"></script>
    <script src="../assets/modules/popper.js"></script>
    <script src="../assets/modules/tooltip.js"></script>
    <script src="../assets/modules/bootstrap/js/bootstrap.min.js"></script>
    <script src="../assets/modules/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="../assets/modules/moment.min.js"></script>
    <script src="../assets/js/stisla.js"></script>

    <!-- JS Libraies -->
    <script src="../assets/modules/datatables/datatables.min.js"></script>
    <script src="../assets/modules/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js"></script>
    <script src="../assets/modules/datatables/Select-1.2.4/js/dataTables.select.min.js"></script>
    <script src="../assets/modules/jquery-ui/jquery-ui.min.js"></script>
    <script src="../assets/modules/sweetalert/sweetalert.min.js"></script>

    <!-- Page Specific JS File -->
    <script>
    $(document).ready(function() {
        // Initialize DataTable
        $('#table-patients').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json"
            }
        });
    });

    // Confirm delete function
    function confirmDelete(id, name) {
        $('#patientId').val(id);
        $('#patientName').text(name);
        $('#deleteModal').modal('show');
    }
    </script>

    <!-- Template JS File -->
    <script src="../assets/js/scripts.js"></script>
    <script src="../assets/js/custom.js"></script>
</body>

</html>